/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.endpointransfermapper;

import com.vaadin.hilla.endpointransfermapper.PageMapper;
import com.vaadin.hilla.endpointransfermapper.PageableMapper;
import com.vaadin.hilla.endpointransfermapper.UUIDMapper;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.deser.std.StdConvertingDeserializer;
import tools.jackson.databind.module.SimpleModule;
import tools.jackson.databind.node.POJONode;
import tools.jackson.databind.ser.std.StdDelegatingSerializer;
import tools.jackson.databind.type.TypeFactory;
import tools.jackson.databind.util.Converter;
import tools.jackson.databind.util.StdConverter;

public class EndpointTransferMapper {
    private Map<Class<?>, Class<?>> endpointToTransfer = new HashMap();
    private Map<Class<?>, Mapper<?, ?>> mappers = new HashMap();
    private final SimpleModule jacksonModule = new SimpleModule();

    public EndpointTransferMapper() {
        this.registerMapper(new PageableMapper());
        this.registerMapper(new UUIDMapper());
        this.registerMapper(new PageMapper());
    }

    private <ENDPOINTTYPE, TRANSFERTYPE> void registerMapper(final Mapper<ENDPOINTTYPE, TRANSFERTYPE> mapper) {
        final Class<ENDPOINTTYPE> endpointType = mapper.getEndpointType();
        final Class<TRANSFERTYPE> transferType = mapper.getTransferType();
        this.endpointToTransfer.put(endpointType, mapper.getTransferType());
        this.mappers.put(endpointType, mapper);
        StdDelegatingSerializer serializer = new StdDelegatingSerializer((Converter)new StdConverter<ENDPOINTTYPE, TRANSFERTYPE>(this){

            public TRANSFERTYPE convert(ENDPOINTTYPE value) {
                return mapper.toTransferType(value);
            }

            public JavaType getInputType(TypeFactory typeFactory) {
                return typeFactory.constructType((Type)endpointType);
            }

            public JavaType getOutputType(TypeFactory typeFactory) {
                return typeFactory.constructType((Type)transferType);
            }
        });
        this.jacksonModule.addSerializer(endpointType, (ValueSerializer)serializer);
        StdConverter converter = new StdConverter<TRANSFERTYPE, ENDPOINTTYPE>(this){

            public ENDPOINTTYPE convert(TRANSFERTYPE value) {
                return mapper.toEndpointType(value);
            }

            public JavaType getInputType(TypeFactory typeFactory) {
                return typeFactory.constructType((Type)transferType);
            }

            public JavaType getOutputType(TypeFactory typeFactory) {
                return typeFactory.constructType((Type)endpointType);
            }
        };
        StdConvertingDeserializer deserializer = new StdConvertingDeserializer((Converter)converter);
        this.jacksonModule.addDeserializer(endpointType, (ValueDeserializer)deserializer);
        this.jacksonModule.addDeserializer(MultipartFile.class, (ValueDeserializer)new MultipartFileDeserializer());
    }

    public JacksonModule getJacksonModule() {
        return this.jacksonModule;
    }

    public Class<?> getTransferType(Class<?> endpointType) {
        for (Map.Entry<Class<?>, Class<?>> entry : this.endpointToTransfer.entrySet()) {
            if (!entry.getKey().isAssignableFrom(endpointType)) continue;
            return entry.getValue();
        }
        return null;
    }

    public String getTransferType(String endpointType) {
        for (Map.Entry<Class<?>, Class<?>> entry : this.endpointToTransfer.entrySet()) {
            if (!entry.getKey().getName().equals(endpointType)) continue;
            return entry.getValue().getName();
        }
        return null;
    }

    public <T> Mapper getMapper(Class<T> endpointType) {
        for (Class<T> clazz : this.endpointToTransfer.keySet()) {
            if (!clazz.isAssignableFrom(endpointType)) continue;
            return this.mappers.get(clazz);
        }
        return null;
    }

    public Object toTransferType(Object endpointValue) {
        if (endpointValue == null) {
            return null;
        }
        Class<?> endpointValueType = endpointValue.getClass();
        Mapper mapper = this.getMapper(endpointValueType);
        if (mapper == null) {
            return endpointValue;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Mapping from endpoint type ({}) to transfer type ({})", (Object)endpointValueType.getName(), (Object)mapper.getTransferType().getName());
        }
        return mapper.toTransferType(endpointValue);
    }

    public <T> T toEndpointType(Object transferValue, Class<T> endpointType) {
        if (transferValue == null) {
            return null;
        }
        Mapper mapper = this.getMapper(endpointType);
        if (mapper == null) {
            return (T)transferValue;
        }
        this.getLogger().debug("Mapping from transfer type (" + transferValue.getClass().getName() + ") to endpoint type (" + endpointType.getName() + ")");
        return (T)mapper.toEndpointType(transferValue);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    public static interface Mapper<ENDPOINTTYPE, TRANSFERTYPE> {
        public Class<? extends ENDPOINTTYPE> getEndpointType();

        public Class<? extends TRANSFERTYPE> getTransferType();

        public TRANSFERTYPE toTransferType(ENDPOINTTYPE var1);

        public ENDPOINTTYPE toEndpointType(TRANSFERTYPE var1);
    }

    public static class MultipartFileDeserializer
    extends ValueDeserializer<MultipartFile> {
        public MultipartFile deserialize(JsonParser p, DeserializationContext ctxt) {
            Object pojo;
            JsonNode node = (JsonNode)p.readValueAsTree();
            if (node instanceof POJONode && (pojo = ((POJONode)node).getPojo()) instanceof MultipartFile) {
                return (MultipartFile)pojo;
            }
            throw new RuntimeException("Expected a POJONode wrapping a MultipartFile");
        }
    }
}

