/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla;

import com.vaadin.hilla.engine.EngineAutoConfiguration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public class OpenAPIUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAPIUtil.class);

    public static String getCurrentOpenAPI(Path buildDirectory, boolean isProductionMode) throws IOException {
        Optional<Path> openAPIPath = OpenAPIUtil.getCurrentOpenAPIPath(buildDirectory, isProductionMode);
        if (openAPIPath.isEmpty()) {
            LOGGER.debug("Trying to read the non-existing OpenApi json file. Empty string is returned.");
            return "";
        }
        return Files.readString(openAPIPath.get());
    }

    public static Optional<Path> getCurrentOpenAPIPath(Path buildDirectory, boolean isProductionMode) throws IOException {
        EngineAutoConfiguration engineConfiguration = new EngineAutoConfiguration.Builder().buildDir(buildDirectory).productionMode(isProductionMode).withDefaultAnnotations().build();
        return Optional.of(engineConfiguration.getOpenAPIFile());
    }

    public static Set<String> findOpenApiClasses(String openApiAsText) throws IOException {
        JsonNode schemasNode;
        JsonNode components;
        ArrayNode tags;
        JsonNode openApi = new ObjectMapper().readTree(openApiAsText);
        HashSet<String> types = new HashSet<String>();
        if (openApi.has("tags") && (tags = (ArrayNode)openApi.get("tags")) != null) {
            tags.forEach(nameAndClass -> types.add(nameAndClass.get("x-class-name").asText()));
        }
        if (openApi.has("components") && (components = openApi.get("components")) != null && components.has("schemas") && (schemasNode = components.get("schemas")) instanceof ObjectNode) {
            ObjectNode schemas = (ObjectNode)schemasNode;
            for (String type : schemas.propertyNames()) {
                types.add(type);
            }
        }
        return types;
    }
}

