/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.spring.security.VaadinRolePrefixHolder;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class AuthenticationUtil {
    public static Authentication getSecurityHolderAuthentication() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof AnonymousAuthenticationToken) {
            return null;
        }
        return authentication;
    }

    public static Function<String, Boolean> getSecurityHolderRoleChecker() {
        String rolePrefix = Optional.ofNullable(VaadinService.getCurrent()).map(service -> (Lookup)service.getContext().getAttribute(Lookup.class)).map(lookup -> (VaadinRolePrefixHolder)lookup.lookup(VaadinRolePrefixHolder.class)).map(VaadinRolePrefixHolder::getRolePrefix).orElse("ROLE_");
        return AuthenticationUtil.getSecurityHolderRoleChecker(rolePrefix);
    }

    public static Function<String, Boolean> getSecurityHolderRoleChecker(String rolePrefix) {
        Authentication authentication = AuthenticationUtil.getSecurityHolderAuthentication();
        if (authentication == null) {
            return role -> false;
        }
        return role -> {
            String roleWithPrefix = rolePrefix != null && role != null && !role.startsWith(rolePrefix) ? rolePrefix + role : role;
            return authentication.getAuthorities().stream().anyMatch(grantedAuthority -> grantedAuthority.getAuthority().equals(roleWithPrefix));
        };
    }
}

