/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.startup;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.menu.MenuRegistry;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.SynchronizedRequestHandler;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.auth.NavigationAccessControl;
import com.vaadin.flow.server.auth.ViewAccessChecker;
import com.vaadin.flow.server.communication.IndexHtmlRequestListener;
import com.vaadin.hilla.HillaStats;
import com.vaadin.hilla.route.RouteUnifyingConfigurationProperties;
import com.vaadin.hilla.route.RouteUnifyingIndexHtmlRequestListener;
import com.vaadin.hilla.route.RouteUtil;
import com.vaadin.hilla.route.ServerAndClientViewsProvider;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class RouteUnifyingServiceInitListener
implements VaadinServiceInitListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteUnifyingServiceInitListener.class);
    private final RouteUnifyingConfigurationProperties routeUnifyingConfigurationProperties;
    private final NavigationAccessControl accessControl;
    private final ViewAccessChecker viewAccessChecker;
    private final RouteUtil routeUtil;

    @Autowired
    public RouteUnifyingServiceInitListener(RouteUtil routeUtil, RouteUnifyingConfigurationProperties routeUnifyingConfigurationProperties, @Nullable NavigationAccessControl accessControl, @Nullable ViewAccessChecker viewAccessChecker) {
        this.routeUtil = routeUtil;
        this.routeUnifyingConfigurationProperties = routeUnifyingConfigurationProperties;
        this.accessControl = accessControl;
        this.viewAccessChecker = viewAccessChecker;
    }

    public void serviceInit(ServiceInitEvent event) {
        DeploymentConfiguration deploymentConfiguration = event.getSource().getDeploymentConfiguration();
        LOGGER.debug("deploymentConfiguration.isReactEnabled() = {}", (Object)deploymentConfiguration.isReactEnabled());
        boolean hasHillaFsRoute = false;
        if (deploymentConfiguration.isReactEnabled()) {
            final ServerAndClientViewsProvider serverAndClientViewsProvider = new ServerAndClientViewsProvider(deploymentConfiguration, this.accessControl, this.viewAccessChecker, this.routeUnifyingConfigurationProperties.isExposeServerRoutesToClient());
            RouteUnifyingIndexHtmlRequestListener routeUnifyingIndexHtmlRequestListener = new RouteUnifyingIndexHtmlRequestListener(serverAndClientViewsProvider);
            String deploymentMode = deploymentConfiguration.isProductionMode() ? "PRODUCTION" : "DEVELOPMENT";
            event.addIndexHtmlRequestListener((IndexHtmlRequestListener)routeUnifyingIndexHtmlRequestListener);
            if (!deploymentConfiguration.isProductionMode()) {
                event.addRequestHandler((RequestHandler)new SynchronizedRequestHandler(){

                    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
                        if ("routeinfo".equals(request.getParameter("v-r"))) {
                            response.setContentType("application/json; charset=UTF-8");
                            response.getWriter().write(serverAndClientViewsProvider.createFileRoutesJson(request));
                            return true;
                        }
                        return false;
                    }
                });
            }
            LOGGER.debug("{} mode: Registered RouteUnifyingIndexHtmlRequestListener.", (Object)deploymentMode);
            Map clientMenus = MenuRegistry.collectClientMenuItems((boolean)false, (AbstractConfiguration)deploymentConfiguration, null);
            hasHillaFsRoute = !clientMenus.isEmpty();
        }
        HillaStats.reportGenericHasFeatures(event.getSource(), hasHillaFsRoute);
    }
}

