/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.ai.formfiller.utils;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.checkbox.CheckboxGroup;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.combobox.MultiSelectComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.datetimepicker.DateTimePicker;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.listbox.MultiSelectListBox;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.BigDecimalField;
import com.vaadin.flow.component.textfield.EmailField;
import com.vaadin.flow.component.textfield.IntegerField;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.PasswordField;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.timepicker.TimePicker;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentUtils {
    private static final Logger logger = LoggerFactory.getLogger(ComponentUtils.class);

    public static ComponentsMapping createMapping(Component component) {
        List<ComponentInfo> componentInfoList = ComponentUtils.getComponentInfo(component);
        ComponentsMapping mapping = new ComponentsMapping(componentInfoList, ComponentUtils.buildHierarchy(componentInfoList), ComponentUtils.buildTypes(componentInfoList));
        return mapping;
    }

    public static List<ComponentInfo> getComponentInfo(Component component) {
        ArrayList<ComponentInfo> componentInfoList = new ArrayList<ComponentInfo>();
        if (ComponentUtils.isSupportedAndAccepted(component)) {
            componentInfoList.add(new ComponentInfo(component.getId().orElse(null), component.getClass().getSimpleName(), component));
        }
        ComponentUtils.findChildComponents(component, componentInfoList);
        return componentInfoList;
    }

    private static void findChildComponents(Component component, List<ComponentInfo> componentInfoList) {
        component.getChildren().forEach(childComponent -> {
            if (ComponentUtils.isSupportedAndAccepted(childComponent)) {
                componentInfoList.add(new ComponentInfo(childComponent.getId().orElse(null), childComponent.getClass().getSimpleName(), (Component)childComponent));
            }
            ComponentUtils.findChildComponents(childComponent, componentInfoList);
        });
    }

    private static Map<String, Object> buildHierarchy(List<ComponentInfo> componentInfoList) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        for (ComponentInfo componentInfo : componentInfoList) {
            String id;
            if (componentInfo.type.equalsIgnoreCase("Column") || (id = componentInfo.id) == null || id.isEmpty()) continue;
            if (componentInfo.component instanceof Grid || componentInfo.component instanceof MultiSelectListBox) {
                if (componentInfo.component instanceof Grid) {
                    Grid grid = (Grid)componentInfo.component;
                    if (grid.getBeanType() == null) {
                        logger.error("Grid with id {} must define a Bean Type to be used with FormFiller", (Object)grid.getId());
                        continue;
                    }
                    HashMap<String, String> columns = new HashMap<String, String>(Arrays.stream(grid.getBeanType().getDeclaredFields()).collect(Collectors.toMap(Field::getName, f -> "")));
                    ArrayList<HashMap<String, String>> listColumns = new ArrayList<HashMap<String, String>>();
                    listColumns.add(columns);
                    json.put(id, listColumns);
                    continue;
                }
                json.put(id, new ArrayList());
                continue;
            }
            json.put(id, "");
        }
        return json;
    }

    private static Map<String, String> buildTypes(List<ComponentInfo> componentInfoList) {
        HashMap<String, String> inputFieldMap = new HashMap<String, String>();
        for (ComponentInfo componentInfo : componentInfoList) {
            try {
                StringJoiner joiner;
                if (componentInfo.component instanceof TextField || componentInfo.component instanceof TextArea || componentInfo.component instanceof EmailField || componentInfo.component instanceof PasswordField) {
                    inputFieldMap.put(componentInfo.id, "a String");
                    continue;
                }
                if (componentInfo.component instanceof NumberField) {
                    inputFieldMap.put(componentInfo.id, "a Number");
                    continue;
                }
                if (componentInfo.component instanceof IntegerField) {
                    inputFieldMap.put(componentInfo.id, "a Integer");
                    continue;
                }
                if (componentInfo.component instanceof BigDecimalField) {
                    inputFieldMap.put(componentInfo.id, "a Double");
                    continue;
                }
                if (componentInfo.component instanceof DatePicker) {
                    inputFieldMap.put(componentInfo.id, "a date using format 'yyyy-MM-dd'");
                    continue;
                }
                if (componentInfo.component instanceof TimePicker) {
                    inputFieldMap.put(componentInfo.id, "a time using format 'HH:mm:ss'");
                    continue;
                }
                if (componentInfo.component instanceof DateTimePicker) {
                    inputFieldMap.put(componentInfo.id, "a date and time using format 'yyyy-MM-ddTHH:mm:ss'");
                    continue;
                }
                if (componentInfo.component instanceof ComboBox) {
                    joiner = new StringJoiner("\" OR \"");
                    ((ComboBox)componentInfo.component).getListDataView().getItems().forEach(joiner::add);
                    inputFieldMap.put(componentInfo.id, "a String from one of these options \"" + joiner + "\"");
                    continue;
                }
                if (componentInfo.component instanceof MultiSelectComboBox) {
                    joiner = new StringJoiner("\", \"");
                    ((MultiSelectComboBox)componentInfo.component).getListDataView().getItems().forEach(joiner::add);
                    inputFieldMap.put(componentInfo.id, "a Set of Strings selecting none, one or more of these options  \"" + joiner + "\"");
                    continue;
                }
                if (componentInfo.component instanceof Checkbox) {
                    inputFieldMap.put(componentInfo.id, "a Boolean");
                    continue;
                }
                if (componentInfo.component instanceof CheckboxGroup) {
                    joiner = new StringJoiner("\", \"");
                    ((CheckboxGroup)componentInfo.component).getListDataView().getItems().forEach(joiner::add);
                    inputFieldMap.put(componentInfo.id, "a Set of Strings selecting none, one or more of these options  \"" + joiner + "\"");
                    continue;
                }
                if (componentInfo.component instanceof RadioButtonGroup) {
                    joiner = new StringJoiner("\" OR \"");
                    ((RadioButtonGroup)componentInfo.component).getListDataView().getItems().forEach(joiner::add);
                    inputFieldMap.put(componentInfo.id, "a String from one of these options \"" + joiner + "\"");
                    continue;
                }
                if (componentInfo.component instanceof Grid.Column || !(componentInfo.component instanceof Grid)) continue;
                Grid inspectedComponent = (Grid)componentInfo.component;
                for (Field f : inspectedComponent.getBeanType().getDeclaredFields()) {
                    if (f.getType().getSimpleName().equalsIgnoreCase("Date") || f.getType().getSimpleName().equalsIgnoreCase("LocalDate")) {
                        inputFieldMap.put(f.getName(), "a date using format 'yyyy-MM-dd'");
                        continue;
                    }
                    if (f.getType().getSimpleName().equalsIgnoreCase("Time") || f.getType().getSimpleName().equalsIgnoreCase("LocalTime")) {
                        inputFieldMap.put(f.getName(), "a time using format 'HH:mm:ss'");
                        continue;
                    }
                    if (f.getType().getSimpleName().equalsIgnoreCase("DateTime") || f.getType().getSimpleName().equalsIgnoreCase("LocalDateTime")) {
                        inputFieldMap.put(f.getName(), "a date and time using format 'yyyy-MM-ddTHH:mm:ss'");
                        continue;
                    }
                    if (f.getType().getSimpleName().equalsIgnoreCase("Boolean")) {
                        inputFieldMap.put(f.getName(), "a Boolean");
                        continue;
                    }
                    if (f.getType().getSimpleName().equalsIgnoreCase("Integer") || f.getType().getSimpleName().equalsIgnoreCase("Long") || f.getType().getSimpleName().equalsIgnoreCase("Double") || f.getType().getSimpleName().equalsIgnoreCase("Float")) {
                        inputFieldMap.put(f.getName(), "a Number");
                        continue;
                    }
                    inputFieldMap.put(f.getName(), "a String");
                }
            }
            catch (Exception e) {
                logger.error("Error while inferring type of componentComponent: " + componentInfo.id + " - " + componentInfo.component.getClass().getSimpleName());
            }
        }
        return inputFieldMap;
    }

    public static Stream<Component> getAllChildren(Component component) {
        return Stream.concat(Stream.of(component), component.getChildren().flatMap(ComponentUtils::getAllChildren));
    }

    public static void fillComponents(List<ComponentInfo> components, Map<String, Object> mapComponentValues) {
        for (ComponentInfo componentInfo : components) {
            if (componentInfo.component.getId().orElse(null) == null) {
                logger.warn("Component has no id so it will be skipped: {}", (Object)componentInfo.component);
                continue;
            }
            if (!ComponentUtils.isSupportedComponent(componentInfo.component)) {
                logger.warn("Component type is not supported, this should have been discarded, while building the types/id-s componentInfo in the getComponentInfo() method, but somehow still got JSON value: {}", (Object)componentInfo.component.getClass().getSimpleName());
                continue;
            }
            String id = componentInfo.component.getId().orElse(null);
            try {
                HashSet set;
                ArrayList list;
                Object beanType;
                if (id == null) continue;
                Object responseValue = mapComponentValues.get(id);
                if (responseValue == null) {
                    logger.warn("No response value found for id: {}", (Object)id);
                    continue;
                }
                Component component = componentInfo.component;
                if (component instanceof Grid) {
                    Grid grid = (Grid)component;
                    beanType = grid.getBeanType();
                    try {
                        List items = (List)responseValue;
                        ComponentUtils.fillGridWithWildcards(grid, items, beanType);
                    }
                    catch (Exception e) {
                        logger.error("Error while updating grid with wildcards for bean {} because {}", (Object)((Class)beanType).getSimpleName(), (Object)e.getMessage());
                    }
                    continue;
                }
                beanType = componentInfo.component;
                if (beanType instanceof TextField) {
                    TextField textField = (TextField)beanType;
                    textField.setValue(responseValue.toString());
                    continue;
                }
                beanType = componentInfo.component;
                if (beanType instanceof TextArea) {
                    TextArea textArea = (TextArea)beanType;
                    textArea.setValue(responseValue.toString());
                    continue;
                }
                beanType = componentInfo.component;
                if (beanType instanceof NumberField) {
                    NumberField numberField = (NumberField)beanType;
                    numberField.setValue((Number)Double.valueOf(responseValue.toString()));
                    continue;
                }
                beanType = componentInfo.component;
                if (beanType instanceof BigDecimalField) {
                    BigDecimalField bdField = (BigDecimalField)beanType;
                    bdField.setValue(BigDecimal.valueOf(Double.parseDouble(responseValue.toString())));
                    continue;
                }
                beanType = componentInfo.component;
                if (beanType instanceof IntegerField) {
                    IntegerField integerField = (IntegerField)beanType;
                    integerField.setValue((Number)Integer.valueOf(responseValue.toString()));
                    continue;
                }
                beanType = componentInfo.component;
                if (beanType instanceof EmailField) {
                    EmailField emailField = (EmailField)beanType;
                    emailField.setValue(responseValue.toString());
                    continue;
                }
                beanType = componentInfo.component;
                if (beanType instanceof PasswordField) {
                    PasswordField passwordField = (PasswordField)beanType;
                    passwordField.setValue(responseValue.toString());
                    continue;
                }
                beanType = componentInfo.component;
                if (beanType instanceof DatePicker) {
                    DatePicker datePicker = (DatePicker)beanType;
                    datePicker.setValue(LocalDate.parse(responseValue.toString()));
                    continue;
                }
                beanType = componentInfo.component;
                if (beanType instanceof TimePicker) {
                    TimePicker timePicker = (TimePicker)beanType;
                    timePicker.setValue(LocalTime.parse(responseValue.toString()));
                    continue;
                }
                beanType = componentInfo.component;
                if (beanType instanceof DateTimePicker) {
                    DateTimePicker datetimePicker = (DateTimePicker)beanType;
                    datetimePicker.setValue(LocalDateTime.parse(responseValue.toString()));
                    continue;
                }
                beanType = componentInfo.component;
                if (beanType instanceof ComboBox) {
                    ComboBox comboBox = (ComboBox)beanType;
                    if (comboBox.isAllowCustomValue()) {
                        comboBox.setValue(responseValue);
                        continue;
                    }
                    Stream items = comboBox.getGenericDataView().getItems();
                    if (!items.toList().contains(responseValue)) continue;
                    comboBox.setValue(responseValue);
                    continue;
                }
                if (componentInfo.component instanceof MultiSelectComboBox) {
                    MultiSelectComboBox multiSelectComboBox = (MultiSelectComboBox)componentInfo.component;
                    try {
                        list = (ArrayList)responseValue;
                        set = new HashSet(list);
                        if (multiSelectComboBox.isAllowCustomValue()) {
                            multiSelectComboBox.setValue(set);
                            continue;
                        }
                        multiSelectComboBox.setValue(set.stream().filter(multiSelectComboBox.getGenericDataView().getItems().toList()::contains).collect(Collectors.toSet()));
                    }
                    catch (Exception e) {
                        logger.error("Error while updating multiSelectComboBox with id: {}", (Object)id, (Object)e);
                    }
                    continue;
                }
                if (componentInfo.component instanceof Checkbox) {
                    Checkbox checkbox = (Checkbox)componentInfo.component;
                    checkbox.setValue((Object)((Boolean)responseValue));
                    continue;
                }
                if (componentInfo.component instanceof CheckboxGroup) {
                    CheckboxGroup checkboxgroup = (CheckboxGroup)componentInfo.component;
                    try {
                        list = (ArrayList)responseValue;
                        set = new HashSet(list);
                        checkboxgroup.setValue(set);
                    }
                    catch (Exception e) {
                        logger.error("Error while updating checkboxgroup with id: {}", (Object)id, (Object)e);
                    }
                    continue;
                }
                if (componentInfo.component instanceof RadioButtonGroup) {
                    RadioButtonGroup radioButtonGroup = (RadioButtonGroup)componentInfo.component;
                    radioButtonGroup.setValue((Object)responseValue.toString());
                    continue;
                }
                if (componentInfo.component instanceof Grid.Column) continue;
                if (componentInfo.component instanceof HasValue) {
                    HasValue hasValue = (HasValue)componentInfo.component;
                    hasValue.setValue((Object)responseValue.toString());
                    continue;
                }
                logger.warn("Component type not supported: {}", (Object)componentInfo.component.getClass().getSimpleName());
            }
            catch (Exception e) {
                logger.error("Error while updating component with id: {} Cause: {}", (Object)id, (Object)e.getMessage());
            }
        }
    }

    private static <T> void fillGridWithWildcards(Grid<T> grid, List<Map<String, Object>> items, Class<?> beanType) {
        ComponentUtils.fillGrid(grid, items, beanType);
    }

    private static <T> void fillGrid(Grid<T> grid, List<Map<String, Object>> items, Class<T> itemClass) {
        if (items == null) {
            logger.warn("Items list is null. Skipping the update for the grid.");
            return;
        }
        List gridItems = items.stream().map(itemMap -> {
            Object item;
            try {
                item = itemClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to create a new instance of the Bean class. Please be sure that the Bean has an empty constructor if any non empty constructor is defined.", e);
            }
            for (Map.Entry entry : itemMap.entrySet()) {
                String propName = (String)entry.getKey();
                Object propValue = entry.getValue();
                try {
                    Field field = itemClass.getDeclaredField(propName);
                    field.setAccessible(true);
                    if (field.getType().equals(LocalDate.class)) {
                        field.set(item, LocalDate.parse(propValue.toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                        continue;
                    }
                    if (field.getType().equals(LocalTime.class)) {
                        field.set(item, LocalTime.parse(propValue.toString(), DateTimeFormatter.ofPattern("HH:mm:ss")));
                        continue;
                    }
                    if (field.getType().equals(LocalDateTime.class)) {
                        field.set(item, LocalDateTime.parse(propValue.toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss")));
                        continue;
                    }
                    if (field.getType().equals(Date.class)) {
                        field.set(item, new SimpleDateFormat("yyyy-MM-dd").parse(propValue.toString()));
                        continue;
                    }
                    if (field.getType().equals(Double.class)) {
                        field.set(item, Double.valueOf(propValue.toString()));
                        continue;
                    }
                    if (field.getType().equals(Integer.class)) {
                        field.set(item, Integer.valueOf(propValue.toString()));
                        continue;
                    }
                    if (field.getType().equals(Long.class)) {
                        field.set(item, Long.valueOf(propValue.toString()));
                        continue;
                    }
                    if (field.getType().equals(Float.class)) {
                        field.set(item, Float.valueOf(propValue.toString()));
                        continue;
                    }
                    if (field.getType().equals(Boolean.class)) {
                        field.set(item, Boolean.valueOf(propValue.toString()));
                        continue;
                    }
                    field.set(item, propValue);
                }
                catch (Exception e) {
                    logger.error("Failed to set field value for '{}': {}", (Object)propName, (Object)e.getMessage());
                }
            }
            return item;
        }).collect(Collectors.toList());
        grid.setItems(gridItems);
    }

    public static boolean isSupportedComponent(Component component) {
        return ComponentUtils.supportedComponentStream().anyMatch(c -> c.equals(component.getClass()));
    }

    private static Stream<Class<? extends Component>> supportedComponentStream() {
        return Stream.of(TextField.class, TextArea.class, NumberField.class, BigDecimalField.class, IntegerField.class, EmailField.class, PasswordField.class, DatePicker.class, TimePicker.class, DateTimePicker.class, ComboBox.class, Checkbox.class, CheckboxGroup.class, RadioButtonGroup.class, Grid.class, MultiSelectComboBox.class);
    }

    private static boolean isReadOnly(Component component) {
        if (component instanceof HasValue) {
            return ((HasValue)component).isReadOnly();
        }
        return component.getElement().getProperty("readonly", false);
    }

    private static boolean isSupportedAndAccepted(Component component) {
        if (!component.isVisible()) {
            return false;
        }
        if (component instanceof HasEnabled && !((HasEnabled)component).isEnabled()) {
            return false;
        }
        if (ComponentUtils.isReadOnly(component)) {
            return false;
        }
        if (!ComponentUtils.isSupportedComponent(component)) {
            return false;
        }
        if (component.getId().isEmpty()) {
            logger.warn("Component of type {} has no id. Remember to add a meaningful id to the component if you want to fill it with the FromFiller", (Object)component.getClass().getSimpleName());
            return false;
        }
        return true;
    }

    public record ComponentsMapping(List<ComponentInfo> componentInfoList, Map<String, Object> componentsJSONMap, Map<String, String> componentsTypesJSONMap) implements Serializable
    {
    }

    public record ComponentInfo(String id, String type, Component component) implements Serializable
    {
    }
}

