/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.ai.formfiller.services;

import com.theokanning.openai.completion.chat.ChatCompletionChoice;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatCompletionResult;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.service.OpenAiService;
import com.vaadin.flow.ai.formfiller.services.LLMService;
import com.vaadin.flow.ai.formfiller.utils.KeysUtils;
import com.vaadin.flow.component.Component;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ChatGPTChatCompletionService
extends OpenAiService
implements LLMService {
    private String MODEL = "gpt-3.5-turbo-16k-0613";
    private Integer MAX_TOKENS = 12000;
    private Double TEMPERATURE = 0.0;
    private Boolean ECHO = false;
    private static Integer TIMEOUT = 60;

    public ChatGPTChatCompletionService() {
        super(KeysUtils.getOpenAiKey(), Duration.ofSeconds(TIMEOUT.intValue()));
    }

    @Override
    public String getPromptTemplate(String input, Map<String, Object> objectMap, Map<String, String> typesMap, Map<Component, String> componentInstructions, List<String> contextInstructions) {
        Object gptRequest = String.format("Based on the user input: \n \"%s\", generate a JSON object according to these instructions: Never include duplicate keys, in case of duplicate keys just keep the first occurrence in the response. Fill out \"N/A\" in the JSON value if the user did not specify a value. Return the result as a JSON object in this format: '%s'.", input, objectMap);
        if (!componentInstructions.isEmpty() || !typesMap.isEmpty()) {
            gptRequest = (String)gptRequest + "\nAdditional instructions about some of the JSON fields to be filled: ";
            for (Map.Entry<String, String> entry : typesMap.entrySet()) {
                gptRequest = (String)gptRequest + "\n" + entry.getKey() + ": Format this JSON field as " + entry.getValue() + ".";
            }
            for (Map.Entry<String, String> entry : componentInstructions.entrySet()) {
                if (!((Component)entry.getKey()).getId().isPresent()) continue;
                gptRequest = (String)gptRequest + "\n" + (String)((Component)entry.getKey()).getId().get() + ": " + entry.getValue() + ".";
            }
            if (!contextInstructions.isEmpty()) {
                gptRequest = (String)gptRequest + "\nAdditional instructions about the context and desired JSON output response:  ";
                for (String string : contextInstructions) {
                    gptRequest = (String)gptRequest + " " + string + ".";
                }
            }
        }
        return gptRequest;
    }

    @Override
    public String getGeneratedResponse(String prompt) {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        messages.add(new ChatMessage("user", prompt));
        ChatCompletionRequest chatCompletionRequest = ChatCompletionRequest.builder().messages(messages).model(this.MODEL).maxTokens(this.MAX_TOKENS).temperature(this.TEMPERATURE).build();
        ChatCompletionResult completionResult = this.createChatCompletion(chatCompletionRequest);
        String aiResponse = ((ChatCompletionChoice)completionResult.getChoices().get(0)).getMessage().getContent();
        return aiResponse;
    }
}

