/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.testutil;

import com.vaadin.flow.testcategory.ChromeTests;
import com.vaadin.flow.testutil.DevToolsWrapper;
import com.vaadin.flow.testutil.ViewOrUITest;
import com.vaadin.testbench.TestBench;
import com.vaadin.testbench.parallel.Browser;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ChromeTests.class})
public class ChromeDeviceTest
extends ViewOrUITest {
    private static final Logger log = LoggerFactory.getLogger(ChromeDeviceTest.class);
    private DevToolsWrapper devTools = null;

    protected DevToolsWrapper getDevTools() {
        return this.devTools;
    }

    static boolean isJavaInDebugMode() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp");
    }

    @Before
    public void setup() throws Exception {
        ChromeDriver driver;
        ChromeOptions chromeOptions = this.customizeChromeOptions(new ChromeOptions());
        if (Browser.CHROME == this.getRunLocallyBrowser()) {
            driver = new ChromeDriver(chromeOptions);
        } else {
            log.warn("Forcing Chrome 143.0 for tests using Selenium dev tools to avoid websocket connection issues in CI");
            chromeOptions.setBrowserVersion("143.0");
            URL remoteURL = new URL(this.getHubURL());
            driver = new RemoteWebDriver(remoteURL, (Capabilities)chromeOptions);
            this.setDevToolsRuntimeCapabilities((RemoteWebDriver)driver, remoteURL);
        }
        this.devTools = new DevToolsWrapper((WebDriver)driver);
        this.setDriver((WebDriver)TestBench.createDriver((WebDriver)driver));
    }

    @After
    public void closeDevTools() {
        this.devTools.close();
    }

    protected ChromeOptions customizeChromeOptions(ChromeOptions chromeOptions) {
        HashMap<String, Map<String, Integer>> mobileEmulationParams = new HashMap<String, Map<String, Integer>>();
        mobileEmulationParams.put("deviceMetrics", Map.of("width", 1280, "height", 950, "pixelRatio", 1));
        chromeOptions.setExperimentalOption("mobileEmulation", mobileEmulationParams);
        if (this.getDeploymentHostname().equals("localhost")) {
            if (!ChromeDeviceTest.isJavaInDebugMode()) {
                chromeOptions.addArguments(new String[]{"--headless=new", "--disable-gpu"});
            }
        } else {
            chromeOptions.addArguments(new String[]{String.format("--unsafely-treat-insecure-origin-as-secure=%s", this.getRootURL())});
            chromeOptions.addArguments(new String[]{"--disable-dev-shm-usage"});
        }
        return chromeOptions;
    }

    @Override
    protected List<DesiredCapabilities> getHubBrowsersToTest() {
        return this.getBrowserCapabilities(Browser.CHROME);
    }

    public void waitForServiceWorkerReady() {
        Assert.assertTrue((String)"Should have navigator.serviceWorker", (boolean)((Boolean)this.executeScript("return !!navigator.serviceWorker;", new Object[0])));
        Assert.assertTrue((String)"Should have service worker registered", (boolean)((Boolean)((JavascriptExecutor)this.getDriver()).executeAsyncScript("const done = arguments[arguments.length - 1];const timeout = new Promise(  resolve => setTimeout(resolve, 100000));Promise.race([  navigator.serviceWorker.ready,  timeout]).then(result => done(!!result));", new Object[0])));
    }

    private void setDevToolsRuntimeCapabilities(RemoteWebDriver driver, URL remoteUrl) throws RuntimeException {
        try {
            Field capabilitiesField = RemoteWebDriver.class.getDeclaredField("capabilities");
            capabilitiesField.setAccessible(true);
            String sessionId = driver.getSessionId().toString();
            String devtoolsUrl = String.format("ws://%s:%s/devtools/%s/page", remoteUrl.getHost(), remoteUrl.getPort(), sessionId);
            MutableCapabilities mutableCapabilities = (MutableCapabilities)capabilitiesField.get(driver);
            mutableCapabilities.setCapability("se:cdp", devtoolsUrl);
            mutableCapabilities.setCapability("se:cdpVersion", mutableCapabilities.getBrowserVersion());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to set DevTools capabilities for RemoteWebDriver");
        }
    }
}

