/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.testutil.net;

import com.vaadin.flow.internal.Platform;
import com.vaadin.flow.testutil.net.EphemeralPortRangeDetector;
import com.vaadin.flow.testutil.net.FixedIANAPortRange;
import com.vaadin.flow.testutil.net.LinuxEphemeralPortRangeDetector;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortProber {
    private static InetAddress ipv4All;
    private static InetAddress ipv6All;
    private static final Random random;
    private static final EphemeralPortRangeDetector ephemeralRangeDetector;
    public static final int HIGHEST_PORT = 65535;
    public static final int START_OF_USER_PORTS = 1024;

    private PortProber() {
    }

    public static int findFreePort() {
        for (int i = 0; i < 10; ++i) {
            int seedPort = PortProber.createAcceptablePort();
            int suggestedPort = PortProber.checkPortIsFree(seedPort);
            if (suggestedPort == -1) continue;
            return suggestedPort;
        }
        throw new RuntimeException("Unable to find a free port");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int createAcceptablePort() {
        Random random = PortProber.random;
        synchronized (random) {
            int FIRST_PORT = Math.max(1024, ephemeralRangeDetector.getLowestEphemeralPort());
            int LAST_PORT = Math.min(65535, ephemeralRangeDetector.getHighestEphemeralPort());
            if (LAST_PORT - FIRST_PORT < 5000) {
                FixedIANAPortRange ianaRange = new FixedIANAPortRange();
                FIRST_PORT = ianaRange.getLowestEphemeralPort();
                LAST_PORT = ianaRange.getHighestEphemeralPort();
            }
            if (FIRST_PORT == LAST_PORT) {
                return FIRST_PORT;
            }
            if (FIRST_PORT > LAST_PORT) {
                throw new UnsupportedOperationException("Could not find ephemeral port to use");
            }
            int randomInt = PortProber.random.nextInt();
            int portWithoutOffset = Math.abs(randomInt % (LAST_PORT - FIRST_PORT + 1));
            return portWithoutOffset + FIRST_PORT;
        }
    }

    private static int checkPortIsFree(int port) {
        int validPort = -1;
        try (ServerSocket socket = new ServerSocket();){
            socket.setReuseAddress(true);
            socket.bind(new InetSocketAddress("localhost", port));
            validPort = socket.getLocalPort();
        }
        catch (IOException e) {
            PortProber.getLogger().trace("Port '{}' in use for localhost.", (Object)port);
            return -1;
        }
        try (ServerSocket ipv4socket = new ServerSocket();){
            ipv4socket.bind(new InetSocketAddress(ipv4All, port));
        }
        catch (IOException e) {
            PortProber.getLogger().trace("Port '{}' in use for ipv4 interface.", (Object)port);
            return -1;
        }
        try (ServerSocket ipv6socket = new ServerSocket();){
            ipv6socket.bind(new InetSocketAddress(ipv6All, port));
        }
        catch (IOException e) {
            PortProber.getLogger().trace("Port '{}' in use for ipv6 interface.", (Object)port);
            return -1;
        }
        return validPort;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(PortProber.class);
    }

    static {
        try {
            ipv4All = InetAddress.getByName("0.0.0.0");
            ipv6All = InetAddress.getByName("::0");
        }
        catch (UnknownHostException e) {
            throw new ExceptionInInitializerError(e);
        }
        random = new Random();
        Platform current = Platform.guess();
        ephemeralRangeDetector = current.isLinux() ? LinuxEphemeralPortRangeDetector.getInstance() : new FixedIANAPortRange();
    }
}

