/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.testutil;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Connection;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.SeleniumCdpConnection;
import org.openqa.selenium.devtools.idealized.Domains;
import org.openqa.selenium.devtools.idealized.target.model.SessionID;
import org.openqa.selenium.devtools.idealized.target.model.TargetID;
import org.openqa.selenium.devtools.v142.network.Network;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.http.ClientConfig;

public class DevToolsWrapper {
    private final WebDriver driver;
    private final Duration timeout = Duration.ofSeconds(3L);
    private final HashMap<TargetID, SessionID> attachedTargets = new HashMap();
    private Connection connection = null;
    private DevTools devTools = null;
    private Domains domains = null;

    public DevToolsWrapper(WebDriver driver) {
        this.driver = driver;
    }

    public void setOfflineEnabled(Boolean isEnabled) {
        this.sendToAllTargets(Network.enable(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
        this.sendToAllTargets(Network.emulateNetworkConditions((Boolean)isEnabled, (Number)-1, (Number)-1, (Number)-1, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
    }

    public void setCacheDisabled(Boolean isDisabled) {
        this.sendToAllTargets(Network.enable(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
        this.sendToAllTargets(Network.setCacheDisabled((Boolean)isDisabled));
    }

    public void close() {
        if (this.devTools != null) {
            this.devTools.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    private void createConnectionIfThereIsNotOne() {
        if (this.connection == null) {
            this.connection = (Connection)SeleniumCdpConnection.create((WebDriver)this.driver, (ClientConfig)ClientConfig.defaultConfig()).get();
        }
    }

    private void attachToAllTargets() {
        this.createConnectionIfThereIsNotOne();
        ((List)this.connection.sendAndWait(null, this.getDomains().target().getTargets(), this.timeout)).stream().filter(target -> this.attachedTargets.keySet().stream().noneMatch(t -> t.toString().equals(target.getTargetId().toString()))).forEach(target -> {
            TargetID targetId = target.getTargetId();
            SessionID sessionId = (SessionID)this.connection.sendAndWait(null, this.getDomains().target().attachToTarget(targetId), this.timeout);
            this.attachedTargets.put(targetId, sessionId);
        });
    }

    private <X> void sendToAllTargets(Command<X> command) {
        this.attachToAllTargets();
        for (SessionID sessionId : this.attachedTargets.values()) {
            this.connection.sendAndWait(sessionId, command, this.timeout);
        }
    }

    private DevTools getDevTools() {
        if (this.devTools == null) {
            WebDriver augmented = new Augmenter().augment(this.driver);
            this.devTools = ((HasDevTools)augmented).getDevTools();
        }
        return this.devTools;
    }

    private Domains getDomains() {
        if (this.domains == null) {
            this.domains = this.getDevTools().getDomains();
        }
        return this.domains;
    }
}

