/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.testutil;

import com.vaadin.flow.testutil.AbstractComponentIT;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public abstract class AbstractValidationTest
extends AbstractComponentIT {
    private WebElement field;
    private WebElement invalidate;
    private WebElement validate;

    @Before
    public void init() {
        this.open();
        this.waitForElementPresent(By.id((String)"field"));
        this.field = this.findElement(By.id((String)"field"));
        this.invalidate = this.findElement(By.id((String)"invalidate"));
        this.validate = this.findElement(By.id((String)"validate"));
    }

    @Test
    public void invalidateWhenEmpty() {
        this.scrollIntoViewAndClick(this.invalidate);
        this.assertInvalid();
    }

    @Test
    public void invalidateWhenNotEmpty() {
        this.setValue("not-empty");
        this.scrollIntoViewAndClick(this.invalidate);
        this.assertInvalid();
    }

    @Test
    public void invalidateAndValidateAgain() {
        this.scrollIntoViewAndClick(this.invalidate);
        this.assertInvalid();
        this.scrollIntoViewAndClick(this.validate);
        this.assertValid();
        this.scrollIntoViewAndClick(this.invalidate);
        this.assertInvalid();
    }

    @Test
    public void invalidatewhenEmptyAndThenBlur() {
        this.scrollIntoViewAndClick(this.invalidate);
        this.scrollIntoViewAndClick(this.field);
        this.executeScript("document.body.click()", new Object[0]);
        this.assertInvalid();
    }

    @Test
    public void invalidateWhenNotEmptyAndThenBlur() {
        this.setValue("not-empty");
        this.scrollIntoViewAndClick(this.invalidate);
        this.scrollIntoViewAndClick(this.field);
        this.executeScript("document.body.click()", new Object[0]);
        this.assertInvalid();
    }

    private void assertInvalid() {
        String invalid = this.field.getAttribute("invalid");
        Assert.assertTrue((String)"The element should be in invalid state", (boolean)Boolean.parseBoolean(invalid));
        String errorMessage = this.field.getAttribute("errorMessage");
        Assert.assertEquals((Object)"Invalidated from server", (Object)errorMessage);
    }

    private void assertValid() {
        String invalid = this.field.getAttribute("invalid");
        Assert.assertFalse((String)"The element should be in valid state", (boolean)Boolean.parseBoolean(invalid));
        String errorMessage = this.field.getAttribute("errorMessage");
        Assert.assertEquals((Object)"", (Object)errorMessage);
    }

    private void setValue(String value) {
        this.executeScript("arguments[0].value = arguments[1];", this.field, value);
    }
}

