/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.testutil;

import com.vaadin.flow.testutil.AbstractBrowserConsoleTest;
import com.vaadin.flow.testutil.net.SimpleProxy;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;

public abstract class ChromeBrowserTestWithProxy
extends AbstractBrowserConsoleTest {
    private static AtomicInteger availablePort = new AtomicInteger(2000);
    private SimpleProxy proxySession;
    private Integer proxyPort = null;
    private String rootUrl;

    @Override
    public void setup() throws Exception {
        super.setup();
        this.connectProxy();
    }

    @After
    public void teardownProxy() {
        this.disconnectProxy();
    }

    @Override
    public void checkIfServerAvailable() {
        this.rootUrl = super.getRootURL();
        try {
            super.checkIfServerAvailable();
        }
        finally {
            this.rootUrl = null;
        }
    }

    protected Integer getProxyPort() {
        if (this.proxyPort == null) {
            this.proxyPort = availablePort.addAndGet(1);
            if (this.proxyPort == 2049) {
                this.proxyPort = availablePort.addAndGet(1);
            }
        }
        return this.proxyPort;
    }

    protected void disconnectProxy() {
        if (this.proxySession == null) {
            return;
        }
        this.proxySession.disconnect();
        this.proxySession = null;
    }

    protected void connectProxy() throws IOException {
        if (this.proxySession != null) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            try {
                this.createProxy(this.getProxyPort());
                break;
            }
            catch (IOException e) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException exception) {
                    new RuntimeException(exception);
                }
                if (i != 9) continue;
                throw new RuntimeException("All 10 attempts to connect a proxy failed", e);
            }
        }
    }

    private void createProxy(int proxyPort) throws IOException {
        this.proxySession = new SimpleProxy(proxyPort, this.getDeploymentHostname(), this.getDeploymentPort());
        this.proxySession.start();
    }

    @Override
    protected String getRootURL() {
        if (this.rootUrl != null) {
            return this.rootUrl;
        }
        return "http://" + this.getDeploymentHostname() + ":" + this.getProxyPort();
    }
}

