/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.testutil;

import java.io.File;
import java.nio.file.Files;
import org.junit.Assert;

public class FileTestUtil {
    public static void waitForFile(File file) {
        long start = System.currentTimeMillis();
        long timeout = 300L;
        while (System.currentTimeMillis() - start < timeout * 1000L) {
            if (file.exists()) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException("File " + file.getAbsolutePath() + " does not exist");
    }

    public static void assertDirectory(File file, String errorMessage) {
        Assert.assertTrue((String)errorMessage, (boolean)file.isDirectory());
        Assert.assertFalse((String)errorMessage, (boolean)Files.isSymbolicLink(file.toPath()));
    }

    public static void assertSymlink(File file, String errorMessage) {
        Assert.assertTrue((String)errorMessage, (boolean)Files.isSymbolicLink(file.toPath()));
    }
}

