/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.testutil;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;

public final class TestUtils {
    private TestUtils() {
    }

    public static File getTestJar() {
        return TestUtils.getTestJar("paper-button-2.0.0.jar");
    }

    public static File getTestJar(String jarName) {
        return new File(TestUtils.getTestResource(jarName).getFile());
    }

    public static File getTestFolder(String name) {
        File folder = new File(TestUtils.getTestResource(name).getFile());
        assert (folder.isDirectory());
        return folder;
    }

    public static URL getTestResource(String resourceName) {
        URL resourceUrl = TestUtils.class.getClassLoader().getResource(resourceName);
        Assert.assertNotNull((String)String.format("Expect the test resource to be present in test resource folder with name = '%s'", resourceName), (Object)resourceUrl);
        return resourceUrl;
    }

    public static List<String> listFilesRecursively(File directory) {
        assert (directory != null && directory.isDirectory()) : "This method expects valid directory as input, but got: " + directory;
        try {
            return Files.walk(directory.toPath(), new FileVisitOption[0]).filter(file -> Files.isRegularFile(file, new LinkOption[0])).map(Path::toString).map(path -> path.replace(directory.getAbsolutePath(), "")).map(path -> path.startsWith(File.separator) ? path.substring(1) : path).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new AssertionError(String.format("Unexpected: could not list files in directory '%s'", directory), e);
        }
    }
}

