/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.testutil;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClassFinder {
    private final Logger logger = LoggerFactory.getLogger(ClassFinder.class);

    protected boolean isTestClassPath(String classPath) {
        File file = new File(classPath);
        return "test-classes".equals(file.getName());
    }

    protected static boolean isFunctionalType(Type type) {
        return type.getTypeName().contains("java.util.function");
    }

    protected static List<String> getRawClasspathEntries() {
        String pathSep = System.getProperty("path.separator");
        String classpath = System.getProperty("java.class.path");
        if (classpath.startsWith("\"")) {
            classpath = classpath.substring(1);
        }
        if (classpath.endsWith("\"")) {
            classpath = classpath.substring(0, classpath.length() - 1);
        }
        String[] split = classpath.split(pathSep);
        return Arrays.asList(split);
    }

    private static Collection<String> findClassesInDirectory(String parentPackage, File parent) {
        if (parent.isHidden() || parent.getPath().contains(File.separator + ".")) {
            return Collections.emptyList();
        }
        parentPackage = parentPackage == null ? "" : parentPackage + ".";
        ArrayList<String> classNames = new ArrayList<String>();
        File[] files = parent.listFiles();
        Assert.assertNotNull((Object)files);
        for (File child : files) {
            if (child.isDirectory()) {
                classNames.addAll(ClassFinder.findClassesInDirectory(parentPackage + child.getName(), child));
                continue;
            }
            if (!child.getName().endsWith(".class")) continue;
            classNames.add(parentPackage.replace(File.separatorChar, '.') + child.getName().replaceAll("\\.class", ""));
        }
        return classNames;
    }

    protected Pattern getJarPattern() {
        return Pattern.compile("(.*vaadin.*)|(.*flow.*)\\.jar");
    }

    protected Stream<String> getBasePackages() {
        return Stream.of("com.vaadin");
    }

    protected boolean isTestClass(Class<?> cls) {
        if (cls.getEnclosingClass() != null && this.isTestClass(cls.getEnclosingClass())) {
            return true;
        }
        for (Method method : cls.getMethods()) {
            if (!method.isAnnotationPresent(Test.class)) continue;
            return true;
        }
        return false;
    }

    protected List<String> findServerClasses(String classpathEntry, Collection<Pattern> excludes) throws IOException {
        Collection<String> classes;
        File file = new File(classpathEntry);
        if (file.isDirectory()) {
            classes = ClassFinder.findClassesInDirectory(null, file);
        } else if (this.getJarPattern().matcher(file.getName()).matches()) {
            classes = this.findClassesInJar(file);
        } else {
            this.logger.debug("Ignoring " + classpathEntry);
            return Collections.emptyList();
        }
        return classes.stream().filter(className -> this.getBasePackages().anyMatch(basePackage -> className.startsWith(basePackage + "."))).filter(className -> excludes.stream().noneMatch(p -> p.matcher((CharSequence)className).matches())).collect(Collectors.toList());
    }

    private Collection<String> findClassesInJar(File file) throws IOException {
        ArrayList<String> classes = new ArrayList<String>();
        try (JarFile jar = new JarFile(file);){
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                String nameWithoutExtension = entry.getName().replaceAll("\\.class", "");
                String className = nameWithoutExtension.replace('/', '.');
                classes.add(className);
            }
        }
        return classes;
    }
}

