/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.internal.UrlUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class PathUtil
implements Serializable {
    public static List<String> getSegmentsList(String path) {
        String[] segments = (path = path == null ? "" : PathUtil.trimSegmentsString(path)).split("/");
        if (segments.length == 1 && segments[0].isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(segments));
    }

    public static List<String> getSegmentsListWithDecoding(String path) {
        String[] segments = (path = path == null ? "" : PathUtil.trimSegmentsString(path)).split("/");
        if (segments.length == 1 && segments[0].isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.stream(segments).map(UrlUtil::decodeURIComponent).collect(Collectors.toUnmodifiableList());
    }

    public static String getPath(List<String> segments) {
        return PathUtil.trimSegmentsString(segments == null ? "" : String.join((CharSequence)"/", segments));
    }

    public static String getPath(String basePath, List<String> segments) {
        basePath = PathUtil.trimPath(basePath);
        return PathUtil.trimPath(basePath + (String)(segments == null || segments.isEmpty() ? "" : "/" + String.join((CharSequence)"/", segments)));
    }

    public static String trimPath(String path) {
        if (path == null) {
            return "";
        }
        if ((path = path.trim()).startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String trimSegmentsString(String path) {
        Objects.requireNonNull(path);
        path = path.trim();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }
}

