/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.LocationChangeEvent;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.ParameterDeserializer;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.AbstractNavigationStateRenderer;
import com.vaadin.flow.router.internal.NavigationRouteTarget;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class NavigationStateRenderer
extends AbstractNavigationStateRenderer {
    private LocationChangeEvent ongoingLocationChangeEvent;

    public NavigationStateRenderer(NavigationState navigationState) {
        super(navigationState);
    }

    void setOngoingLocationChangeEvent(LocationChangeEvent ongoingLocationChangeEvent) {
        this.ongoingLocationChangeEvent = ongoingLocationChangeEvent;
    }

    @Override
    protected List<Class<? extends RouterLayout>> getRouterLayoutTypes(Class<? extends Component> targetType, Router router) {
        NavigationState navigationState = this.getNavigationState();
        assert (targetType == navigationState.getNavigationTarget()) : "Trying to get layouts for wrong route target";
        NavigationRouteTarget target = router.getRegistry().getNavigationRouteTarget(navigationState.getResolvedPath());
        if (target.hasTarget()) {
            return this.getTargetParentLayouts(target.getRouteTarget(), router.getRegistry(), target.getPath());
        }
        return Collections.emptyList();
    }

    @Override
    protected void notifyNavigationTarget(Component componentInstance, NavigationEvent navigationEvent, BeforeEnterEvent beforeEnterEvent, LocationChangeEvent locationChangeEvent) {
        if (!(componentInstance instanceof HasUrlParameter)) {
            return;
        }
        NavigationState navigationState = this.getNavigationState();
        Class<? extends Component> routeTargetType = navigationState.getNavigationTarget();
        List parameters = navigationState.getUrlParameters().orElse(null);
        Object deserializedParameter = null;
        try {
            deserializedParameter = ParameterDeserializer.deserializeRouteParameters(routeTargetType, parameters);
        }
        catch (Exception e) {
            beforeEnterEvent.rerouteToError(NotFoundException.class, String.format("Failed to parse url parameter, exception: %s", e));
            return;
        }
        HasUrlParameter hasUrlParameter = (HasUrlParameter)((Object)componentInstance);
        hasUrlParameter.setParameter(beforeEnterEvent, deserializedParameter);
    }

    @Override
    protected Optional<HasElement> findActiveRouteTarget(NavigationEvent event, Predicate<HasElement> isRouteTargetType) {
        Optional<Object> currentInstance = event.isForwardTo() && this.ongoingLocationChangeEvent != null ? this.ongoingLocationChangeEvent.getRouteTargetChain().stream().filter(isRouteTargetType).findAny() : Optional.empty();
        return currentInstance.or(() -> super.findActiveRouteTarget(event, isRouteTargetType));
    }
}

