/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.page.ClipboardFile;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class ClipboardEvent
implements Serializable {
    private final String type;
    private final String text;
    private final String html;
    private final List<ClipboardFile> files;

    ClipboardEvent(String type, String text, String html, List<ClipboardFile> files) {
        this.type = type;
        this.text = text;
        this.html = html;
        this.files = files != null ? Collections.unmodifiableList(files) : Collections.emptyList();
    }

    public String getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public String getHtml() {
        return this.html;
    }

    public boolean hasText() {
        return this.text != null && !this.text.isEmpty();
    }

    public boolean hasHtml() {
        return this.html != null && !this.html.isEmpty();
    }

    public boolean hasFiles() {
        return !this.files.isEmpty();
    }

    public List<ClipboardFile> getFiles() {
        return this.files;
    }
}

