/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.signals.local.ValueSignal;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import tools.jackson.databind.node.ObjectNode;

public class ComponentSizeObserver
implements Serializable {
    private static final String EVENT_NAME = "vaadin-component-resize";
    private final Element uiElement;
    private final Map<Integer, ValueSignal<Component.Size>> idToSignal = new HashMap<Integer, ValueSignal<Component.Size>>();
    private final Map<ValueSignal<Component.Size>, Integer> signalToId = new HashMap<ValueSignal<Component.Size>, Integer>();
    private int nextId = 0;

    public static ComponentSizeObserver get(UI ui) {
        ComponentSizeObserver observer = ComponentUtil.getData((Component)ui, ComponentSizeObserver.class);
        if (observer == null) {
            observer = new ComponentSizeObserver(ui);
            ComponentUtil.setData((Component)ui, ComponentSizeObserver.class, observer);
        }
        return observer;
    }

    private ComponentSizeObserver(UI ui) {
        this.uiElement = ui.getElement();
        this.uiElement.executeJs("window.Vaadin.Flow.componentSizeObserver.init(this)", new Object[0]);
        this.uiElement.addEventListener(EVENT_NAME, event -> {
            ObjectNode sizes = (ObjectNode)event.getEventData().get("event.sizes");
            for (String idStr : sizes.propertyNames()) {
                int id = Integer.parseInt(idStr);
                ValueSignal<Component.Size> signal = this.idToSignal.get(id);
                if (signal == null) continue;
                ObjectNode size = (ObjectNode)sizes.get(idStr);
                int w = size.get("w").intValue();
                int h = size.get("h").intValue();
                signal.set(new Component.Size(w, h));
            }
        }).addEventData("event.sizes").debounce(100).allowInert();
    }

    public void observe(Element element, ValueSignal<Component.Size> signal) {
        int id = this.nextId++;
        this.idToSignal.put(id, signal);
        this.signalToId.put(signal, id);
        this.uiElement.executeJs("window.Vaadin.Flow.componentSizeObserver.observe(this, $0, $1)", element, id);
    }

    public void unobserve(ValueSignal<Component.Size> signal) {
        Integer id = this.signalToId.remove(signal);
        if (id != null) {
            this.idToSignal.remove(id);
        }
    }
}

