/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared;

import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.TestUtil;
import com.vaadin.flow.signals.shared.AbstractSignal;
import com.vaadin.flow.signals.shared.SignalUtils;
import com.vaadin.flow.signals.shared.impl.SignalTree;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SignalUtilsTest {
    @Test
    void treeOf_returnsSignalsUnderlyingTree() {
        SignalTree tree = (SignalTree)Mockito.mock(SignalTree.class);
        AbstractSignal signal = (AbstractSignal)Mockito.mock(AbstractSignal.class);
        Mockito.when((Object)signal.tree()).thenReturn((Object)tree);
        Assertions.assertSame((Object)tree, (Object)SignalUtils.treeOf((AbstractSignal)signal));
        ((AbstractSignal)Mockito.verify((Object)signal, (VerificationMode)Mockito.times((int)1))).tree();
    }

    @Test
    void isValid_callsSignalsIsValid() {
        AbstractSignal signal = (AbstractSignal)Mockito.mock(AbstractSignal.class);
        SignalCommand command = TestUtil.writeRootValueCommand();
        Mockito.when((Object)signal.isValid((SignalCommand)ArgumentMatchers.any())).thenReturn((Object)true);
        Assertions.assertTrue((boolean)SignalUtils.isValid((AbstractSignal)signal, (SignalCommand)command));
        ((AbstractSignal)Mockito.verify((Object)signal, (VerificationMode)Mockito.times((int)1))).isValid(command);
    }
}

