/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.local;

import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.signals.SignalTestBase;
import com.vaadin.flow.signals.local.ValueSignal;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ValueSignalHelperTest
extends SignalTestBase {
    @Test
    void updater_nullUpdater_throwsNullPointerException() {
        ValueSignal signal = new ValueSignal((Object)new ImmutablePerson("Alice", 30));
        Assertions.assertThrows(NullPointerException.class, () -> signal.updater(null));
    }

    @Test
    void updater_returnsCallback() {
        ValueSignal signal = new ValueSignal((Object)new ImmutablePerson("Alice", 30));
        SerializableConsumer callback = signal.updater(ImmutablePerson::withName);
        Assertions.assertNotNull((Object)callback);
    }

    @Test
    void updater_callbackUpdatesSignal() {
        ValueSignal signal = new ValueSignal((Object)new ImmutablePerson("Alice", 30));
        SerializableConsumer callback = signal.updater(ImmutablePerson::withName);
        callback.accept((Object)"Bob");
        Assertions.assertEquals((Object)"Bob", (Object)((ImmutablePerson)signal.get()).name());
        Assertions.assertEquals((int)30, (int)((ImmutablePerson)signal.get()).age());
    }

    @Test
    void updater_multipleCallbackInvocations_updatesSignalEachTime() {
        ValueSignal signal = new ValueSignal((Object)new ImmutablePerson("Alice", 30));
        SerializableConsumer callback = signal.updater(ImmutablePerson::withName);
        callback.accept((Object)"Bob");
        Assertions.assertEquals((Object)"Bob", (Object)((ImmutablePerson)signal.get()).name());
        callback.accept((Object)"Charlie");
        Assertions.assertEquals((Object)"Charlie", (Object)((ImmutablePerson)signal.get()).name());
        callback.accept((Object)"Diana");
        Assertions.assertEquals((Object)"Diana", (Object)((ImmutablePerson)signal.get()).name());
    }

    @Test
    void updater_preservesOtherFields() {
        ValueSignal signal = new ValueSignal((Object)new ImmutablePerson("Alice", 30));
        SerializableConsumer nameCallback = signal.updater(ImmutablePerson::withName);
        nameCallback.accept((Object)"Bob");
        Assertions.assertEquals((Object)"Bob", (Object)((ImmutablePerson)signal.get()).name());
        Assertions.assertEquals((int)30, (int)((ImmutablePerson)signal.get()).age());
    }

    @Test
    void updater_withNullValue_works() {
        ValueSignal signal = new ValueSignal((Object)new ImmutablePerson("Alice", 30));
        SerializableConsumer callback = signal.updater(ImmutablePerson::withName);
        callback.accept(null);
        Assertions.assertNull((Object)((ImmutablePerson)signal.get()).name());
        Assertions.assertEquals((int)30, (int)((ImmutablePerson)signal.get()).age());
    }

    @Test
    void modifier_nullModifier_throwsNullPointerException() {
        ValueSignal signal = new ValueSignal((Object)new MutablePerson("Alice", 30));
        Assertions.assertThrows(NullPointerException.class, () -> signal.modifier(null));
    }

    @Test
    void modifier_returnsCallback() {
        ValueSignal signal = new ValueSignal((Object)new MutablePerson("Alice", 30));
        SerializableConsumer callback = signal.modifier(MutablePerson::setName);
        Assertions.assertNotNull((Object)callback);
    }

    @Test
    void modifier_callbackModifiesSignalInPlace() throws Exception {
        MutablePerson person = new MutablePerson("Alice", 30);
        ValueSignal signal = new ValueSignal((Object)person);
        SerializableConsumer callback = signal.modifier(MutablePerson::setName);
        new MockVaadinSession().runWithLock(() -> {
            callback.accept((Object)"Bob");
            Assertions.assertEquals((Object)"Bob", (Object)((MutablePerson)signal.get()).getName());
            Assertions.assertEquals((int)30, (int)((MutablePerson)signal.get()).getAge());
            Assertions.assertEquals((Object)person, (Object)signal.get());
            return null;
        });
    }

    @Test
    void modifier_multipleCallbackInvocations_modifiesSignalEachTime() throws Exception {
        MutablePerson person = new MutablePerson("Alice", 30);
        ValueSignal signal = new ValueSignal((Object)person);
        SerializableConsumer callback = signal.modifier(MutablePerson::setName);
        new MockVaadinSession().runWithLock(() -> {
            callback.accept((Object)"Bob");
            Assertions.assertEquals((Object)"Bob", (Object)((MutablePerson)signal.get()).getName());
            callback.accept((Object)"Charlie");
            Assertions.assertEquals((Object)"Charlie", (Object)((MutablePerson)signal.get()).getName());
            callback.accept((Object)"Diana");
            Assertions.assertEquals((Object)"Diana", (Object)((MutablePerson)signal.get()).getName());
            return null;
        });
    }

    @Test
    void modifier_preservesOtherFields() throws Exception {
        MutablePerson person = new MutablePerson("Alice", 30);
        ValueSignal signal = new ValueSignal((Object)person);
        SerializableConsumer nameCallback = signal.modifier(MutablePerson::setName);
        new MockVaadinSession().runWithLock(() -> {
            nameCallback.accept((Object)"Bob");
            Assertions.assertEquals((Object)"Bob", (Object)((MutablePerson)signal.get()).getName());
            Assertions.assertEquals((int)30, (int)((MutablePerson)signal.get()).getAge());
            return null;
        });
    }

    @Test
    void modifier_withNullValue_works() throws Exception {
        MutablePerson person = new MutablePerson("Alice", 30);
        ValueSignal signal = new ValueSignal((Object)person);
        SerializableConsumer callback = signal.modifier(MutablePerson::setName);
        new MockVaadinSession().runWithLock(() -> {
            callback.accept(null);
            Assertions.assertNull((Object)((MutablePerson)signal.get()).getName());
            Assertions.assertEquals((int)30, (int)((MutablePerson)signal.get()).getAge());
            return null;
        });
    }

    record ImmutablePerson(String name, int age) {
        ImmutablePerson withName(String name) {
            return new ImmutablePerson(name, this.age);
        }

        ImmutablePerson withAge(int age) {
            return new ImmutablePerson(this.name, age);
        }
    }

    static class MutablePerson {
        private String name;
        private int age;

        MutablePerson(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }
    }
}

