/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.local;

import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.signals.SignalTestBase;
import com.vaadin.flow.signals.function.SignalUpdater;
import com.vaadin.flow.signals.function.ValueModifier;
import com.vaadin.flow.signals.local.ListSignal;
import com.vaadin.flow.signals.local.ValueSignal;
import java.io.Serializable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class LocalSignalSessionCheckTest
extends SignalTestBase {
    @AfterEach
    void clearSession() {
        VaadinSession.setCurrent(null);
    }

    @Test
    void valueSignal_sameSession_get() {
        VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        VaadinSession.setCurrent((VaadinSession)session);
        ValueSignal signal = new ValueSignal((Object)"hello");
        signal.get();
        Assertions.assertDoesNotThrow(() -> (String)signal.get());
    }

    @Test
    void valueSignal_sameSession_allOperations() {
        VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        VaadinSession.setCurrent((VaadinSession)session);
        ValueSignal signal = new ValueSignal((Object)"hello");
        Assertions.assertDoesNotThrow(() -> (String)signal.get());
        Assertions.assertDoesNotThrow(() -> (String)signal.peek());
        Assertions.assertDoesNotThrow(() -> signal.set((Object)"world"));
        Assertions.assertDoesNotThrow(() -> signal.replace((Object)"world", (Object)"foo"));
        Assertions.assertDoesNotThrow(() -> (String)signal.update((SignalUpdater & Serializable)v -> v));
        Assertions.assertDoesNotThrow(() -> signal.modify((ValueModifier & Serializable)v -> {}));
    }

    @Test
    void valueSignal_differentSession_throws() {
        VaadinSession session1 = (VaadinSession)Mockito.mock(VaadinSession.class);
        VaadinSession session2 = (VaadinSession)Mockito.mock(VaadinSession.class);
        VaadinSession.setCurrent((VaadinSession)session1);
        ValueSignal signal = new ValueSignal((Object)"hello");
        signal.get();
        VaadinSession.setCurrent((VaadinSession)session2);
        Assertions.assertThrows(IllegalStateException.class, () -> signal.get());
        Assertions.assertThrows(IllegalStateException.class, () -> signal.peek());
        Assertions.assertThrows(IllegalStateException.class, () -> signal.set((Object)"world"));
        Assertions.assertThrows(IllegalStateException.class, () -> signal.replace((Object)"hello", (Object)"world"));
        Assertions.assertThrows(IllegalStateException.class, () -> signal.update((SignalUpdater & Serializable)v -> v));
        Assertions.assertThrows(IllegalStateException.class, () -> signal.modify((ValueModifier & Serializable)v -> {}));
    }

    @Test
    void valueSignal_noSession_works() {
        ValueSignal signal = new ValueSignal((Object)"hello");
        Assertions.assertDoesNotThrow(() -> (String)signal.get());
        Assertions.assertDoesNotThrow(() -> (String)signal.peek());
        Assertions.assertDoesNotThrow(() -> signal.set((Object)"world"));
        Assertions.assertDoesNotThrow(() -> signal.replace((Object)"world", (Object)"foo"));
        Assertions.assertDoesNotThrow(() -> (String)signal.update((SignalUpdater & Serializable)v -> v));
        Assertions.assertDoesNotThrow(() -> signal.modify((ValueModifier & Serializable)v -> {}));
    }

    @Test
    void valueSignal_differentSession_errorMessageContainsGuidance() {
        VaadinSession session1 = (VaadinSession)Mockito.mock(VaadinSession.class);
        VaadinSession session2 = (VaadinSession)Mockito.mock(VaadinSession.class);
        VaadinSession.setCurrent((VaadinSession)session1);
        ValueSignal signal = new ValueSignal((Object)"hello");
        signal.get();
        VaadinSession.setCurrent((VaadinSession)session2);
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> signal.get());
        String message = exception.getMessage();
        Assertions.assertTrue((boolean)message.contains("ValueSignal"));
        Assertions.assertTrue((boolean)message.contains("SharedValueSignal"));
        Assertions.assertTrue((boolean)message.contains("static field"));
    }

    @Test
    void listSignal_sameSession_allOperations() {
        VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        VaadinSession.setCurrent((VaadinSession)session);
        ListSignal signal = new ListSignal();
        Assertions.assertDoesNotThrow(() -> signal.get());
        Assertions.assertDoesNotThrow(() -> signal.peek());
        ValueSignal entry = signal.insertFirst((Object)"first");
        Assertions.assertDoesNotThrow(() -> signal.insertLast((Object)"last"));
        Assertions.assertDoesNotThrow(() -> signal.insertAt(0, (Object)"at"));
        Assertions.assertDoesNotThrow(() -> signal.remove(entry));
        Assertions.assertDoesNotThrow(() -> signal.clear());
    }

    @Test
    void listSignal_differentSession_throws() {
        VaadinSession session1 = (VaadinSession)Mockito.mock(VaadinSession.class);
        VaadinSession session2 = (VaadinSession)Mockito.mock(VaadinSession.class);
        VaadinSession.setCurrent((VaadinSession)session1);
        ListSignal signal = new ListSignal();
        ValueSignal entry = signal.insertFirst((Object)"value");
        VaadinSession.setCurrent((VaadinSession)session2);
        Assertions.assertThrows(IllegalStateException.class, () -> signal.get());
        Assertions.assertThrows(IllegalStateException.class, () -> signal.insertFirst((Object)"value"));
        Assertions.assertThrows(IllegalStateException.class, () -> signal.insertLast((Object)"value"));
        Assertions.assertThrows(IllegalStateException.class, () -> signal.insertAt(0, (Object)"value"));
        Assertions.assertThrows(IllegalStateException.class, () -> signal.remove(entry));
        Assertions.assertThrows(IllegalStateException.class, () -> signal.clear());
    }

    @Test
    void listSignal_differentSession_errorMessageContainsGuidance() {
        VaadinSession session1 = (VaadinSession)Mockito.mock(VaadinSession.class);
        VaadinSession session2 = (VaadinSession)Mockito.mock(VaadinSession.class);
        VaadinSession.setCurrent((VaadinSession)session1);
        ListSignal signal = new ListSignal();
        signal.get();
        VaadinSession.setCurrent((VaadinSession)session2);
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> signal.get());
        String message = exception.getMessage();
        Assertions.assertTrue((boolean)message.contains("ListSignal"));
        Assertions.assertTrue((boolean)message.contains("static field"));
    }

    @Test
    void listSignal_noSession_works() {
        ListSignal signal = new ListSignal();
        Assertions.assertDoesNotThrow(() -> signal.get());
        Assertions.assertDoesNotThrow(() -> signal.peek());
        ValueSignal entry = signal.insertFirst((Object)"first");
        Assertions.assertDoesNotThrow(() -> signal.insertLast((Object)"last"));
        Assertions.assertDoesNotThrow(() -> signal.insertAt(0, (Object)"at"));
        Assertions.assertDoesNotThrow(() -> signal.remove(entry));
        Assertions.assertDoesNotThrow(() -> signal.clear());
    }
}

