/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.webcomponent;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.component.webcomponent.WebComponent;
import com.vaadin.flow.server.webcomponent.WebComponentModulesWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class WebComponentModulesWriterTest {
    @TempDir
    Path tempDir;
    private File outputDirectory;

    WebComponentModulesWriterTest() {
    }

    @BeforeEach
    void init() throws IOException {
        this.outputDirectory = Files.createTempDirectory(this.tempDir, "output", new FileAttribute[0]).toFile();
    }

    @Test
    public void directoryWriter_generateWebComponentsToDirectory_canCallMethodReflectively_js() {
        Set files = WebComponentModulesWriter.DirectoryWriter.generateWebComponentsToDirectory(WebComponentModulesWriter.class, Collections.singleton(MyExporter.class), (File)this.outputDirectory, null);
        Assertions.assertEquals((int)1, (int)files.size(), (String)"One file was created");
        Assertions.assertEquals((Object)"real-tag.js", (Object)((File)files.stream().findFirst().get()).getName(), (String)"File is js module with correct name");
    }

    @Test
    public void directoryWriter_generateWebComponentsToDirectoryUsingFactory_canCallMethodReflectively_js() {
        Set files = WebComponentModulesWriter.DirectoryWriter.generateWebComponentsToDirectory(WebComponentModulesWriter.class, Collections.singleton(ExporterFactory.class), (File)this.outputDirectory, null);
        Assertions.assertEquals((int)1, (int)files.size(), (String)"One file was created");
        Assertions.assertEquals((Object)"foo-bar.js", (Object)((File)files.stream().findFirst().get()).getName(), (String)"File is js module with correct name");
    }

    @Test
    public void directoryWriter_generateWebComponentsToDirectory_zeroExportersCreatesZeroFiles() {
        Set files = WebComponentModulesWriter.DirectoryWriter.generateWebComponentsToDirectory(WebComponentModulesWriter.class, new HashSet(), (File)this.outputDirectory, null);
        Assertions.assertEquals((int)0, (int)files.size(), (String)"No files were created");
    }

    @Test
    public void directoryWriter_generateWebComponentsToDirectory_nonWriterClassThrows() {
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> WebComponentModulesWriter.DirectoryWriter.generateWebComponentsToDirectory(MyComponent.class, new HashSet(), (File)this.outputDirectory, null));
        Assertions.assertTrue((boolean)ex.getMessage().contains("but it is '" + MyComponent.class.getName() + "'"));
    }

    @Test
    public void directoryWriter_generateWebComponentsToDirectory_nullWriterThrows() {
        Assertions.assertThrows(NullPointerException.class, () -> WebComponentModulesWriter.DirectoryWriter.generateWebComponentsToDirectory(null, new HashSet(), (File)this.outputDirectory, null));
    }

    @Test
    public void directoryWriter_generateWebComponentsToDirectory_nullExporterSetThrows() {
        Assertions.assertThrows(NullPointerException.class, () -> WebComponentModulesWriter.DirectoryWriter.generateWebComponentsToDirectory(WebComponentModulesWriter.class, null, (File)this.outputDirectory, null));
    }

    @Test
    public void directoryWriter_generateWebComponentsToDirectory_nullOutputDirectoryThrows() {
        Assertions.assertThrows(NullPointerException.class, () -> WebComponentModulesWriter.DirectoryWriter.generateWebComponentsToDirectory(WebComponentModulesWriter.class, new HashSet(), null, null));
    }

    public static class MyExporter
    extends WebComponentExporter<MyComponent> {
        public MyExporter() {
            super("real-tag");
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }

    public static class ExporterFactory
    implements WebComponentExporterFactory<MyComponent> {
        public WebComponentExporter<MyComponent> create() {
            return new PrivateExporter();
        }
    }

    public static class MyComponent
    extends Component {
    }

    private static class PrivateExporter
    extends WebComponentExporter<MyComponent> {
        public PrivateExporter() {
            super("foo-bar");
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }
}

