/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.streams;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.streams.UploadEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class UploadEventTest {
    private VaadinRequest request;
    private VaadinResponse response;
    private VaadinSession session;
    private Element owner;

    UploadEventTest() {
    }

    @BeforeEach
    public void setUp() throws IOException {
        this.request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        this.response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        this.session = (VaadinSession)Mockito.mock(VaadinSession.class);
        this.owner = (Element)Mockito.mock(Element.class);
        Mockito.when((Object)this.request.getInputStream()).thenReturn((Object)new ByteArrayInputStream(new byte[0]));
    }

    @Test
    public void testInitialState_notRejected() {
        UploadEvent event = new UploadEvent(this.request, this.response, this.session, "test.txt", 100L, "text/plain", this.owner, null);
        Assertions.assertFalse((boolean)event.isRejected(), (String)"Event should not be rejected initially");
        Assertions.assertNull((Object)event.getRejectionMessage(), (String)"Rejection message should be null initially");
    }

    @Test
    public void testReject_withDefaultMessage() {
        UploadEvent event = new UploadEvent(this.request, this.response, this.session, "test.txt", 100L, "text/plain", this.owner, null);
        event.reject();
        Assertions.assertTrue((boolean)event.isRejected(), (String)"Event should be marked as rejected");
        Assertions.assertEquals((Object)"File rejected", (Object)event.getRejectionMessage(), (String)"Default rejection message should be set");
    }

    @Test
    public void testReject_withCustomMessage() {
        UploadEvent event = new UploadEvent(this.request, this.response, this.session, "test.zip", 100L, "application/zip", this.owner, null);
        String customMessage = "Only PNG files are accepted";
        event.reject(customMessage);
        Assertions.assertTrue((boolean)event.isRejected(), (String)"Event should be marked as rejected");
        Assertions.assertEquals((Object)customMessage, (Object)event.getRejectionMessage(), (String)"Custom rejection message should be set");
    }

    @Test
    public void testGetInputStream_rejectedUpload_throwsException() {
        UploadEvent event = new UploadEvent(this.request, this.response, this.session, "test.txt", 100L, "text/plain", this.owner, null);
        event.reject("Not allowed");
        try {
            event.getInputStream();
            Assertions.fail((String)"Expected IllegalStateException when accessing rejected upload stream");
        }
        catch (IllegalStateException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("rejected"), (String)"Exception should mention rejection");
            Assertions.assertTrue((boolean)e.getMessage().contains("Not allowed"), (String)"Exception should include rejection reason");
        }
    }

    @Test
    public void testGetInputStream_beforeRejection_works() {
        UploadEvent event = new UploadEvent(this.request, this.response, this.session, "test.txt", 100L, "text/plain", this.owner, null);
        Assertions.assertNotNull((Object)event.getInputStream(), (String)"Should be able to get input stream");
    }
}

