/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.menu;

import com.vaadin.flow.router.MenuData;
import com.vaadin.flow.server.menu.AvailableViewInfo;
import com.vaadin.flow.server.menu.RouteParamType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.ObjectMapper;

class AvailableViewInfoTest {
    ObjectMapper mapper;
    MenuData menuData;
    Badge badge;
    Detail detail;
    String detailAsString;

    AvailableViewInfoTest() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.mapper = new ObjectMapper();
        this.menuData = new MenuData("title", Double.valueOf(1.0), false, "icon", null);
        this.badge = new Badge("New!", "green");
        this.detail = new Detail("A nice page", 123, this.badge);
        this.detailAsString = this.mapper.writeValueAsString((Object)this.detail);
    }

    @Test
    public void testEquality() {
        Assertions.assertEquals((Object)this.createInfo(true, true), (Object)this.createInfo(true, true), (String)"Two instance created the same way are not equal");
    }

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        AvailableViewInfo info = this.createInfo(true, true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(info);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        AvailableViewInfo deserializedInfo = (AvailableViewInfo)ois.readObject();
        Assertions.assertEquals((Object)info, (Object)deserializedInfo, (String)"Serialized instance is not equal to origin");
    }

    @Test
    public void testJsonSerialization() throws JacksonException {
        AvailableViewInfo info = this.createInfo(true, true);
        String json = this.mapper.writeValueAsString((Object)info);
        Assertions.assertEquals((Object)info, (Object)this.mapper.readValue(json, AvailableViewInfo.class), (String)"JSON conversion doesn't give the same object");
    }

    @Test
    public void testJsonSerializationNull() throws JacksonException {
        AvailableViewInfo info = this.createInfo(true, false);
        String json = this.mapper.writeValueAsString((Object)info);
        Assertions.assertEquals((Object)info, (Object)this.mapper.readValue(json, AvailableViewInfo.class), (String)"JSON conversion doesn't give the same object");
    }

    private AvailableViewInfo createInfo(boolean withChild, boolean withDetail) {
        return new AvailableViewInfo("Title", new String[]{"role1"}, false, "route", false, true, this.menuData, withChild ? List.of(this.createInfo(false, withDetail)) : List.of(), Map.of("param", RouteParamType.REQUIRED), false, withDetail ? this.detailAsString : null);
    }

    private record Badge(String text, String color) {
    }

    private record Detail(String description, int importance, Badge badge) {
    }
}

