/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.DependencyList;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.MessageDigestUtil;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WrappedSession;
import com.vaadin.flow.server.communication.ServerRpcHandler;
import com.vaadin.flow.server.dau.DAUUtils;
import com.vaadin.flow.server.dau.DauEnforcementException;
import com.vaadin.pro.licensechecker.dau.EnforcementException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class ServerRpcHandlerTest {
    private VaadinRequest request;
    private VaadinService service;
    private VaadinSession session;
    private WrappedSession wrappedSession;
    private UI ui;
    private UIInternals uiInternals;
    private DependencyList dependencyList;
    private StateTree uiTree;
    private final String csrfToken = "";
    private ServerRpcHandler serverRpcHandler;
    private DeploymentConfiguration deploymentConfiguration;

    ServerRpcHandlerTest() {
    }

    @BeforeEach
    public void setup() {
        this.request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        this.service = (VaadinService)Mockito.mock(VaadinService.class);
        this.session = (VaadinSession)Mockito.mock(VaadinSession.class);
        this.wrappedSession = (WrappedSession)Mockito.mock(WrappedSession.class);
        this.ui = (UI)Mockito.mock(UI.class);
        this.uiInternals = (UIInternals)Mockito.mock(UIInternals.class);
        this.dependencyList = (DependencyList)Mockito.mock(DependencyList.class);
        Mockito.when((Object)this.request.getService()).thenReturn((Object)this.service);
        Mockito.when((Object)this.request.getWrappedSession()).thenReturn((Object)this.wrappedSession);
        Mockito.when((Object)this.session.getService()).thenReturn((Object)this.service);
        Mockito.when((Object)this.ui.getInternals()).thenReturn((Object)this.uiInternals);
        Mockito.when((Object)this.ui.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.ui.getCsrfToken()).thenReturn((Object)"");
        this.deploymentConfiguration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        Mockito.when((Object)this.service.getDeploymentConfiguration()).thenReturn((Object)this.deploymentConfiguration);
        this.uiTree = new StateTree(this.uiInternals, new Class[0]);
        Mockito.when((Object)this.uiInternals.getStateTree()).thenReturn((Object)this.uiTree);
        Mockito.when((Object)this.uiInternals.getDependencyList()).thenReturn((Object)this.dependencyList);
        this.serverRpcHandler = new ServerRpcHandler();
    }

    @Test
    public void handleRpc_resynchronize_throwsExceptionAndDirtiesTreeAndClearsDependenciesSent() throws IOException, ServerRpcHandler.InvalidUIDLSecurityKeyException, ServerRpcHandler.MessageIdSyncException {
        StringReader reader = new StringReader("{\"csrfToken\": \"\", \"rpc\":[], \"resynchronize\": true, \"clientId\":1}");
        this.uiTree.collectChanges(c -> {});
        Assertions.assertThrows(ServerRpcHandler.ResynchronizationRequiredException.class, () -> this.serverRpcHandler.handleRpc(this.ui, (Reader)reader, this.request));
        Assertions.assertTrue((boolean)this.uiTree.hasDirtyNodes());
        ((DependencyList)Mockito.verify((Object)this.dependencyList)).clearPendingSendToClient();
    }

    @Test
    public void handleRpc_duplicateMessage_throwsResendPayload() throws ServerRpcHandler.InvalidUIDLSecurityKeyException, ServerRpcHandler.MessageIdSyncException {
        String msg = "{\"clientId\":1}";
        ServerRpcHandler handler = new ServerRpcHandler();
        this.ui = new UI();
        this.ui.getInternals().setSession(this.session);
        this.ui.getInternals().setLastProcessedClientToServerId(1, MessageDigestUtil.sha256((String)msg));
        Assertions.assertThrows(ServerRpcHandler.ClientResentPayloadException.class, () -> handler.handleRpc(this.ui, msg, this.request));
    }

    @Test
    public void handleRpc_unexpectedMessage_throw() throws ServerRpcHandler.InvalidUIDLSecurityKeyException, IOException, ServerRpcHandler.MessageIdSyncException {
        String msg = "{\"clientId\":1}";
        ServerRpcHandler handler = new ServerRpcHandler();
        this.ui = new UI();
        this.ui.getInternals().setSession(this.session);
        Assertions.assertThrows(ServerRpcHandler.MessageIdSyncException.class, () -> handler.handleRpc(this.ui, msg, this.request));
    }

    @Test
    public void handleRpc_unexpectedMessage_exceptionContainsCorrectIds() throws ServerRpcHandler.InvalidUIDLSecurityKeyException, IOException {
        String msg = "{\"clientId\":5}";
        ServerRpcHandler handler = new ServerRpcHandler();
        this.ui = new UI();
        this.ui.getInternals().setSession(this.session);
        this.ui.getInternals().setLastProcessedClientToServerId(0, MessageDigestUtil.sha256((String)""));
        ServerRpcHandler.MessageIdSyncException e = (ServerRpcHandler.MessageIdSyncException)Assertions.assertThrows(ServerRpcHandler.MessageIdSyncException.class, () -> handler.handleRpc(this.ui, msg, this.request));
        Assertions.assertEquals((int)1, (int)e.getExpectedId());
        Assertions.assertEquals((int)5, (int)e.getReceivedId());
        Assertions.assertTrue((boolean)e.getMessage().contains("Expected: 1"));
        Assertions.assertTrue((boolean)e.getMessage().contains("got: 5"));
    }

    @Test
    public void handleRpc_dauEnforcement_throws() throws ServerRpcHandler.InvalidUIDLSecurityKeyException, IOException, ServerRpcHandler.MessageIdSyncException {
        this.enableDau();
        StringReader reader = new StringReader("{\"csrfToken\": \"\", \"rpc\":[{\"type\": \"event\", \"node\" : 1, \"event\": \"click\" }], \"syncId\": 0, \"clientId\":0}");
        ServerRpcHandler handler = new ServerRpcHandler();
        Mockito.when((Object)this.request.getAttribute(DAUUtils.ENFORCEMENT_EXCEPTION_KEY)).thenReturn((Object)new EnforcementException("Block"));
        this.ui = new UI();
        this.ui.getInternals().setSession(this.session);
        Assertions.assertThrows(DauEnforcementException.class, () -> handler.handleRpc(this.ui, (Reader)reader, this.request));
    }

    @Test
    public void handleRpc_dauEnforcement_pollEvent_doNoThrow() throws ServerRpcHandler.InvalidUIDLSecurityKeyException, IOException, ServerRpcHandler.MessageIdSyncException {
        this.enableDau();
        StringReader reader = new StringReader("{\"csrfToken\": \"\", \"rpc\":[{\"type\": \"event\", \"node\" : 1, \"event\": \"ui-poll\" }], \"syncId\": 0, \"clientId\":0}");
        ServerRpcHandler handler = new ServerRpcHandler();
        Mockito.when((Object)this.request.getAttribute(DAUUtils.ENFORCEMENT_EXCEPTION_KEY)).thenReturn((Object)new EnforcementException("Block"));
        this.ui = new UI();
        this.ui.getInternals().setSession(this.session);
        try {
            handler.handleRpc(this.ui, (Reader)reader, this.request);
        }
        catch (DauEnforcementException e) {
            Assertions.fail((String)"UI Poll request should not be blocked");
        }
    }

    @Test
    public void handleRpc_dauEnforcement_pollEventMixedWithOtherEvents_throw() throws ServerRpcHandler.InvalidUIDLSecurityKeyException, IOException, ServerRpcHandler.MessageIdSyncException {
        this.enableDau();
        StringReader reader = new StringReader("{\"csrfToken\": \"\", \"rpc\":[{\"type\": \"event\", \"node\" : 1, \"event\": \"ui-poll\" },{\"type\": \"event\", \"node\" : 1, \"event\": \"click\" }], \"syncId\": 0, \"clientId\":0}");
        ServerRpcHandler handler = new ServerRpcHandler();
        Mockito.when((Object)this.request.getAttribute(DAUUtils.ENFORCEMENT_EXCEPTION_KEY)).thenReturn((Object)new EnforcementException("Block"));
        this.ui = new UI();
        this.ui.getInternals().setSession(this.session);
        Assertions.assertThrows(DauEnforcementException.class, () -> handler.handleRpc(this.ui, (Reader)reader, this.request));
    }

    @Test
    public void handleRpc_dauEnforcement_resynchronization_doNoThrow() throws ServerRpcHandler.InvalidUIDLSecurityKeyException, IOException, ServerRpcHandler.MessageIdSyncException {
        this.enableDau();
        StringReader reader = new StringReader("{\"csrfToken\": \"\", \"rpc\":[{\"type\": \"event\", \"node\" : 1, \"event\": \"click\" }], \"resynchronize\": true, \"clientId\":0}");
        ServerRpcHandler handler = new ServerRpcHandler();
        Mockito.when((Object)this.request.getAttribute(DAUUtils.ENFORCEMENT_EXCEPTION_KEY)).thenReturn((Object)new EnforcementException("Block"));
        this.ui = new UI();
        this.ui.getInternals().setSession(this.session);
        Assertions.assertThrows(ServerRpcHandler.ResynchronizationRequiredException.class, () -> handler.handleRpc(this.ui, (Reader)reader, this.request));
    }

    @Test
    public void handleRpc_dauEnforcement_unloadBeacon_doNoThrow() throws ServerRpcHandler.InvalidUIDLSecurityKeyException, IOException, ServerRpcHandler.MessageIdSyncException {
        this.enableDau();
        StringReader reader = new StringReader("{\"csrfToken\": \"\", \"rpc\":[{\"type\": \"event\", \"node\" : 1, \"event\": \"click\" }], \"UNLOAD\": true, \"clientId\":0}");
        ServerRpcHandler handler = new ServerRpcHandler();
        Mockito.when((Object)this.request.getAttribute(DAUUtils.ENFORCEMENT_EXCEPTION_KEY)).thenReturn((Object)new EnforcementException("Block"));
        this.ui = new UI();
        this.ui.getInternals().setSession(this.session);
        try {
            handler.handleRpc(this.ui, (Reader)reader, this.request);
        }
        catch (EnforcementException e) {
            Assertions.fail((String)"Unload beacon request should not be blocked");
        }
    }

    @Test
    public void handleRpc_dauEnforcement_returnChannelMessage_doNoThrow() throws ServerRpcHandler.InvalidUIDLSecurityKeyException, IOException, ServerRpcHandler.MessageIdSyncException {
        this.enableDau();
        StringReader reader = new StringReader("{\"csrfToken\": \"\", \"rpc\":[{\"type\": \"channel\", \"node\" : 1, \"channel\": 0 }], \"syncId\": 0, \"clientId\":0}");
        ServerRpcHandler handler = new ServerRpcHandler();
        Mockito.when((Object)this.request.getAttribute(DAUUtils.ENFORCEMENT_EXCEPTION_KEY)).thenReturn((Object)new EnforcementException("Block"));
        this.ui = new UI();
        this.ui.getInternals().setSession(this.session);
        try {
            handler.handleRpc(this.ui, (Reader)reader, this.request);
        }
        catch (EnforcementException e) {
            Assertions.fail((String)"UI Poll request should not be blocked");
        }
    }

    @Test
    public void handleRpc_dauEnforcement_returnChannelMessageMixedWithOtherEvents_throw() throws ServerRpcHandler.InvalidUIDLSecurityKeyException, IOException, ServerRpcHandler.MessageIdSyncException {
        this.enableDau();
        StringReader reader = new StringReader("{\"csrfToken\": \"\", \"rpc\":[{\"type\": \"channel\", \"node\" : 1, \"channel\": 0 },{\"type\": \"event\", \"node\" : 1, \"event\": \"click\" }], \"syncId\": 0, \"clientId\":0}");
        ServerRpcHandler handler = new ServerRpcHandler();
        Mockito.when((Object)this.request.getAttribute(DAUUtils.ENFORCEMENT_EXCEPTION_KEY)).thenReturn((Object)new EnforcementException("Block"));
        this.ui = new UI();
        this.ui.getInternals().setSession(this.session);
        Assertions.assertThrows(DauEnforcementException.class, () -> handler.handleRpc(this.ui, (Reader)reader, this.request));
    }

    private void enableDau() {
        Mockito.when((Object)this.deploymentConfiguration.isProductionMode()).thenReturn((Object)true);
        Mockito.when((Object)this.deploymentConfiguration.getBooleanProperty((String)ArgumentMatchers.eq((Object)"dau.enable"), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
    }
}

