/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.auth;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.Pair;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.ErrorNavigationEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.RouteNotFoundError;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.MockVaadinContext;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.auth.AccessAnnotationCheckerTest;
import com.vaadin.flow.server.auth.AccessCheckDecision;
import com.vaadin.flow.server.auth.AccessCheckResult;
import com.vaadin.flow.server.auth.AccessControlTestClasses;
import com.vaadin.flow.server.auth.AccessPathChecker;
import com.vaadin.flow.server.auth.NavigationContext;
import com.vaadin.flow.server.auth.RoutePathAccessChecker;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class RoutePathAccessCheckerTest {
    private AccessPathChecker accessPathChecker;
    private RoutePathAccessChecker routePathAccessChecker;
    private Function<Class<?>, Pair<String, RouteParameters>> eventDataFactory = this::getRouteData;

    RoutePathAccessCheckerTest() {
    }

    @BeforeEach
    public void init() {
        this.accessPathChecker = (AccessPathChecker)Mockito.mock(AccessPathChecker.class);
        this.routePathAccessChecker = new RoutePathAccessChecker(this.accessPathChecker);
    }

    @Test
    public void permittedPath_anonymousAccessToAnonymousViewMainPath_accessAllowed() {
        Mockito.when((Object)this.accessPathChecker.hasAccess((String)ArgumentMatchers.eq((Object)"anon"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn((Object)true);
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.AnonymousAllowedView.class, null);
        Assertions.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker)).hasAccess((String)ArgumentMatchers.eq((Object)"anon"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
    }

    @Test
    public void permittedPath_loggedInNoRolesAccessToAnonymousViewMainPath_accessAllowed() {
        Mockito.when((Object)this.accessPathChecker.hasAccess((String)ArgumentMatchers.eq((Object)"anon"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn((Object)true);
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.AnonymousAllowedView.class, User.USER_NO_ROLES);
        Assertions.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker)).hasAccess((String)ArgumentMatchers.eq((Object)"anon"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
    }

    @Test
    public void permittedPath_loggedInNoRolesAccessToAnnotatedView_accessAllowed() {
        Mockito.when((Object)this.accessPathChecker.hasAccess((String)ArgumentMatchers.eq((Object)"permitall"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn((Object)true);
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.PermitAllView.class, User.USER_NO_ROLES);
        Assertions.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker)).hasAccess((String)ArgumentMatchers.eq((Object)"permitall"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
    }

    @Test
    public void permittedPath_accessToViewWithoutAliases_accessAllowed() {
        Mockito.when((Object)this.accessPathChecker.hasAccess((String)ArgumentMatchers.eq((Object)"noannotation"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn((Object)true);
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationView.class, null);
        Assertions.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker)).hasAccess((String)ArgumentMatchers.eq((Object)"noannotation"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.accessPathChecker});
    }

    @Test
    public void forbiddenPath_anonymousAccessToAnonymousViewMainPath_accessDenied() {
        Mockito.when((Object)this.accessPathChecker.hasAccess((String)ArgumentMatchers.any(), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn((Object)false);
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.AnonymousAllowedView.class, null);
        Assertions.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
        Assertions.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker)).hasAccess((String)ArgumentMatchers.eq((Object)"anon"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
    }

    @Test
    public void forbiddenPath_anonymousAccessAnnotatedView_accessDenied() {
        Mockito.when((Object)this.accessPathChecker.hasAccess((String)ArgumentMatchers.any(), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn((Object)false);
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.PermitAllView.class, null);
        Assertions.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker)).hasAccess((String)ArgumentMatchers.eq((Object)"permitall"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
    }

    @Test
    public void forbiddenPath_loggedInNoRolesAccessToAnonymousViewMainPath_accessDenied() {
        Mockito.when((Object)this.accessPathChecker.hasAccess((String)ArgumentMatchers.any(), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn((Object)false);
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.AnonymousAllowedView.class, User.USER_NO_ROLES);
        Assertions.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker)).hasAccess((String)ArgumentMatchers.eq((Object)"anon"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
    }

    @Test
    public void forbiddenPath_loggedInNoRolesAccessToAnnotatedView_accessDenied() {
        Mockito.when((Object)this.accessPathChecker.hasAccess((String)ArgumentMatchers.any(), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn((Object)false);
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.PermitAllView.class, User.USER_NO_ROLES);
        Assertions.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker)).hasAccess((String)ArgumentMatchers.eq((Object)"permitall"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
    }

    @Test
    public void forbiddenPath_accessToViewWithoutAliases_accessDenied() {
        Mockito.when((Object)this.accessPathChecker.hasAccess((String)ArgumentMatchers.eq((Object)"noannotation"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn((Object)false);
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.NoAnnotationView.class, null);
        Assertions.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision());
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker)).hasAccess((String)ArgumentMatchers.eq((Object)"noannotation"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.accessPathChecker});
    }

    @Test
    public void openingForbiddenPath_showsReasonAndHintInDevelopmentMode() {
        Mockito.when((Object)this.accessPathChecker.hasAccess((String)ArgumentMatchers.any(), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn((Object)false);
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.AnonymousAllowedView.class, User.NORMAL_USER);
        Assertions.assertEquals((Object)AccessCheckResult.deny((String)"Access to 'anon' is denied by security rules."), (Object)result);
    }

    @Test
    public void pathAlias_aliasPathAllowed_accessGranted() {
        this.eventDataFactory = target -> new Pair((Serializable)((Object)"anon-alias"), (Serializable)RouteParameters.empty());
        Mockito.when((Object)this.accessPathChecker.hasAccess(ArgumentMatchers.anyString(), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).then(i -> ((String)i.getArgument(0, String.class)).equals("anon-alias"));
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.AnonymousAllowedView.class, null);
        Assertions.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker, (VerificationMode)Mockito.never())).hasAccess((String)ArgumentMatchers.eq((Object)"anon"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker)).hasAccess((String)ArgumentMatchers.eq((Object)"anon-alias"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
    }

    @Test
    public void pathAliasWithParent_aliasPathAllowed_accessGranted() {
        this.eventDataFactory = target -> new Pair((Serializable)((Object)"parent/alias-with-parent"), (Serializable)RouteParameters.empty());
        Mockito.when((Object)this.accessPathChecker.hasAccess(ArgumentMatchers.anyString(), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).then(i -> ((String)i.getArgument(0, String.class)).equals("parent/alias-with-parent"));
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.AnonymousAllowedWithParent.class, null);
        Assertions.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker, (VerificationMode)Mockito.never())).hasAccess((String)ArgumentMatchers.eq((Object)"parent/anon-with-parent"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker)).hasAccess((String)ArgumentMatchers.eq((Object)"parent/alias-with-parent"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
    }

    @Test
    public void wildcardPathAlias_aliasPathAllowed_accessGranted() {
        this.eventDataFactory = target -> new Pair((Serializable)((Object)"anon-alias-wildcard/a/b/c"), (Serializable)new RouteParameters("path", "a/b/c"));
        Mockito.when((Object)this.accessPathChecker.hasAccess(ArgumentMatchers.anyString(), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).then(i -> ((String)i.getArgument(0, String.class)).equals("anon-alias-wildcard/a/b/c"));
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.AnonymousAllowedView.class, null);
        Assertions.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker, (VerificationMode)Mockito.never())).hasAccess((String)ArgumentMatchers.eq((Object)"anon"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker)).hasAccess((String)ArgumentMatchers.eq((Object)"anon-alias-wildcard/a/b/c"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
    }

    @Test
    public void templatePathAlias_aliasPathAllowed_accessGranted() {
        this.eventDataFactory = target -> new Pair((Serializable)((Object)"anon-alias-template/ID-123/C0/resource/12345"), (Serializable)new RouteParameters(Map.of("identifier", "ID-123", "category", "C0", "id", "12345")));
        Mockito.when((Object)this.accessPathChecker.hasAccess(ArgumentMatchers.anyString(), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).then(i -> ((String)i.getArgument(0, String.class)).equals("anon-alias-template/ID-123/C0/resource/12345"));
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.AnonymousAllowedView.class, null);
        Assertions.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker, (VerificationMode)Mockito.never())).hasAccess((String)ArgumentMatchers.eq((Object)"anon"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker)).hasAccess((String)ArgumentMatchers.eq((Object)"anon-alias-template/ID-123/C0/resource/12345"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
    }

    @Test
    public void pathAlias_aliasPathForbidden_accessDenied() {
        this.eventDataFactory = target -> new Pair((Serializable)((Object)"anon-alias"), (Serializable)RouteParameters.empty());
        Mockito.when((Object)this.accessPathChecker.hasAccess(ArgumentMatchers.anyString(), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).then(i -> !((String)i.getArgument(0, String.class)).equals("anon-alias"));
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.AnonymousAllowedView.class, null);
        Assertions.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision(), (String)"Expected alias path not to be allowed");
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker, (VerificationMode)Mockito.never())).hasAccess((String)ArgumentMatchers.eq((Object)"anon"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker)).hasAccess((String)ArgumentMatchers.eq((Object)"anon-alias"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
    }

    @Test
    public void wildcardPathAlias_aliasPathForbidden_accessDenied() {
        this.eventDataFactory = target -> new Pair((Serializable)((Object)"anon-alias-wildcard/a/b/c"), (Serializable)new RouteParameters("path", "a/b/c"));
        Mockito.when((Object)this.accessPathChecker.hasAccess(ArgumentMatchers.anyString(), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).then(i -> !((String)i.getArgument(0, String.class)).equals("anon-alias-wildcard/a/b/c"));
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.AnonymousAllowedView.class, null);
        Assertions.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision(), (String)"Expected alias path not to be allowed");
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker, (VerificationMode)Mockito.never())).hasAccess((String)ArgumentMatchers.eq((Object)"anon"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker)).hasAccess((String)ArgumentMatchers.eq((Object)"anon-alias-wildcard/a/b/c"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
    }

    @Test
    public void pathAliasWithParent_aliasPathForbidden_accessDenied() {
        this.eventDataFactory = target -> new Pair((Serializable)((Object)"parent/alias-with-parent"), (Serializable)RouteParameters.empty());
        Mockito.when((Object)this.accessPathChecker.hasAccess(ArgumentMatchers.anyString(), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).then(i -> !((String)i.getArgument(0, String.class)).equals("parent/alias-with-parent"));
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.AnonymousAllowedWithParent.class, null);
        Assertions.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision(), (String)"Expected alias path not to be allowed");
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker, (VerificationMode)Mockito.never())).hasAccess((String)ArgumentMatchers.eq((Object)"parent/anon-with-parent"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker)).hasAccess((String)ArgumentMatchers.eq((Object)"parent/alias-with-parent"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
    }

    @Test
    public void templatePathAlias_aliasPathForbidden_accessDenied() {
        this.eventDataFactory = target -> new Pair((Serializable)((Object)"anon-alias-template/ID-123/C0/resource/12345"), (Serializable)new RouteParameters(Map.of("identifier", "ID-123", "category", "C0", "id", "12345")));
        Mockito.when((Object)this.accessPathChecker.hasAccess(ArgumentMatchers.anyString(), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).then(i -> !((String)i.getArgument(0, String.class)).equals("anon-alias-template/ID-123/C0/resource/12345"));
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.AnonymousAllowedView.class, null);
        Assertions.assertEquals((Object)AccessCheckDecision.DENY, (Object)result.decision(), (String)"Expected alias path not to be allowed");
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker, (VerificationMode)Mockito.never())).hasAccess((String)ArgumentMatchers.eq((Object)"anon"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker)).hasAccess((String)ArgumentMatchers.eq((Object)"anon-alias-template/ID-123/C0/resource/12345"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
    }

    @Test
    public void templateRoutePath_locationPathIsChecked() {
        this.eventDataFactory = target -> new Pair((Serializable)((Object)"anon-template/ID-123/C0/resource/12345"), (Serializable)new RouteParameters(Map.of("identifier", "ID-123", "category", "C0", "id", "12345")));
        Mockito.when((Object)this.accessPathChecker.hasAccess((String)ArgumentMatchers.eq((Object)"anon-template/ID-123/C0/resource/12345"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn((Object)true);
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.AnonymousAllowedTemplateView.class, null);
        Assertions.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker)).hasAccess((String)ArgumentMatchers.eq((Object)"anon-template/ID-123/C0/resource/12345"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
    }

    @Test
    public void wildcardRoutePath_locationPathIsChecked() {
        this.eventDataFactory = target -> new Pair((Serializable)((Object)"anon-wildcard/a/b/c"), (Serializable)new RouteParameters("path", "a/b/c"));
        Mockito.when((Object)this.accessPathChecker.hasAccess((String)ArgumentMatchers.eq((Object)"anon-wildcard/a/b/c"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn((Object)true);
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.AnonymousAllowedWildcardView.class, null);
        Assertions.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker)).hasAccess((String)ArgumentMatchers.eq((Object)"anon-wildcard/a/b/c"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
    }

    @Test
    public void urlParameterPath_locationPathIsChecked() {
        this.eventDataFactory = target -> new Pair((Serializable)((Object)"anon-url-parameter/a/b/c/d"), (Serializable)RouteParameters.empty());
        Mockito.when((Object)this.accessPathChecker.hasAccess((String)ArgumentMatchers.eq((Object)"anon-url-parameter/a/b/c/d"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn((Object)true);
        AccessCheckResult result = this.checkAccess(AccessControlTestClasses.AnonymousAllowedUrlParameterView.class, null);
        Assertions.assertEquals((Object)AccessCheckResult.allow(), (Object)result);
        ((AccessPathChecker)Mockito.verify((Object)this.accessPathChecker)).hasAccess((String)ArgumentMatchers.eq((Object)"anon-url-parameter/a/b/c/d"), (Principal)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any());
    }

    @Test
    public void rerouteToError_neutral() {
        this.eventDataFactory = target -> new Pair((Serializable)((Object)"some-path"), (Serializable)RouteParameters.empty());
        AccessCheckResult result = this.checkAccess(RouteNotFoundError.class, null);
        Assertions.assertEquals((Object)AccessCheckResult.neutral(), (Object)result);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.accessPathChecker});
    }

    private AccessCheckResult checkAccess(Class<? extends Component> viewClass, User user) {
        NavigationContext context = this.setupNavigationContext(viewClass, user);
        return this.routePathAccessChecker.check(context);
    }

    private NavigationContext setupNavigationContext(Class<? extends Component> navigationTarget, User user) {
        Principal principal;
        CurrentInstance.clearAll();
        HashSet<String> roles = new HashSet<String>();
        if (user == User.USER_NO_ROLES) {
            principal = AccessAnnotationCheckerTest.USER_PRINCIPAL;
        } else if (user == User.NORMAL_USER) {
            principal = AccessAnnotationCheckerTest.USER_PRINCIPAL;
            roles.add("user");
        } else if (user == User.ADMIN) {
            principal = AccessAnnotationCheckerTest.USER_PRINCIPAL;
            roles.add("admin");
        } else {
            principal = null;
        }
        Router router = (Router)Mockito.mock(Router.class);
        UI ui = (UI)Mockito.mock(UI.class);
        Pair<String, RouteParameters> eventData = this.eventDataFactory.apply(navigationTarget);
        Location location = new Location((String)((Object)eventData.getFirst()));
        Object navigationEvent = HasErrorParameter.class.isAssignableFrom(navigationTarget) ? new ErrorNavigationEvent(router, location, ui, NavigationTrigger.ROUTER_LINK, new ErrorParameter(Exception.class, new Exception())) : new NavigationEvent(router, location, ui, NavigationTrigger.ROUTER_LINK);
        BeforeEnterEvent event = new BeforeEnterEvent(navigationEvent, navigationTarget, (RouteParameters)eventData.getSecond(), new ArrayList());
        RouteRegistry routeRegistry = (RouteRegistry)Mockito.mock(RouteRegistry.class);
        Mockito.when((Object)router.getRegistry()).thenReturn((Object)routeRegistry);
        return new NavigationContext(event, principal, roles::contains);
    }

    private Pair<String, RouteParameters> getRouteData(Class<?> navigationTarget) {
        return new Pair((Serializable)((Object)RouteUtil.getRoutePath((VaadinContext)new MockVaadinContext(), navigationTarget)), (Serializable)RouteParameters.empty());
    }

    private static enum User {
        USER_NO_ROLES,
        NORMAL_USER,
        ADMIN;

    }
}

