/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.MockServletServiceSessionSetup;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinRequestInterceptor;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.theme.AbstractTheme;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class VaadinServletServiceTest {
    private MockServletServiceSessionSetup mocks;
    private MockServletServiceSessionSetup.TestVaadinServletService service;
    private VaadinServlet servlet;

    VaadinServletServiceTest() {
    }

    @BeforeEach
    public void setup() throws Exception {
        this.mocks = new MockServletServiceSessionSetup();
        this.service = this.mocks.getService();
        this.servlet = this.mocks.getServlet();
    }

    @AfterEach
    public void tearDown() {
        this.mocks.cleanup();
    }

    @Test
    public void resolveNullThrows() {
        try {
            this.service.resolveResource(null);
            Assertions.fail((String)"null should not resolve");
        }
        catch (NullPointerException e) {
            Assertions.assertEquals((Object)"Url cannot be null", (Object)e.getMessage());
        }
    }

    @Test
    public void resolveResource() {
        Assertions.assertEquals((Object)"", (Object)this.service.resolveResource(""));
        Assertions.assertEquals((Object)"foo", (Object)this.service.resolveResource("foo"));
        Assertions.assertEquals((Object)"/foo", (Object)this.service.resolveResource("context://foo"));
    }

    @Test
    public void resolveResourceNPM_production() {
        this.mocks.setProductionMode(true);
        Assertions.assertEquals((Object)"", (Object)this.service.resolveResource(""));
        Assertions.assertEquals((Object)"foo", (Object)this.service.resolveResource("foo"));
        Assertions.assertEquals((Object)"/foo", (Object)this.service.resolveResource("context://foo"));
    }

    @Test
    public void getContextRootRelativePath_useVariousContextPathAndServletPathsAndPathInfo() throws Exception {
        String location = this.testLocation("http://dummy.host:8080", "/contextpath", "/servlet", "");
        Assertions.assertEquals((Object)"./../", (Object)location);
        location = this.testLocation("http://dummy.host:8080", "/contextpath", "/servlet", "/");
        Assertions.assertEquals((Object)"./../", (Object)location);
        location = this.testLocation("http://dummy.host:8080", "", "/servlet", "");
        Assertions.assertEquals((Object)"./../", (Object)location);
        location = this.testLocation("http://dummy.host", "/contextpath", "/servlet", "/extra/stuff");
        Assertions.assertEquals((Object)"./../", (Object)location);
        location = this.testLocation("http://dummy.host", "/context/path", "/servlet", "/extra/stuff");
        Assertions.assertEquals((Object)"./../", (Object)location);
    }

    @Test
    public void init_classLoaderIsSetUsingServletContext() throws ServiceException {
        VaadinServlet servlet = (VaadinServlet)Mockito.mock(VaadinServlet.class);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)servlet.getServletContext()).thenReturn((Object)context);
        Mockito.when((Object)context.getAttribute(Lookup.class.getName())).thenReturn(Mockito.mock(Lookup.class));
        ClassLoader loader = (ClassLoader)Mockito.mock(ClassLoader.class);
        Mockito.when((Object)context.getClassLoader()).thenReturn((Object)loader);
        VaadinServletService service = new VaadinServletService(servlet, (DeploymentConfiguration)this.mocks.getDeploymentConfiguration()){

            protected Instantiator createInstantiator() throws ServiceException {
                return (Instantiator)Mockito.mock(Instantiator.class);
            }

            protected List<RequestHandler> createRequestHandlers() throws ServiceException {
                return Collections.emptyList();
            }
        };
        service.init();
        Assertions.assertSame((Object)loader, (Object)service.getClassLoader());
    }

    @Test
    public void getPwaRegistry_servletInitialized_getsRegistry() {
        MockServletServiceSessionSetup.TestVaadinServlet vaadinServlet = (MockServletServiceSessionSetup.TestVaadinServlet)((Object)Mockito.spy((Object)((Object)this.mocks.getServlet())));
        Mockito.when((Object)vaadinServlet.getServletContext()).thenAnswer(i -> vaadinServlet.getServletConfig().getServletContext());
        VaadinServletService service = new VaadinServletService((VaadinServlet)vaadinServlet, (DeploymentConfiguration)this.mocks.getDeploymentConfiguration());
        Assertions.assertNotNull((Object)service.getPwaRegistry());
    }

    @Test
    public void getPwaRegistry_servletNotInitialized_getsNull() {
        MockServletServiceSessionSetup.TestVaadinServlet vaadinServlet = (MockServletServiceSessionSetup.TestVaadinServlet)((Object)Mockito.spy((Object)((Object)this.mocks.getServlet())));
        Mockito.when((Object)vaadinServlet.getServletContext()).thenAnswer(i -> vaadinServlet.getServletConfig().getServletContext());
        VaadinServletService service = new VaadinServletService((VaadinServlet)vaadinServlet, (DeploymentConfiguration)this.mocks.getDeploymentConfiguration());
        vaadinServlet.destroy();
        Assertions.assertNull((Object)service.getPwaRegistry());
    }

    private String testLocation(String base, String contextPath, String servletPath, String pathInfo) throws Exception {
        HttpServletRequest request = this.createNonIncludeRequest(base, contextPath, servletPath, pathInfo);
        VaadinServletService service = (VaadinServletService)Mockito.mock(VaadinServletService.class);
        ((VaadinServletService)Mockito.doCallRealMethod().when((Object)service)).getContextRootRelativePath((VaadinRequest)Mockito.any());
        String location = service.getContextRootRelativePath((VaadinRequest)this.servlet.createVaadinRequest(request));
        return location;
    }

    private HttpServletRequest createNonIncludeRequest(String base, String realContextPath, String realServletPath, String pathInfo) throws Exception {
        HttpServletRequest request = this.createRequest(base, realContextPath, realServletPath, pathInfo);
        Mockito.when((Object)request.getAttribute("jakarta.servlet.include.context_path")).thenReturn(null);
        Mockito.when((Object)request.getAttribute("jakarta.servlet.include.servlet_path")).thenReturn(null);
        return request;
    }

    private HttpServletRequest createRequest(String base, String contextPath, String servletPath, String pathInfo) throws MalformedURLException {
        URL url = new URL(base + contextPath + pathInfo);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("null.lock", new ReentrantLock());
        attributes.put("requestStartTime", System.currentTimeMillis());
        Mockito.when((Object)request.isSecure()).thenReturn((Object)url.getProtocol().equalsIgnoreCase("https"));
        Mockito.when((Object)request.getServerName()).thenReturn((Object)url.getHost());
        Mockito.when((Object)request.getServerPort()).thenReturn((Object)url.getPort());
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)url.getPath());
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)contextPath);
        Mockito.when((Object)request.getPathInfo()).thenReturn((Object)pathInfo);
        Mockito.when((Object)request.getServletPath()).thenReturn((Object)servletPath);
        HttpSession session = (HttpSession)Mockito.mock(HttpSession.class);
        Mockito.when((Object)request.getSession()).thenReturn((Object)session);
        Mockito.when((Object)request.getSession(Mockito.anyBoolean())).thenReturn((Object)session);
        VaadinServletServiceTest.stubSessionAttributes(session, attributes);
        VaadinServletServiceTest.stubAttributes(request, attributes);
        return request;
    }

    private static void stubSessionAttributes(HttpSession session, Map<String, Object> attributes) {
        Mockito.when((Object)session.getAttribute(Mockito.anyString())).thenAnswer(invocation -> attributes.get(invocation.getArgument(0)));
        ((HttpSession)Mockito.doAnswer(invocation -> attributes.put((String)invocation.getArgument(0), invocation.getArgument(1))).when((Object)session)).setAttribute(Mockito.anyString(), (Object)Mockito.anyString());
    }

    private static void stubAttributes(HttpServletRequest request, Map<String, Object> attributes) {
        Mockito.when((Object)request.getAttribute(Mockito.anyString())).thenAnswer(invocation -> attributes.get(invocation.getArgument(0)));
        ((HttpServletRequest)Mockito.doAnswer(invocation -> attributes.put((String)invocation.getArgument(0), invocation.getArgument(1))).when((Object)request)).setAttribute(Mockito.anyString(), (Object)Mockito.anyString());
    }

    @Test
    public void filtersAreCalledWhenHandlingARequest() throws Exception {
        this.mocks = new MockServletServiceSessionSetup(this){

            @Override
            public MockServletServiceSessionSetup.TestVaadinServlet createVaadinServlet() {
                return new MockServletServiceSessionSetup.TestVaadinServlet(){

                    @Override
                    public MockServletServiceSessionSetup.TestVaadinServletService createTestVaadinServletService() {
                        return new MockServletServiceSessionSetup.TestVaadinServletService((MockServletServiceSessionSetup.TestVaadinServlet)this, (DeploymentConfiguration)this.getDeploymentConfiguration()){

                            protected List<VaadinRequestInterceptor> createVaadinRequestInterceptors() throws ServiceException {
                                return Collections.singletonList(new MyRequestInterceptor());
                            }
                        };
                    }
                };
            }
        };
        this.service = this.mocks.getService();
        this.servlet = this.mocks.getServlet();
        VaadinServletRequest request = this.servlet.createVaadinRequest(this.createRequest("http://dummy.host:8080/", "/contextpath", "/servlet", "/"));
        VaadinResponse response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        this.service.getRequestHandlers().clear();
        this.service.getRequestHandlers().add(new ExceptionThrowingRequestHandler());
        try {
            this.service.handleRequest((VaadinRequest)request, response);
        }
        catch (ServiceException ex) {
            Assertions.assertTrue((boolean)ex.getMessage().contains("BOOM!"), (String)"The exception was the one coming from RequestHandler");
        }
        Assertions.assertEquals((Object)"true", (Object)request.getAttribute("started"), (String)"Filter was called on request start");
        Assertions.assertEquals((Object)"true", (Object)request.getAttribute("exception handled"), (String)"Filter was called on exception handling");
        Assertions.assertEquals((Object)"true", (Object)request.getAttribute("ended"), (String)"Filter was called in the finally block");
    }

    static class ExceptionThrowingRequestHandler
    implements RequestHandler {
        ExceptionThrowingRequestHandler() {
        }

        public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
            throw new IllegalStateException("BOOM!");
        }
    }

    static class MyRequestInterceptor
    implements VaadinRequestInterceptor {
        MyRequestInterceptor() {
        }

        public void requestStart(VaadinRequest request, VaadinResponse response) {
            request.setAttribute("started", (Object)"true");
        }

        public void handleException(VaadinRequest request, VaadinResponse response, VaadinSession vaadinSession, Exception t) {
            if (t instanceof IllegalStateException) {
                IllegalStateException ex = (IllegalStateException)t;
                Assertions.assertEquals((Object)"BOOM!", (Object)ex.getMessage());
                request.setAttribute("exception handled", (Object)"true");
                return;
            }
            throw new AssertionError("Invalid exception thrown. Wanted <IllegalStateException> got <" + String.valueOf(t.getClass()) + ">", t);
        }

        public void requestEnd(VaadinRequest request, VaadinResponse response, VaadinSession session) {
            request.setAttribute("ended", (Object)"true");
        }
    }

    private final class TestTheme
    implements AbstractTheme {
        private TestTheme() {
        }

        public String getBaseUrl() {
            return "/raw/";
        }

        public String getThemeUrl() {
            return "/theme/";
        }
    }
}

