/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.server.PWA;
import com.vaadin.flow.server.PwaIcon;
import com.vaadin.flow.server.PwaRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@PWA(name="foo", shortName="bar")
class PwaRegistryTest {
    private static List<PwaIcon> splashIconsForAppleDevices;

    PwaRegistryTest() {
    }

    @BeforeAll
    public static void initPwaWithCustomIconPath() throws IOException {
        PwaRegistry registry = PwaRegistryTest.preparePwaRegistry(PwaWithCustomIconPath.class.getAnnotation(PWA.class));
        splashIconsForAppleDevices = registry.getIcons().stream().filter(icon -> "apple-touch-startup-image".equals(icon.getRel())).collect(Collectors.toList());
    }

    @Test
    public void pwaIconIsGeneratedBasedOnClasspathIcon_servletContextHasNoResources() throws IOException {
        PwaRegistry registry = PwaRegistryTest.preparePwaRegistry(PwaRegistryTest.class.getAnnotation(PWA.class));
        List icons = registry.getIcons();
        PwaIcon pwaIcon = icons.stream().filter(icon -> icon.getWidth() == 32).findFirst().get();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        pwaIcon.write((OutputStream)stream);
        Assertions.assertEquals((int)26, (int)stream.toByteArray()[36]);
    }

    /*
     * Exception decompiling
     */
    private static PwaRegistry preparePwaRegistry(PWA pwa) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void pwaWithCustomBaseIconPath_splashScreenIconForAllSupportedAppleDevicesAndOrientationsAreGenerated() {
        Assertions.assertEquals((int)26, (int)splashIconsForAppleDevices.size());
    }

    @Test
    public void pwaWithCustomBaseIconPath_splashScreenIconForAppleDevices_areGeneratedBasedOnIconPath() {
        boolean customBaseNameUsedInIconGeneration = splashIconsForAppleDevices.stream().allMatch(icon -> icon.getHref().startsWith("icons/splash/foo"));
        Assertions.assertTrue((boolean)customBaseNameUsedInIconGeneration);
    }

    @Test
    public void pwaWithCustomBaseIconPath_splashScreenIconForIPadDevices_includeBothOrientations() {
        Predicate<PwaIcon> iPadPro129 = icon -> icon.getWidth() == 2048 && icon.getHeight() == 2732 || icon.getWidth() == 2732 && icon.getHeight() == 2048;
        List mediaQueriesForIPadPro129 = splashIconsForAppleDevices.stream().filter(iPadPro129).map(icon -> icon.asElement().attr("media")).collect(Collectors.toList());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPadPro129.stream().filter(media -> media.contains("portrait")).count());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPadPro129.stream().filter(media -> media.contains("landscape")).count());
        Predicate<PwaIcon> iPadPro11And105 = icon -> icon.getWidth() == 1668 && icon.getHeight() == 2388 || icon.getWidth() == 2388 && icon.getHeight() == 1668;
        List mediaQueriesForIPadPro11And105 = splashIconsForAppleDevices.stream().filter(iPadPro11And105).map(icon -> icon.asElement().attr("media")).collect(Collectors.toList());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPadPro11And105.stream().filter(media -> media.contains("portrait")).count());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPadPro11And105.stream().filter(media -> media.contains("landscape")).count());
        Predicate<PwaIcon> iPadAir105 = icon -> icon.getWidth() == 1668 && icon.getHeight() == 2224 || icon.getWidth() == 2224 && icon.getHeight() == 1668;
        List mediaQueriesForIPadAir105 = splashIconsForAppleDevices.stream().filter(iPadAir105).map(icon -> icon.asElement().attr("media")).collect(Collectors.toList());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPadAir105.stream().filter(media -> media.contains("portrait")).count());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPadAir105.stream().filter(media -> media.contains("landscape")).count());
        Predicate<PwaIcon> iPad102 = icon -> icon.getWidth() == 1620 && icon.getHeight() == 2160 || icon.getWidth() == 2160 && icon.getHeight() == 1620;
        List mediaQueriesForIPad102 = splashIconsForAppleDevices.stream().filter(iPad102).map(icon -> icon.asElement().attr("media")).collect(Collectors.toList());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPad102.stream().filter(media -> media.contains("portrait")).count());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPad102.stream().filter(media -> media.contains("landscape")).count());
        Predicate<PwaIcon> iPad97And79 = icon -> icon.getWidth() == 1536 && icon.getHeight() == 2048 || icon.getWidth() == 2048 && icon.getHeight() == 1536;
        List mediaQueriesForIPad97And79 = splashIconsForAppleDevices.stream().filter(iPad97And79).map(icon -> icon.asElement().attr("media")).collect(Collectors.toList());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPad97And79.stream().filter(media -> media.contains("portrait")).count());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPad97And79.stream().filter(media -> media.contains("landscape")).count());
    }

    @Test
    public void pwaWithCustomBaseIconPath_splashScreenIconForIPhoneDevices_includeBothOrientations() {
        Predicate<PwaIcon> iPhone13ProMaxAnd12ProMax = icon -> icon.getWidth() == 1284 && icon.getHeight() == 2778 || icon.getWidth() == 2778 && icon.getHeight() == 1284;
        List mediaQueriesForIPhone13ProMaxAnd12ProMax = splashIconsForAppleDevices.stream().filter(iPhone13ProMaxAnd12ProMax).map(icon -> icon.asElement().attr("media")).collect(Collectors.toList());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPhone13ProMaxAnd12ProMax.stream().filter(media -> media.contains("portrait")).count());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPhone13ProMaxAnd12ProMax.stream().filter(media -> media.contains("landscape")).count());
        Predicate<PwaIcon> iPhone13ProAnd12ProAnd13And12 = icon -> icon.getWidth() == 1170 && icon.getHeight() == 2532 || icon.getWidth() == 2532 && icon.getHeight() == 1170;
        List mediaQueriesForIPhone13ProAnd12ProAnd13And12 = splashIconsForAppleDevices.stream().filter(iPhone13ProAnd12ProAnd13And12).map(icon -> icon.asElement().attr("media")).collect(Collectors.toList());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPhone13ProAnd12ProAnd13And12.stream().filter(media -> media.contains("portrait")).count());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPhone13ProAnd12ProAnd13And12.stream().filter(media -> media.contains("landscape")).count());
        Predicate<PwaIcon> iPhone13MiniAnd12MiniAnd11ProAndXSAndX = icon -> icon.getWidth() == 1125 && icon.getHeight() == 2436 || icon.getWidth() == 2436 && icon.getHeight() == 1125;
        List mediaQueriesForIPhone13MiniAnd12MiniAnd11ProAndXSAndX = splashIconsForAppleDevices.stream().filter(iPhone13MiniAnd12MiniAnd11ProAndXSAndX).map(icon -> icon.asElement().attr("media")).collect(Collectors.toList());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPhone13MiniAnd12MiniAnd11ProAndXSAndX.stream().filter(media -> media.contains("portrait")).count());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPhone13MiniAnd12MiniAnd11ProAndXSAndX.stream().filter(media -> media.contains("landscape")).count());
        Predicate<PwaIcon> iPhone11ProMaxAndXSMax = icon -> icon.getWidth() == 1242 && icon.getHeight() == 2688 || icon.getWidth() == 2688 && icon.getHeight() == 1242;
        List mediaQueriesForIPhone11ProMaxAndXSMax = splashIconsForAppleDevices.stream().filter(iPhone11ProMaxAndXSMax).map(icon -> icon.asElement().attr("media")).collect(Collectors.toList());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPhone11ProMaxAndXSMax.stream().filter(media -> media.contains("portrait")).count());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPhone11ProMaxAndXSMax.stream().filter(media -> media.contains("landscape")).count());
        Predicate<PwaIcon> iPhone11AndXR = icon -> icon.getWidth() == 828 && icon.getHeight() == 1792 || icon.getWidth() == 1792 && icon.getHeight() == 828;
        List mediaQueriesForIPhone11AndXR = splashIconsForAppleDevices.stream().filter(iPhone11AndXR).map(icon -> icon.asElement().attr("media")).collect(Collectors.toList());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPhone11AndXR.stream().filter(media -> media.contains("portrait")).count());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPhone11AndXR.stream().filter(media -> media.contains("landscape")).count());
        Predicate<PwaIcon> iPhone8PlusAnd7PlusAnd6sPlusAnd6Plus = icon -> icon.getWidth() == 1242 && icon.getHeight() == 2208 || icon.getWidth() == 2208 && icon.getHeight() == 1242;
        List mediaQueriesForIPhone8PlusAnd7PlusAnd6sPlusAnd6Plus = splashIconsForAppleDevices.stream().filter(iPhone8PlusAnd7PlusAnd6sPlusAnd6Plus).map(icon -> icon.asElement().attr("media")).collect(Collectors.toList());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPhone8PlusAnd7PlusAnd6sPlusAnd6Plus.stream().filter(media -> media.contains("portrait")).count());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPhone8PlusAnd7PlusAnd6sPlusAnd6Plus.stream().filter(media -> media.contains("landscape")).count());
        Predicate<PwaIcon> iPhone8And7And6sAnd6AndSE47 = icon -> icon.getWidth() == 750 && icon.getHeight() == 1334 || icon.getWidth() == 1334 && icon.getHeight() == 750;
        List mediaQueriesForIPhone8And7And6sAnd6AndSE47 = splashIconsForAppleDevices.stream().filter(iPhone8And7And6sAnd6AndSE47).map(icon -> icon.asElement().attr("media")).collect(Collectors.toList());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPhone8And7And6sAnd6AndSE47.stream().filter(media -> media.contains("portrait")).count());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPhone8And7And6sAnd6AndSE47.stream().filter(media -> media.contains("landscape")).count());
        Predicate<PwaIcon> iPhone5AndSE47AndIPod5AndLater = icon -> icon.getWidth() == 640 && icon.getHeight() == 1136 || icon.getWidth() == 1136 && icon.getHeight() == 640;
        List mediaQueriesForIPhone5AndSE47AndIPod5AndLater = splashIconsForAppleDevices.stream().filter(iPhone5AndSE47AndIPod5AndLater).map(icon -> icon.asElement().attr("media")).collect(Collectors.toList());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPhone5AndSE47AndIPod5AndLater.stream().filter(media -> media.contains("portrait")).count());
        Assertions.assertEquals((long)1L, (long)mediaQueriesForIPhone5AndSE47AndIPod5AndLater.stream().filter(media -> media.contains("landscape")).count());
    }

    @Test
    public void pwaWithCustomOfflinePath_getRuntimeServiceWorkerJsContainsCustomOfflinePath() throws IOException {
        PwaRegistry registry = PwaRegistryTest.preparePwaRegistry(PwaWithCustomOfflinePath.class.getAnnotation(PWA.class));
        Assertions.assertTrue((boolean)registry.getRuntimeServiceWorkerJs().contains("some/path.html"));
        Assertions.assertFalse((boolean)registry.getRuntimeServiceWorkerJs().contains("{ url: '.', revision:"));
    }

    @Test
    public void pwaWithoutCustomOfflinePath_getRuntimeServiceWorkerJsContainsCustomOfflinePath() throws IOException {
        PwaRegistry registry = PwaRegistryTest.preparePwaRegistry(PwaRegistryTest.class.getAnnotation(PWA.class));
        Assertions.assertTrue((boolean)registry.getRuntimeServiceWorkerJs().contains("{ url: '.', revision:"));
    }

    private static /* synthetic */ void lambda$preparePwaRegistry$3() throws Throwable {
        FeatureFlags.get((VaadinContext)((VaadinContext)Mockito.any()));
    }

    private static /* synthetic */ void lambda$preparePwaRegistry$2() throws Throwable {
        ApplicationConfiguration.get((VaadinContext)((VaadinContext)Mockito.any()));
    }

    @PWA(name="Custom Icon Path", shortName="CIP", iconPath="icons/splash/foo.png")
    private static class PwaWithCustomIconPath {
        private PwaWithCustomIconPath() {
        }
    }

    @PWA(name="Custom Icon Path", shortName="COP", offlinePath="some/path.html")
    private static class PwaWithCustomOfflinePath {
        private PwaWithCustomOfflinePath() {
        }
    }
}

