/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.di.DefaultInstantiator;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.ParentLayout;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.MockVaadinContext;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import net.jcip.annotations.NotThreadSafe;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@NotThreadSafe
class ErrorHandlerUtilTest {
    @Mock
    UI ui;
    @Mock
    VaadinService vaadinService;
    @Mock
    DeploymentConfiguration config;
    AlwaysLockedVaadinSession session;
    UIInternals internals;
    ApplicationRouteRegistry registry;

    ErrorHandlerUtilTest() {
    }

    @BeforeEach
    public void init() {
        MockitoAnnotations.initMocks((Object)this);
        ErrorView.setError = false;
        ErrorView.initialized = false;
        Element body = new Element("body");
        Mockito.when((Object)this.ui.getElement()).thenReturn((Object)body);
        Mockito.when((Object)this.ui.isNavigationSupported()).thenReturn((Object)true);
        this.internals = new UIInternals(this.ui);
        Mockito.when((Object)this.ui.getUI()).thenReturn(Optional.of(this.ui));
        Mockito.when((Object)this.ui.getInternals()).thenReturn((Object)this.internals);
        RouteRegistry routeRegistry = (RouteRegistry)Mockito.mock(RouteRegistry.class);
        Mockito.when((Object)routeRegistry.getRegisteredRoutes()).thenReturn(new ArrayList());
        Mockito.when((Object)this.vaadinService.getRouteRegistry()).thenReturn((Object)routeRegistry);
        this.session = new AlwaysLockedVaadinSession(this.vaadinService);
        MockVaadinContext context = new MockVaadinContext();
        Mockito.when((Object)this.vaadinService.getContext()).thenReturn((Object)context);
        Mockito.when((Object)this.vaadinService.getInstantiator()).thenReturn((Object)new DefaultInstantiator(this.vaadinService));
        this.internals.setSession((VaadinSession)this.session);
        Mockito.when((Object)this.vaadinService.getRouter()).thenReturn((Object)((Router)Mockito.mock(Router.class)));
        Mockito.when((Object)this.ui.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.vaadinService.getDeploymentConfiguration()).thenReturn((Object)this.config);
        Mockito.when((Object)this.vaadinService.accessSession((VaadinSession)Mockito.any(VaadinSession.class), (Command)Mockito.any(Command.class))).thenCallRealMethod();
        Mockito.when((Object)this.ui.access((Command)Mockito.any(Command.class))).thenCallRealMethod();
        this.registry = ApplicationRouteRegistry.getInstance((VaadinContext)context);
        VaadinService.setCurrent((VaadinService)this.vaadinService);
        UI.setCurrent((UI)this.ui);
    }

    @AfterEach
    public void cleanup() {
        VaadinService.setCurrent(null);
        UI.setCurrent(null);
    }

    @Test
    public void nullPointerException_executesErrorView() {
        this.registry.setErrorNavigationTargets(Collections.singleton(ErrorView.class));
        Assertions.assertEquals((long)0L, (long)this.ui.getElement().getChildren().count());
        this.ui.access((Command & Serializable)() -> {});
        this.session.getPendingAccessQueue().forEach(futureAccess -> futureAccess.handleError((Exception)new NullPointerException("NPE")));
        Assertions.assertTrue((boolean)ErrorView.initialized);
        Assertions.assertTrue((boolean)ErrorView.setError);
        Assertions.assertEquals((long)1L, (long)this.ui.getElement().getChildren().count());
    }

    @Test
    public void illegalArgumentException_doesNotExecuteErrorView() {
        this.registry.setErrorNavigationTargets(Collections.singleton(ErrorView.class));
        Assertions.assertEquals((long)0L, (long)this.ui.getElement().getChildren().count());
        this.ui.access((Command & Serializable)() -> {});
        this.session.getPendingAccessQueue().forEach(futureAccess -> futureAccess.handleError((Exception)new IllegalArgumentException("IAE")));
        Assertions.assertFalse((boolean)ErrorView.initialized);
        Assertions.assertFalse((boolean)ErrorView.setError);
        Assertions.assertEquals((long)0L, (long)this.ui.getElement().getChildren().count());
    }

    @Test
    public void redrawnExceptionView_alsoInitializesParent() {
        this.registry.setErrorNavigationTargets(Collections.singleton(ErrorWithParentView.class));
        Assertions.assertEquals((long)0L, (long)this.ui.getElement().getChildren().count());
        this.ui.access((Command & Serializable)() -> {});
        this.session.getPendingAccessQueue().forEach(futureAccess -> futureAccess.handleError((Exception)new NullPointerException("NPE")));
        Assertions.assertTrue((boolean)ErrorWithParentView.initialized);
        Assertions.assertTrue((boolean)ErrorWithParentView.setError);
        Assertions.assertTrue((boolean)ParentView.initialized);
        Assertions.assertEquals((long)1L, (long)this.ui.getElement().getChildren().count());
    }

    @Tag(value="div")
    protected static class ErrorView
    extends Component
    implements HasErrorParameter<NullPointerException> {
        public static boolean setError = false;
        public static boolean initialized = false;

        public ErrorView() {
            initialized = true;
            setError = false;
        }

        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<NullPointerException> parameter) {
            this.getElement().setText("Nope!");
            setError = true;
            return 0;
        }
    }

    @Tag(value="div")
    @ParentLayout(value=ParentView.class)
    protected static class ErrorWithParentView
    extends Component
    implements HasErrorParameter<NullPointerException> {
        public static boolean setError = false;
        public static boolean initialized = false;

        public ErrorWithParentView() {
            initialized = true;
            setError = false;
        }

        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<NullPointerException> parameter) {
            this.getElement().setText("Nope!");
            setError = true;
            return 0;
        }
    }

    @Tag(value="div")
    protected static class ParentView
    extends Component
    implements RouterLayout {
        public static boolean initialized = false;

        public ParentView() {
            initialized = true;
        }
    }
}

