/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.MockServletServiceSessionSetup;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletService;
import jakarta.servlet.http.HttpServletRequest;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class AppShellRegistryStyleSheetDataFilePathTest {
    private MockServletServiceSessionSetup mocks;
    private VaadinServletContext context;
    private Document document;

    AppShellRegistryStyleSheetDataFilePathTest() {
    }

    @BeforeEach
    public void setup() {
        this.mocks = new MockServletServiceSessionSetup();
        this.context = new VaadinServletContext(this.mocks.getServletContext());
        VaadinService.setCurrent((VaadinService)this.mocks.getService());
        this.document = Document.createShell((String)"");
    }

    @AfterEach
    public void teardown() throws Exception {
        AppShellRegistry.getInstance((VaadinContext)this.context).reset();
        this.mocks.cleanup();
    }

    @Test
    public void modifyIndex_addsDataFilePathAttributes_normalized() throws Exception {
        AppShellRegistry registry = AppShellRegistry.getInstance((VaadinContext)this.context);
        registry.setShell(MyShell.class);
        VaadinServletRequest request = this.createRequest("/", "/ctx");
        registry.modifyIndexHtml(this.document, (VaadinRequest)request);
        Elements links = this.document.head().select("link[rel=stylesheet]");
        Assertions.assertEquals((int)4, (int)links.size());
        Element abs = (Element)links.get(0);
        Assertions.assertEquals((Object)"/absolute.css", (Object)abs.attr("href"));
        Assertions.assertEquals((Object)"absolute.css", (Object)abs.attr("data-file-path"));
        Element rel = (Element)links.get(1);
        Assertions.assertEquals((Object)"/ctx/relative/path.css", (Object)rel.attr("href"));
        Assertions.assertEquals((Object)"relative/path.css", (Object)rel.attr("data-file-path"));
        Element ctx = (Element)links.get(2);
        Assertions.assertEquals((Object)"/ctx/from-context.css", (Object)ctx.attr("href"));
        Assertions.assertEquals((Object)"from-context.css", (Object)ctx.attr("data-file-path"));
        Element remote = (Element)links.get(3);
        Assertions.assertEquals((Object)"https://cdn.example.com/remote.css", (Object)remote.attr("href"));
        Assertions.assertEquals((Object)"https://cdn.example.com/remote.css", (Object)remote.attr("data-file-path"));
    }

    private VaadinServletRequest createRequest(String pathInfo, String contextPath) {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getServletPath()).thenReturn((Object)"");
        Mockito.when((Object)req.getPathInfo()).thenReturn((Object)pathInfo);
        Mockito.when((Object)req.getRequestURL()).thenReturn((Object)new StringBuffer(pathInfo));
        Mockito.when((Object)req.getContextPath()).thenReturn((Object)contextPath);
        return new VaadinServletRequest(req, (VaadinServletService)this.mocks.getService());
    }

    @StyleSheet.Container(value={@StyleSheet(value="/absolute.css"), @StyleSheet(value="./relative/path.css"), @StyleSheet(value="context://from-context.css"), @StyleSheet(value="https://cdn.example.com/remote.css")})
    public static class MyShell
    implements AppShellConfigurator {
    }
}

