/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.AbstractConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class AbstractConfigurationTest {
    @TempDir
    Path temporaryFolder;
    AbstractConfiguration configuration = new AbstractConfiguration(){

        public boolean isProductionMode() {
            return false;
        }

        public String getStringProperty(String name, String defaultValue) {
            return null;
        }

        public boolean getBooleanProperty(String name, boolean defaultValue) {
            return false;
        }
    };

    AbstractConfigurationTest() {
    }

    @Test
    public void getProjectFolder_mavenProject_detected() throws IOException {
        this.assertProjectFolderDetected("pom.xml");
    }

    @Test
    public void getProjectFolder_gradleProject_detected() throws IOException {
        this.assertProjectFolderDetected("build.gradle");
    }

    @Test
    public void getProjectFolder_gradleKotlinProject_detected() throws IOException {
        this.assertProjectFolderDetected("build.gradle.kts");
    }

    @Test
    public void getProjectFolder_unknownProject_throws() throws IOException {
        this.withTemporaryUserDir(() -> {
            IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ((AbstractConfiguration)this.configuration).getProjectFolder());
            Assertions.assertTrue((boolean)exception.getMessage().contains("Failed to determine project directory for dev mode"));
            Assertions.assertTrue((boolean)exception.getMessage().contains(this.temporaryFolder.toFile().getAbsolutePath()));
        });
    }

    private void assertProjectFolderDetected(String projectFile) throws IOException {
        Files.createFile(this.temporaryFolder.resolve(projectFile), new FileAttribute[0]);
        this.withTemporaryUserDir(() -> {
            File projectFolder = this.configuration.getProjectFolder();
            Assertions.assertEquals((Object)this.temporaryFolder.toFile(), (Object)projectFolder);
        });
    }

    private void withTemporaryUserDir(Runnable test) throws IOException {
        String userDir = System.getProperty("user.dir");
        try {
            System.setProperty("user.dir", this.temporaryFolder.toFile().getAbsolutePath());
            test.run();
        }
        finally {
            if (userDir != null) {
                System.setProperty("user.dir", userDir);
            } else {
                System.clearProperty("user.dir");
            }
        }
    }
}

