/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.internal.ConfigureRoutes;
import com.vaadin.flow.router.internal.ConfiguredRoutes;
import com.vaadin.flow.server.AmbiguousRouteConfigurationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ConfigureRoutesTest {
    ConfigureRoutesTest() {
    }

    @Test
    public void mutableConfiguration_canSetRouteTarget() {
        ConfigureRoutes mutable = new ConfigureRoutes();
        mutable.setRoute("", BaseTarget.class);
        Assertions.assertTrue((boolean)mutable.hasTemplate(""), (String)"Configuration should have \"\" route registered");
        Assertions.assertEquals(BaseTarget.class, mutable.getTarget("").get(), (String)"Configuration should have registered base target.");
    }

    @Test
    public void mutableConfiguration_canSetTargetRoute() {
        ConfigureRoutes mutable = new ConfigureRoutes();
        mutable.setRoute("", BaseTarget.class);
        Assertions.assertTrue((boolean)mutable.hasRouteTarget(BaseTarget.class), (String)"");
        Assertions.assertEquals((Object)"", (Object)mutable.getTemplate(BaseTarget.class), (String)"Configuration should have registered base target.");
    }

    @Test
    public void mutableConfigurationClear_removesRegisteredRoutes() {
        ConfigureRoutes mutable = new ConfigureRoutes();
        this.assertSetRoutes(mutable);
        mutable.clear();
        Assertions.assertFalse((boolean)mutable.hasRouteTarget(BaseTarget.class));
        Assertions.assertFalse((boolean)mutable.hasRouteTarget(ParamTarget.class));
        Assertions.assertNull((Object)mutable.getNavigationRouteTarget("").getRouteTarget());
        Assertions.assertNull((Object)mutable.getNavigationRouteTarget("123").getRouteTarget());
        this.assertSetRoutes(mutable);
    }

    @Test
    public void mutableConfigurationClear_preservesErrorRoute() {
        ConfigureRoutes mutable = new ConfigureRoutes();
        mutable.setErrorRoute(IndexOutOfBoundsException.class, BaseError.class);
        mutable.clear();
        Assertions.assertEquals(BaseError.class, (Object)mutable.getExceptionHandlerByClass(IndexOutOfBoundsException.class), (String)"ErrorRoute shouldn't be cleared.");
    }

    @Test
    public void duplicateRootPathRegistration_throwsException() {
        ConfigureRoutes mutable = new ConfigureRoutes();
        mutable.setRoute("", BaseTarget.class);
        Assertions.assertTrue((boolean)mutable.hasRouteTarget(BaseTarget.class));
        Assertions.assertEquals(BaseTarget.class, (Object)mutable.getNavigationRouteTarget("").getRouteTarget().getTarget());
        AmbiguousRouteConfigurationException ex = (AmbiguousRouteConfigurationException)Assertions.assertThrows(AmbiguousRouteConfigurationException.class, () -> mutable.setRoute("", BaseTarget.class));
        Assertions.assertTrue((boolean)ex.getMessage().contains(String.format("Navigation target paths (considering @Route, @RouteAlias and @RoutePrefix values) must be unique, found navigation targets '%s' and '%s' having the same route.", "com.vaadin.flow.router.internal.ConfigureRoutesTest$BaseTarget", "com.vaadin.flow.router.internal.ConfigureRoutesTest$BaseTarget")));
    }

    @Test
    public void duplicateParameterPathRegistration_throwsException() {
        ConfigureRoutes mutable = new ConfigureRoutes();
        mutable.setRoute(":param", ParamTarget.class);
        Assertions.assertTrue((boolean)mutable.hasRouteTarget(ParamTarget.class));
        Assertions.assertEquals(ParamTarget.class, (Object)mutable.getNavigationRouteTarget("123").getRouteTarget().getTarget());
        AmbiguousRouteConfigurationException ex = (AmbiguousRouteConfigurationException)Assertions.assertThrows(AmbiguousRouteConfigurationException.class, () -> mutable.setRoute(":param", ParamTarget.class));
        Assertions.assertTrue((boolean)ex.getMessage().contains(String.format("Navigation target paths (considering @Route, @RouteAlias and @RoutePrefix values) must be unique, found navigation targets '%s' and '%s' with parameter having the same route.", "com.vaadin.flow.router.internal.ConfigureRoutesTest$ParamTarget", "com.vaadin.flow.router.internal.ConfigureRoutesTest$ParamTarget")));
    }

    @Test
    public void mutableConfiguration_makingImmutableHasCorrectData() {
        ConfigureRoutes mutable = new ConfigureRoutes();
        mutable.setRoute("", BaseTarget.class);
        ConfiguredRoutes immutable = new ConfiguredRoutes(mutable);
        Assertions.assertTrue((boolean)immutable.hasTemplate(""), (String)"Configuration should have \"\" route registered");
        Assertions.assertEquals(BaseTarget.class, immutable.getTarget("").get(), (String)"Configuration should have registered base target.");
        Assertions.assertTrue((boolean)immutable.hasRouteTarget(BaseTarget.class), (String)"");
        Assertions.assertEquals((Object)"", (Object)immutable.getTemplate(BaseTarget.class), (String)"Configuration should have registered base target.");
    }

    @Test
    public void mutableConfiguration_canSetErrorTargets() {
        ConfigureRoutes mutable = new ConfigureRoutes();
        mutable.setErrorRoute(IndexOutOfBoundsException.class, BaseError.class);
        Assertions.assertFalse((boolean)mutable.getExceptionHandlers().isEmpty(), (String)"Exception targets should be available");
        Assertions.assertEquals(BaseError.class, (Object)mutable.getExceptionHandlerByClass(IndexOutOfBoundsException.class), (String)"Given exception returned unexpected handler class");
    }

    @Test
    public void populatedMutableConfiguration_clearRemovesAllContent() {
        ConfigureRoutes mutable = new ConfigureRoutes();
        mutable.setRoute("", BaseTarget.class);
        mutable.setErrorRoute(IndexOutOfBoundsException.class, BaseError.class);
        Assertions.assertFalse((boolean)mutable.getRoutes().isEmpty(), (String)"Configuration should have routes.");
        Assertions.assertFalse((boolean)mutable.getExceptionHandlers().isEmpty(), (String)"Configuration should have exceptions.");
        mutable.clear();
        Assertions.assertTrue((boolean)mutable.getRoutes().isEmpty(), (String)"After clear all routes should have been removed.");
        Assertions.assertTrue((boolean)mutable.getTargetRoutes().isEmpty(), (String)"After clear all targetRoutes should have been removed. ");
        Assertions.assertFalse((boolean)mutable.getExceptionHandlers().isEmpty(), (String)"After clear  exception targets should still be available.");
    }

    private void assertSetRoutes(ConfigureRoutes mutable) {
        mutable.setRoute("", BaseTarget.class);
        mutable.setRoute(":param", ParamTarget.class);
        Assertions.assertTrue((boolean)mutable.hasRouteTarget(BaseTarget.class));
        Assertions.assertTrue((boolean)mutable.hasRouteTarget(ParamTarget.class));
        Assertions.assertEquals(BaseTarget.class, (Object)mutable.getNavigationRouteTarget("").getRouteTarget().getTarget());
        Assertions.assertEquals(ParamTarget.class, (Object)mutable.getNavigationRouteTarget("123").getRouteTarget().getTarget());
    }

    @Tag(value="div")
    public static class BaseTarget
    extends Component {
    }

    @Tag(value="div")
    public static class ParamTarget
    extends Component
    implements HasUrlParameter<String> {
        public void setParameter(BeforeEvent event, String parameter) {
        }
    }

    @Tag(value="div")
    public static class BaseError
    extends Component
    implements HasErrorParameter<IndexOutOfBoundsException> {
        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<IndexOutOfBoundsException> parameter) {
            return 0;
        }
    }
}

