/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.router.QueryParameters;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class QueryParametersTest {
    private final String simpleInputQueryString = "one=1&two=2&three=3&four&five=4%2F5%266%2B7&six=one+%2B+one%20%3D%20two";
    private final String complexInputQueryString = "one=1&one=11&two=2&two=22&three=3&four&five=4%2F5%266%2B7&six=one+%2B+one%20%3D%20two";

    QueryParametersTest() {
    }

    private Map<String, String> getSimpleInputParameters() {
        HashMap<String, String> inputParameters = new HashMap<String, String>();
        inputParameters.put("one", "1");
        inputParameters.put("two", "2");
        inputParameters.put("three", "3");
        return inputParameters;
    }

    private Map<String, String[]> getFullInputParameters() {
        HashMap<String, String[]> inputParameters = new HashMap<String, String[]>();
        inputParameters.put("one", new String[]{"1", "11"});
        inputParameters.put("two", new String[]{"2", "22"});
        inputParameters.put("three", new String[]{"3"});
        return inputParameters;
    }

    private void checkListsForImmutability(Collection<List<String>> lists) {
        for (List<String> list : lists) {
            try {
                list.add("whatever");
                Assertions.fail((String)"No list should have been mutable");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    @Test
    public void emptyParameters() {
        QueryParameters emptyParams = QueryParameters.empty();
        Assertions.assertEquals(Collections.emptyMap(), (Object)emptyParams.getParameters());
    }

    @Test
    public void emptyParametersToQueryString() {
        QueryParameters emptyParams = QueryParameters.empty();
        Assertions.assertEquals((Object)"", (Object)emptyParams.getQueryString());
    }

    @Test
    public void underlyingMapUnmodifiable_empty() {
        Map parameters = QueryParameters.empty().getParameters();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> parameters.put("one", Collections.emptyList()));
    }

    @Test
    public void simpleParameters() {
        QueryParameters simpleParams = QueryParameters.simple(this.getSimpleInputParameters());
        HashMap<String, List<String>> expectedFullParams = new HashMap<String, List<String>>();
        expectedFullParams.put("one", Collections.singletonList("1"));
        expectedFullParams.put("two", Collections.singletonList("2"));
        expectedFullParams.put("three", Collections.singletonList("3"));
        Assertions.assertEquals(expectedFullParams, (Object)simpleParams.getParameters());
    }

    @Test
    public void simpleParametersFromQueryString() {
        QueryParameters simpleParams = QueryParameters.fromString((String)"one=1&two=2&three=3&four&five=4%2F5%266%2B7&six=one+%2B+one%20%3D%20two");
        HashMap<String, List<String>> expectedFullParams = new HashMap<String, List<String>>();
        expectedFullParams.put("one", Collections.singletonList("1"));
        expectedFullParams.put("two", Collections.singletonList("2"));
        expectedFullParams.put("three", Collections.singletonList("3"));
        expectedFullParams.put("four", Collections.singletonList(""));
        expectedFullParams.put("five", Collections.singletonList("4/5&6+7"));
        expectedFullParams.put("six", Collections.singletonList("one + one = two"));
        Assertions.assertEquals(expectedFullParams, (Object)simpleParams.getParameters());
    }

    @Test
    public void simpleParametersToQueryString() {
        QueryParameters simpleParams = QueryParameters.simple(this.getSimpleInputParameters());
        String queryString = simpleParams.getQueryString();
        Assertions.assertTrue((boolean)queryString.contains("one=1"));
        Assertions.assertTrue((boolean)queryString.contains("two=2"));
        Assertions.assertTrue((boolean)queryString.contains("three=3"));
        Assertions.assertTrue((boolean)queryString.contains("&"));
        this.assertNumberOfOccurences(queryString, 2, "&");
    }

    @Test
    public void underlyingMapUnmodifiable_simple() {
        Map parameters = QueryParameters.simple(this.getSimpleInputParameters()).getParameters();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> parameters.put("one", Collections.emptyList()));
    }

    @Test
    public void underlyingListsUnmodifiable_simple() {
        this.checkListsForImmutability(QueryParameters.simple(this.getSimpleInputParameters()).getParameters().values());
    }

    @Test
    public void complexParameters() {
        QueryParameters fullParams = QueryParameters.full(this.getFullInputParameters());
        HashMap<String, List<String>> expectedFullParams = new HashMap<String, List<String>>();
        expectedFullParams.put("one", Arrays.asList("1", "11"));
        expectedFullParams.put("two", Arrays.asList("2", "22"));
        expectedFullParams.put("three", Collections.singletonList("3"));
        Assertions.assertEquals(expectedFullParams, (Object)fullParams.getParameters());
    }

    @Test
    public void complexParametersFromQueryString() {
        QueryParameters fullParams = QueryParameters.fromString((String)"one=1&one=11&two=2&two=22&three=3&four&five=4%2F5%266%2B7&six=one+%2B+one%20%3D%20two");
        HashMap<String, List<String>> expectedFullParams = new HashMap<String, List<String>>();
        expectedFullParams.put("one", Arrays.asList("1", "11"));
        expectedFullParams.put("two", Arrays.asList("2", "22"));
        expectedFullParams.put("three", Collections.singletonList("3"));
        expectedFullParams.put("four", Collections.singletonList(""));
        expectedFullParams.put("five", Collections.singletonList("4/5&6+7"));
        expectedFullParams.put("six", Collections.singletonList("one + one = two"));
        Assertions.assertEquals(expectedFullParams, (Object)fullParams.getParameters());
    }

    @Test
    public void complexParametersToQueryString() {
        QueryParameters fullParams = QueryParameters.full(this.getFullInputParameters());
        String queryString = fullParams.getQueryString();
        Assertions.assertTrue((boolean)queryString.contains("one=1"));
        Assertions.assertTrue((boolean)queryString.contains("one=11"));
        Assertions.assertTrue((boolean)queryString.contains("two=2"));
        Assertions.assertTrue((boolean)queryString.contains("two=22"));
        Assertions.assertTrue((boolean)queryString.contains("three=3"));
        this.assertNumberOfOccurences(queryString, 4, "&");
    }

    private void assertNumberOfOccurences(String stringToCheck, int expectedNumber, String element) {
        Assertions.assertEquals((int)1, (int)element.length());
        int actualNumbetOfOccurences = stringToCheck.length() - stringToCheck.replace(element, "").length();
        Assertions.assertEquals((int)expectedNumber, (int)actualNumbetOfOccurences);
    }

    @Test
    public void underlyingMapUnmodifiable_full() {
        Map parameters = QueryParameters.full(this.getFullInputParameters()).getParameters();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> parameters.put("one", Collections.emptyList()));
    }

    @Test
    public void underlyingListsUnmodifiable_full() {
        this.checkListsForImmutability(QueryParameters.full(this.getFullInputParameters()).getParameters().values());
    }

    @Test
    public void parameterWithoutValue() {
        QueryParameters params = new QueryParameters(Collections.singletonMap("foo", Collections.singletonList("")));
        Assertions.assertEquals((Object)"foo", (Object)params.getQueryString());
        params = new QueryParameters(Collections.singletonMap("foo", Arrays.asList("", "bar")));
        Assertions.assertEquals((Object)"foo&foo=bar", (Object)params.getQueryString());
        params = new QueryParameters(Collections.singletonMap("foo", Arrays.asList("bar", "")));
        Assertions.assertEquals((Object)"foo=bar&foo", (Object)params.getQueryString());
    }

    @Test
    public void parameterWithEmptyValue() {
        QueryParameters fullParams = new QueryParameters(Collections.singletonMap("foo", Collections.singletonList("")));
        Assertions.assertEquals((Object)"foo", (Object)fullParams.getQueryString());
    }

    @Test
    public void shortHands() {
        QueryParameters qp1 = QueryParameters.of((String)"foo", (String)"bar");
        Optional singleParameter = qp1.getSingleParameter("foo");
        Assertions.assertEquals((Object)"bar", singleParameter.get());
        Assertions.assertTrue((boolean)qp1.getSingleParameter("bar").isEmpty());
        List parameters = qp1.getParameters("foo");
        Assertions.assertEquals((Object)"bar", parameters.get(0));
        Assertions.assertEquals((int)1, (int)parameters.size());
        Assertions.assertTrue((boolean)qp1.getParameters("bar").isEmpty());
    }

    @Test
    public void excluding() {
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("one", Collections.singletonList("1"));
        paramMap.put("two", Collections.singletonList("2"));
        paramMap.put("three", Collections.singletonList("3"));
        QueryParameters params = new QueryParameters(paramMap);
        QueryParameters newParams = params.excluding(new String[]{"two"});
        Assertions.assertEquals((int)2, (int)newParams.getParameters().size());
        Assertions.assertEquals(Collections.singletonList("1"), (Object)newParams.getParameters("one"));
        Assertions.assertEquals(Collections.emptyList(), (Object)newParams.getParameters("two"));
        Assertions.assertEquals(Collections.singletonList("3"), (Object)newParams.getParameters("three"));
    }

    @Test
    public void excludingNone() {
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("one", Collections.singletonList("1"));
        paramMap.put("two", Collections.singletonList("2"));
        paramMap.put("three", Collections.singletonList("3"));
        QueryParameters params = new QueryParameters(paramMap);
        QueryParameters newParams = params.excluding(new String[0]);
        Assertions.assertEquals((Object)params, (Object)newParams);
    }

    @Test
    public void including() {
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("one", Collections.singletonList("1"));
        paramMap.put("two", Collections.singletonList("2"));
        paramMap.put("three", Collections.singletonList("3"));
        QueryParameters params = new QueryParameters(paramMap);
        QueryParameters newParams = params.including(new String[]{"three", "two"});
        Assertions.assertEquals((int)2, (int)newParams.getParameters().size());
        Assertions.assertEquals(Collections.singletonList("3"), (Object)newParams.getParameters("three"));
        Assertions.assertEquals(Collections.singletonList("2"), (Object)newParams.getParameters("two"));
    }

    @Test
    public void includingNone() {
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("one", Collections.singletonList("1"));
        paramMap.put("two", Collections.singletonList("2"));
        paramMap.put("three", Collections.singletonList("3"));
        QueryParameters params = new QueryParameters(paramMap);
        QueryParameters newParams = params.including(new String[0]);
        Assertions.assertEquals((int)0, (int)newParams.getParameters().size());
    }

    @Test
    public void includingNonExisting() {
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("one", Collections.singletonList("1"));
        paramMap.put("two", Collections.singletonList("2"));
        paramMap.put("three", Collections.singletonList("3"));
        QueryParameters params = new QueryParameters(paramMap);
        QueryParameters newParams = params.including(new String[]{"four"});
        Assertions.assertEquals((int)0, (int)newParams.getParameters().size());
    }

    @Test
    public void merging() {
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("one", Collections.singletonList("1"));
        paramMap.put("two", Collections.singletonList("2"));
        QueryParameters params = new QueryParameters(paramMap);
        QueryParameters newParams = params.merging("three", new String[]{"3"}).merging("one", new String[]{"one"});
        Assertions.assertEquals((int)3, (int)newParams.getParameters().size());
        Assertions.assertEquals(Collections.singletonList("one"), (Object)newParams.getParameters("one"));
        Assertions.assertEquals(Collections.singletonList("2"), (Object)newParams.getParameters("two"));
        Assertions.assertEquals(Collections.singletonList("3"), (Object)newParams.getParameters("three"));
    }

    @Test
    public void mergingMultiValue() {
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("one", Collections.singletonList("1"));
        paramMap.put("two", Collections.singletonList("2"));
        QueryParameters params = new QueryParameters(paramMap);
        QueryParameters newParams = params.merging("three", new String[]{"3", "3"});
        Assertions.assertEquals((int)3, (int)newParams.getParameters().size());
        Assertions.assertEquals(Collections.singletonList("1"), (Object)newParams.getParameters("one"));
        Assertions.assertEquals(Collections.singletonList("2"), (Object)newParams.getParameters("two"));
        Assertions.assertEquals(Arrays.asList("3", "3"), (Object)newParams.getParameters("three"));
    }

    @Test
    public void mergingAll() {
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("one", Collections.singletonList("1"));
        paramMap.put("two", Collections.singletonList("2"));
        QueryParameters params = new QueryParameters(paramMap);
        QueryParameters newParams = params.mergingAll(Map.of("three", Collections.singletonList("3"))).mergingAll(Map.of("one", Collections.singletonList("one")));
        Assertions.assertEquals((int)3, (int)newParams.getParameters().size());
        Assertions.assertEquals(Collections.singletonList("one"), (Object)newParams.getParameters("one"));
        Assertions.assertEquals(Collections.singletonList("3"), (Object)newParams.getParameters("three"));
        Assertions.assertEquals(Collections.singletonList("2"), (Object)newParams.getParameters("two"));
    }

    @Test
    public void toStringValidation() {
        String toString = QueryParameters.of((String)"foo", (String)"bar").toString();
        Assertions.assertEquals((Object)"QueryParameters(foo=bar)", (Object)toString);
    }

    @Test
    public void equalsAndHashCode() {
        QueryParameters qp1 = QueryParameters.of((String)"foo", (String)"bar");
        QueryParameters qp2 = QueryParameters.fromString((String)"foo=bar");
        QueryParameters qp3 = QueryParameters.fromString((String)"bar=foo");
        Assertions.assertEquals((Object)qp1, (Object)qp2);
        Assertions.assertNotEquals((Object)qp3, (Object)qp2);
        Assertions.assertEquals((int)qp1.hashCode(), (int)qp2.hashCode());
    }

    @Test
    public void fromString_emptyString_getsEmptyParameters() {
        QueryParameters params = QueryParameters.fromString((String)"");
        Assertions.assertEquals(Collections.emptyMap(), (Object)params.getParameters());
    }

    @Test
    public void fromString_blankString_getsEmptyParameters() {
        QueryParameters params = QueryParameters.fromString((String)"    ");
        Assertions.assertEquals(Collections.emptyMap(), (Object)params.getParameters());
    }

    @Test
    public void fromString_nullString_getsEmptyParameters() {
        QueryParameters params = QueryParameters.fromString(null);
        Assertions.assertEquals(Collections.emptyMap(), (Object)params.getParameters());
    }
}

