/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.UrlUtil;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletService;
import jakarta.servlet.http.HttpServletRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class UrlUtilTest {
    private String encodeURIShouldNotBeEscaped = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789;,/?:@&=+$-_.!~*'()#";
    private String encodeURIComponentShouldNotBeEscaped = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'()";

    UrlUtilTest() {
    }

    @Test
    public void isExternal_URLStartsWithTwoSlashes_returnsTrue() {
        Assertions.assertTrue((boolean)UrlUtil.isExternal((String)"//foo"));
    }

    @Test
    public void isExternal_URLContainsAnySchemaAsPrefix_returnsTrue() {
        Assertions.assertTrue((boolean)UrlUtil.isExternal((String)"http://foo"));
        Assertions.assertTrue((boolean)UrlUtil.isExternal((String)"https://foo"));
        Assertions.assertTrue((boolean)UrlUtil.isExternal((String)"context://foo"));
        Assertions.assertTrue((boolean)UrlUtil.isExternal((String)"base://foo"));
    }

    @Test
    public void isExternal_URLDoesnotContainSchema_returnsFalse() {
        Assertions.assertFalse((boolean)UrlUtil.isExternal((String)"foo"));
    }

    @Test
    public void plusAndSpaceHandledCorrectly() {
        Assertions.assertEquals((Object)"Plus+Spa%20+%20ce", (Object)UrlUtil.encodeURI((String)"Plus+Spa + ce"));
        Assertions.assertEquals((Object)"Plus%2BSpa%20%2B%20ce", (Object)UrlUtil.encodeURIComponent((String)"Plus+Spa + ce"));
    }

    @Test
    public void encodeURI_shouldNotBeEscaped() {
        Assertions.assertEquals((Object)this.encodeURIShouldNotBeEscaped, (Object)UrlUtil.encodeURI((String)this.encodeURIShouldNotBeEscaped));
    }

    @Test
    public void encodeURI_mustBeEscaped() {
        for (char c = '\u0000'; c < '\u00ff'; c = (char)(c + '\u0001')) {
            String s = String.valueOf(c);
            if (this.encodeURIShouldNotBeEscaped.contains(s)) continue;
            Assertions.assertNotEquals((Object)UrlUtil.encodeURI((String)s), (Object)s);
        }
    }

    @Test
    public void encodeURIComponent_shouldNotBeEscaped() {
        Assertions.assertEquals((Object)this.encodeURIComponentShouldNotBeEscaped, (Object)UrlUtil.encodeURIComponent((String)this.encodeURIComponentShouldNotBeEscaped));
    }

    @Test
    public void encodeURIComponent_mustBeEscaped() {
        for (char c = '\u0000'; c < '\u00ff'; c = (char)(c + '\u0001')) {
            String s = String.valueOf(c);
            if (this.encodeURIComponentShouldNotBeEscaped.contains(s)) continue;
            Assertions.assertNotEquals((Object)UrlUtil.encodeURIComponent((String)s), (Object)s);
        }
    }

    @Test
    public void getServletPathRelative() {
        Assertions.assertEquals((Object)".", (Object)UrlUtil.getServletPathRelative((String)"/foo/bar/", (HttpServletRequest)this.createRequest("/foo", "/bar")));
        Assertions.assertEquals((Object)".", (Object)UrlUtil.getServletPathRelative((String)"/foo/bar", (HttpServletRequest)this.createRequest("/foo", "/bar")));
        Assertions.assertEquals((Object)"..", (Object)UrlUtil.getServletPathRelative((String)"/foo/", (HttpServletRequest)this.createRequest("/foo", "/bar")));
        Assertions.assertEquals((Object)"../..", (Object)UrlUtil.getServletPathRelative((String)"/", (HttpServletRequest)this.createRequest("/foo", "/bar")));
        Assertions.assertEquals((Object)"..", (Object)UrlUtil.getServletPathRelative((String)"/foo", (HttpServletRequest)this.createRequest("/foo", "/bar")));
        Assertions.assertEquals((Object)"../../login", (Object)UrlUtil.getServletPathRelative((String)"/login", (HttpServletRequest)this.createRequest("/foo", "/bar")));
        Assertions.assertEquals((Object)"../login", (Object)UrlUtil.getServletPathRelative((String)"/foo/login", (HttpServletRequest)this.createRequest("/foo", "/bar")));
        Assertions.assertEquals((Object)"login", (Object)UrlUtil.getServletPathRelative((String)"/foo/bar/login", (HttpServletRequest)this.createRequest("/foo", "/bar")));
        Assertions.assertEquals((Object)"baz/login", (Object)UrlUtil.getServletPathRelative((String)"/foo/bar/baz/login", (HttpServletRequest)this.createRequest("/foo", "/bar")));
    }

    private VaadinServletRequest createRequest(String contextPath, String servletPath) {
        if (!servletPath.equals("") && !servletPath.startsWith("/")) {
            throw new IllegalArgumentException("A servlet path always starts with / except for the empty mapping \"\"");
        }
        if (!(contextPath.equals("") || contextPath.startsWith("/") && !contextPath.endsWith("/"))) {
            throw new IllegalArgumentException("A context path is either empty or starts, but not ends with, a slash");
        }
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getServletPath()).thenReturn((Object)servletPath);
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)contextPath);
        return new VaadinServletRequest(request, (VaadinServletService)Mockito.mock(VaadinServletService.class));
    }

    @Test
    public void decodeURIComponent_percentEncodedSpace_decoded() {
        String result = UrlUtil.decodeURIComponent((String)"test%20file.txt");
        Assertions.assertEquals((Object)"test file.txt", (Object)result);
    }

    @Test
    public void decodeURIComponent_plusSign_notDecodedAsSpace() {
        String result = UrlUtil.decodeURIComponent((String)"test+file.txt");
        Assertions.assertEquals((Object)"test+file.txt", (Object)result);
    }

    @Test
    public void decodeURIComponent_encodedPlusSign_decoded() {
        String result = UrlUtil.decodeURIComponent((String)"test%2Bfile.txt");
        Assertions.assertEquals((Object)"test+file.txt", (Object)result);
    }

    @Test
    public void decodeURIComponent_unicodeCharacters_decoded() {
        String result = UrlUtil.decodeURIComponent((String)"%C3%A5%C3%A4%C3%B6.txt");
        Assertions.assertEquals((Object)"\u00e5\u00e4\u00f6.txt", (Object)result);
    }

    @Test
    public void decodeURIComponent_specialCharacters_decoded() {
        String result = UrlUtil.decodeURIComponent((String)"special%26%3Dchars.txt");
        Assertions.assertEquals((Object)"special&=chars.txt", (Object)result);
    }

    @Test
    public void decodeURIComponent_nullValue_returnsNull() {
        String result = UrlUtil.decodeURIComponent(null);
        Assertions.assertNull((Object)result);
    }

    @Test
    public void decodeURIComponent_emptyValue_returnsEmpty() {
        String result = UrlUtil.decodeURIComponent((String)"");
        Assertions.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void decodeURIComponent_noEncodedChars_returnsSame() {
        String result = UrlUtil.decodeURIComponent((String)"simple.txt");
        Assertions.assertEquals((Object)"simple.txt", (Object)result);
    }
}

