/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.BeanUtil;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BeanUtilTest {
    BeanUtilTest() {
    }

    @Test
    public void getBeanPropertyDescriptors_regularClass() throws IntrospectionException {
        List descriptors = BeanUtil.getBeanPropertyDescriptors(TestBean.class);
        Assertions.assertNotNull((Object)descriptors);
        Assertions.assertEquals((int)4, (int)descriptors.size());
        boolean foundName = false;
        boolean foundAge = false;
        boolean foundNested = false;
        for (PropertyDescriptor descriptor : descriptors) {
            Assertions.assertNotNull((Object)descriptor.getReadMethod());
            if (!"class".equals(descriptor.getName())) {
                Assertions.assertNotNull((Object)descriptor.getWriteMethod());
            }
            if ("name".equals(descriptor.getName())) {
                foundName = true;
                Assertions.assertEquals(String.class, descriptor.getPropertyType());
                continue;
            }
            if ("age".equals(descriptor.getName())) {
                foundAge = true;
                Assertions.assertEquals(Integer.TYPE, descriptor.getPropertyType());
                continue;
            }
            if (!"nested".equals(descriptor.getName())) continue;
            foundNested = true;
            Assertions.assertEquals(TestNestedBean.class, descriptor.getPropertyType());
        }
        Assertions.assertTrue((boolean)foundName, (String)"Should find 'name' property");
        Assertions.assertTrue((boolean)foundAge, (String)"Should find 'age' property");
        Assertions.assertTrue((boolean)foundNested, (String)"Should find 'nested' property");
    }

    @Test
    public void getBeanPropertyDescriptors_record() throws IntrospectionException {
        List descriptors = BeanUtil.getBeanPropertyDescriptors(TestRecord.class);
        Assertions.assertNotNull((Object)descriptors);
        Assertions.assertEquals((int)2, (int)descriptors.size());
        boolean foundRecordProperty = false;
        boolean foundRecordAge = false;
        for (PropertyDescriptor descriptor : descriptors) {
            Assertions.assertNotNull((Object)descriptor.getReadMethod());
            Assertions.assertNull((Object)descriptor.getWriteMethod());
            if ("recordProperty".equals(descriptor.getName())) {
                foundRecordProperty = true;
                Assertions.assertEquals(String.class, descriptor.getPropertyType());
                continue;
            }
            if (!"recordAge".equals(descriptor.getName())) continue;
            foundRecordAge = true;
            Assertions.assertEquals(Integer.TYPE, descriptor.getPropertyType());
        }
        Assertions.assertTrue((boolean)foundRecordProperty, (String)"Should find 'recordProperty' property");
        Assertions.assertTrue((boolean)foundRecordAge, (String)"Should find 'recordAge' property");
    }

    @Test
    public void getBeanPropertyDescriptors_interface() throws IntrospectionException {
        List descriptors = BeanUtil.getBeanPropertyDescriptors(TestInterface.class);
        Assertions.assertNotNull((Object)descriptors);
        Assertions.assertEquals((int)1, (int)descriptors.size());
        Assertions.assertEquals((Object)"interfaceProperty", (Object)((PropertyDescriptor)descriptors.get(0)).getName());
        Assertions.assertEquals(String.class, ((PropertyDescriptor)descriptors.get(0)).getPropertyType());
        Assertions.assertNotNull((Object)((PropertyDescriptor)descriptors.get(0)).getReadMethod());
        Assertions.assertNotNull((Object)((PropertyDescriptor)descriptors.get(0)).getWriteMethod());
    }

    @Test
    public void getPropertyType_simpleProperty() throws IntrospectionException {
        Class nameType = BeanUtil.getPropertyType(TestBean.class, (String)"name");
        Assertions.assertEquals(String.class, (Object)nameType);
        Class ageType = BeanUtil.getPropertyType(TestBean.class, (String)"age");
        Assertions.assertEquals(Integer.TYPE, (Object)ageType);
    }

    @Test
    public void getPropertyType_nestedProperty() throws IntrospectionException {
        Class nestedValueType = BeanUtil.getPropertyType(TestBean.class, (String)"nested.value");
        Assertions.assertEquals(String.class, (Object)nestedValueType);
    }

    @Test
    public void getPropertyType_nonExistentProperty() throws IntrospectionException {
        Class nonExistentType = BeanUtil.getPropertyType(TestBean.class, (String)"nonExistent");
        Assertions.assertNull((Object)nonExistentType);
    }

    @Test
    public void getPropertyDescriptor_simpleProperty() throws IntrospectionException {
        PropertyDescriptor nameDescriptor = BeanUtil.getPropertyDescriptor(TestBean.class, (String)"name");
        Assertions.assertNotNull((Object)nameDescriptor);
        Assertions.assertEquals((Object)"name", (Object)nameDescriptor.getName());
        Assertions.assertEquals(String.class, nameDescriptor.getPropertyType());
        Assertions.assertNotNull((Object)nameDescriptor.getReadMethod());
        Assertions.assertNotNull((Object)nameDescriptor.getWriteMethod());
    }

    @Test
    public void getPropertyDescriptor_nestedProperty() throws IntrospectionException {
        PropertyDescriptor nestedValueDescriptor = BeanUtil.getPropertyDescriptor(TestBean.class, (String)"nested.value");
        Assertions.assertNotNull((Object)nestedValueDescriptor);
        Assertions.assertEquals((Object)"value", (Object)nestedValueDescriptor.getName());
        Assertions.assertEquals(String.class, nestedValueDescriptor.getPropertyType());
        Assertions.assertNotNull((Object)nestedValueDescriptor.getReadMethod());
        Assertions.assertNotNull((Object)nestedValueDescriptor.getWriteMethod());
    }

    @Test
    public void getPropertyDescriptor_nonExistentProperty() throws IntrospectionException {
        PropertyDescriptor nonExistentDescriptor = BeanUtil.getPropertyDescriptor(TestBean.class, (String)"nonExistent");
        Assertions.assertNull((Object)nonExistentDescriptor);
    }

    @Test
    public void getBeanPropertyDescriptors_nullInput() throws IntrospectionException {
        List result = BeanUtil.getBeanPropertyDescriptors(null);
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void getPropertyType_emptyPropertyName() throws IntrospectionException {
        Class result = BeanUtil.getPropertyType(TestBean.class, (String)"");
        Assertions.assertNull((Object)result);
    }

    @Test
    public void getPropertyDescriptor_emptyPropertyName() throws IntrospectionException {
        PropertyDescriptor result = BeanUtil.getPropertyDescriptor(TestBean.class, (String)"");
        Assertions.assertNull((Object)result);
    }

    @Test
    public void getPropertyType_deepNestedProperty() throws IntrospectionException {
        Class result = BeanUtil.getPropertyType(TestBean.class, (String)"nested.nonExistent.value");
        Assertions.assertNull((Object)result);
    }

    @Test
    public void getPropertyType_recordProperty() throws IntrospectionException {
        Class recordPropertyType = BeanUtil.getPropertyType(TestRecord.class, (String)"recordProperty");
        Assertions.assertEquals(String.class, (Object)recordPropertyType);
        Class recordAgeType = BeanUtil.getPropertyType(TestRecord.class, (String)"recordAge");
        Assertions.assertEquals(Integer.TYPE, (Object)recordAgeType);
    }

    @Test
    public void getPropertyType_interfaceProperty() throws IntrospectionException {
        Class interfacePropertyType = BeanUtil.getPropertyType(TestInterface.class, (String)"interfaceProperty");
        Assertions.assertEquals(String.class, (Object)interfacePropertyType);
    }

    @Test
    public void getPropertyDescriptor_objectMethodsFiltered() throws IntrospectionException {
        PropertyDescriptor classProperty = BeanUtil.getPropertyDescriptor(TestBean.class, (String)"class");
        Assertions.assertNull((Object)classProperty, (String)"Object.getClass() should be filtered out");
    }

    @Test
    public void getBeanPropertyDescriptors_includesAllValidProperties() throws IntrospectionException {
        List descriptors = BeanUtil.getBeanPropertyDescriptors(TestBean.class);
        List<String> names = descriptors.stream().map(FeatureDescriptor::getName).toList();
        Assertions.assertTrue((boolean)names.contains("name"), (String)"should include property 'name'");
        Assertions.assertTrue((boolean)names.contains("age"), (String)"should include property 'age'");
        Assertions.assertTrue((boolean)names.contains("nested"), (String)"should include property 'nested'");
        Assertions.assertTrue((boolean)names.contains("class"), (String)"should include property 'class'");
    }

    @Test
    public void duplicatesAreRemoved() throws Exception {
        List descriptors = BeanUtil.getBeanPropertyDescriptors(TestSomething.class);
        List<PropertyDescriptor> existsInAllPlacesProperties = descriptors.stream().filter(desc -> desc.getName().equals("existsInAllPlaces")).toList();
        Assertions.assertEquals((int)1, (int)existsInAllPlacesProperties.size(), (String)"There should be only one 'existsInAllPlaces' property descriptor");
        List<PropertyDescriptor> oneInterfaceProperties = descriptors.stream().filter(desc -> desc.getName().equals("oneInterface")).toList();
        Assertions.assertEquals((int)1, (int)oneInterfaceProperties.size(), (String)"There should be only one 'oneInterface' property descriptor");
        PropertyDescriptor oneInterfaceProperty = oneInterfaceProperties.get(0);
        Assertions.assertEquals(FirstInterface.class, oneInterfaceProperty.getReadMethod().getDeclaringClass());
    }

    public static class TestBean {
        private String name;
        private int age;
        private TestNestedBean nested;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public TestNestedBean getNested() {
            return this.nested;
        }

        public void setNested(TestNestedBean nested) {
            this.nested = nested;
        }
    }

    public static class TestNestedBean {
        private String value;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public record TestRecord(String recordProperty, int recordAge) {
    }

    public static interface TestInterface {
        public String getInterfaceProperty();

        public void setInterfaceProperty(String var1);
    }

    public class TestSomething
    implements FirstInterface,
    SecondInterface {
        public TestSomething(BeanUtilTest this$0) {
        }

        @Override
        public void setExistsInAllPlaces(boolean visible) {
        }

        @Override
        public boolean isExistsInAllPlaces() {
            return true;
        }
    }

    public static interface FirstInterface {
        default public void setOneInterface(boolean bothInterfaces) {
        }

        default public boolean isOneInterface() {
            return true;
        }

        default public void setExistsInAllPlaces(boolean visible) {
        }

        default public boolean isExistsInAllPlaces() {
            return true;
        }
    }

    public static interface SecondInterface {
        default public void setExistsInAllPlaces(boolean visible) {
        }

        default public boolean isExistsInAllPlaces() {
            return true;
        }
    }
}

