/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.dom.ElementUtil;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.InertData;
import java.util.Optional;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ElementUtilTest {
    private Element parent;
    private Element child;
    private Element grandchild;
    private StateTree stateTree;

    ElementUtilTest() {
    }

    @Test
    public void isNullValidAttribute() {
        Assertions.assertFalse((boolean)ElementUtil.isValidAttributeName(null));
    }

    @Test
    public void isEmptyValidAttribute() {
        Assertions.assertFalse((boolean)ElementUtil.isValidAttributeName((String)""));
    }

    @Test
    public void isUpperCaseValidAttribute() {
        Assertions.assertThrows(AssertionError.class, () -> ElementUtil.isValidAttributeName((String)"FOO"));
    }

    @Test
    public void componentNotInitiallyAttached() {
        Element e = ElementFactory.createDiv();
        Assertions.assertFalse((boolean)e.getComponent().isPresent());
    }

    @Test
    public void attachToComponent() {
        Element e = ElementFactory.createDiv();
        Component c = (Component)Mockito.mock(Component.class);
        ElementUtil.setComponent((Element)e, (Component)c);
        Assertions.assertEquals((Object)c, e.getComponent().get());
    }

    @Test
    public void attachComponentToTextElement() {
        Element e = Element.createText((String)"Text text");
        Component c = (Component)Mockito.mock(Component.class);
        ElementUtil.setComponent((Element)e, (Component)c);
        Assertions.assertEquals((Object)c, e.getComponent().get());
    }

    @Test
    public void attachTwiceToComponent() {
        Element e = ElementFactory.createDiv();
        Component c = (Component)Mockito.mock(Component.class);
        ElementUtil.setComponent((Element)e, (Component)c);
        Assertions.assertThrows(IllegalStateException.class, () -> ElementUtil.setComponent((Element)e, (Component)c));
    }

    @Test
    public void attachToNull() {
        Element e = ElementFactory.createDiv();
        Assertions.assertThrows(IllegalArgumentException.class, () -> ElementUtil.setComponent((Element)e, null));
    }

    @Test
    public void attachTwoComponents() {
        Element e = ElementFactory.createDiv();
        Component c = (Component)Mockito.mock(Component.class);
        Component c2 = (Component)Mockito.mock(Component.class);
        ElementUtil.setComponent((Element)e, (Component)c);
        Assertions.assertThrows(IllegalStateException.class, () -> ElementUtil.setComponent((Element)e, (Component)c2));
    }

    @Test
    public void toAndFromJsoup() {
        String EXPECTED_TEXT_1 = "Some text";
        String EXPECTED_TEXT_2 = "Other text";
        Element originalElement = ElementFactory.createDiv();
        originalElement.appendChild(new Element[]{(Element)ElementFactory.createParagraph((String)"Some text").appendChild(new Element[]{ElementFactory.createDiv((String)"Other text")})});
        Document jDocument = Document.createShell((String)"http://example.com");
        Node jNode = ElementUtil.toJsoup((Document)jDocument, (Element)originalElement);
        Optional optionalElement = ElementUtil.fromJsoup((Node)jNode);
        Assertions.assertTrue((boolean)optionalElement.isPresent(), (String)"Element should have been created from jNode");
        Element recreatedElement = (Element)optionalElement.get();
        Assertions.assertEquals((Object)"div", (Object)recreatedElement.getTag(), (String)"Root element should be div");
        Assertions.assertEquals((Object)"p", (Object)recreatedElement.getChild(0).getTag(), (String)"Child element should be a paragraph");
        Assertions.assertEquals((Object)"Some text", (Object)recreatedElement.getChild(0).getText(), (String)"Child element should have text");
        Assertions.assertEquals((Object)"div", (Object)recreatedElement.getChild(0).getChild(1).getTag(), (String)"Grand-child element should be a div");
        Assertions.assertEquals((Object)"Other text", (Object)recreatedElement.getChild(0).getChild(1).getText(), (String)"Grand-child element should have text");
    }

    @Test
    public void isValidTagName_validTagNames() {
        Assertions.assertTrue((boolean)ElementUtil.isValidTagName((String)"foo"));
        Assertions.assertTrue((boolean)ElementUtil.isValidTagName((String)"foo-bar"));
        Assertions.assertTrue((boolean)ElementUtil.isValidTagName((String)"foo_bar"));
        Assertions.assertTrue((boolean)ElementUtil.isValidTagName((String)"foo_bar-baz"));
        Assertions.assertTrue((boolean)ElementUtil.isValidTagName((String)"foo12.bar3"));
        Assertions.assertTrue((boolean)ElementUtil.isValidTagName((String)"foo-._"));
        Assertions.assertTrue((boolean)ElementUtil.isValidTagName((String)"x"));
    }

    @Test
    public void isValidTagName_invalidTagNames() {
        Assertions.assertFalse((boolean)ElementUtil.isValidTagName((String)"1foo"));
        Assertions.assertFalse((boolean)ElementUtil.isValidTagName((String)"-foo"));
        Assertions.assertFalse((boolean)ElementUtil.isValidTagName((String)"_foo"));
        Assertions.assertFalse((boolean)ElementUtil.isValidTagName((String)".foo"));
        Assertions.assertFalse((boolean)ElementUtil.isValidTagName((String)"foo>"));
        Assertions.assertFalse((boolean)ElementUtil.isValidTagName((String)"foo$bar"));
    }

    @Test
    public void parentIsInert_childIgnoresParentInert_allThePermutations() {
        this.setupElementHierarchy();
        Assertions.assertFalse((boolean)this.isIgnoreParentInert(this.child), (String)"by default parent inert state is not ignored");
        Assertions.assertFalse((boolean)this.isInert(this.child), (String)"by default element should not be inert");
        ElementUtil.setIgnoreParentInert((Element)this.child, (boolean)true);
        Assertions.assertFalse((boolean)this.isInert(this.child));
        ElementUtil.setInert((Element)this.parent, (boolean)true);
        this.simulateWritingChangesToClient();
        Assertions.assertTrue((boolean)this.isInert(this.parent));
        Assertions.assertFalse((boolean)this.isInert(this.child));
        Assertions.assertFalse((boolean)this.isInert(this.grandchild));
        ElementUtil.setIgnoreParentInert((Element)this.child, (boolean)false);
        this.simulateWritingChangesToClient();
        Assertions.assertTrue((boolean)this.isInert(this.parent));
        Assertions.assertTrue((boolean)this.isInert(this.child));
        Assertions.assertTrue((boolean)this.isInert(this.grandchild));
        ElementUtil.setIgnoreParentInert((Element)this.child, (boolean)true);
        this.simulateWritingChangesToClient();
        Assertions.assertTrue((boolean)this.isInert(this.parent));
        Assertions.assertFalse((boolean)this.isInert(this.child));
        Assertions.assertFalse((boolean)this.isInert(this.grandchild));
        ElementUtil.setInert((Element)this.child, (boolean)true);
        this.simulateWritingChangesToClient();
        Assertions.assertTrue((boolean)this.isInert(this.parent));
        Assertions.assertTrue((boolean)this.isInert(this.child));
        Assertions.assertTrue((boolean)this.isInert(this.grandchild));
        ElementUtil.setInert((Element)this.parent, (boolean)false);
        this.simulateWritingChangesToClient();
        Assertions.assertFalse((boolean)this.isInert(this.parent));
        Assertions.assertTrue((boolean)this.isInert(this.child));
        Assertions.assertTrue((boolean)this.isInert(this.grandchild));
    }

    @Test
    public void parentInert_grandChildIgnoresInert_notInert() {
        this.setupElementHierarchy();
        ElementUtil.setInert((Element)this.parent, (boolean)true);
        this.simulateWritingChangesToClient();
        Assertions.assertTrue((boolean)this.isInert(this.parent));
        Assertions.assertTrue((boolean)this.isInert(this.child));
        Assertions.assertTrue((boolean)this.isInert(this.grandchild));
        ElementUtil.setIgnoreParentInert((Element)this.grandchild, (boolean)true);
        this.simulateWritingChangesToClient();
        Assertions.assertTrue((boolean)this.isInert(this.parent));
        Assertions.assertTrue((boolean)this.isInert(this.child));
        Assertions.assertFalse((boolean)this.isInert(this.grandchild));
        ElementUtil.setIgnoreParentInert((Element)this.grandchild, (boolean)false);
        this.simulateWritingChangesToClient();
        Assertions.assertTrue((boolean)this.isInert(this.parent));
        Assertions.assertTrue((boolean)this.isInert(this.child));
        Assertions.assertTrue((boolean)this.isInert(this.grandchild));
    }

    @Test
    public void parentInertGrandChildIgnores_statesChangedAtSameTime_changesApplied() {
        this.setupElementHierarchy();
        ElementUtil.setInert((Element)this.parent, (boolean)true);
        ElementUtil.setIgnoreParentInert((Element)this.grandchild, (boolean)true);
        this.simulateWritingChangesToClient();
        Assertions.assertTrue((boolean)this.isInert(this.parent));
        Assertions.assertTrue((boolean)this.isInert(this.child));
        Assertions.assertFalse((boolean)this.isInert(this.grandchild));
    }

    @Test
    public void parentInert_siblingIgnoresInheritingInert_siblingInert() {
        Element sibling = ElementFactory.createDiv();
    }

    @Test
    public void elementsUpdateSameData() {
        Element te = new Element("testelem");
        Element e = ElementUtil.from((StateNode)te.getNode()).orElse(null);
        Assertions.assertEquals((Object)te, (Object)e);
    }

    @Test
    public void getElementFromInvalidNode() {
        StateNode node = new StateNode(new Class[]{ElementPropertyMap.class});
        Assertions.assertFalse((boolean)ElementUtil.from((StateNode)node).isPresent());
    }

    private void setupElementHierarchy() {
        this.parent = ElementFactory.createDiv();
        this.child = ElementFactory.createDiv();
        this.grandchild = ElementFactory.createDiv();
        this.parent.appendChild(new Element[]{(Element)this.child.appendChild(new Element[]{this.grandchild})});
        this.stateTree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class, InertData.class});
        StateNode rootNode = this.stateTree.getRootNode();
        ((ElementChildrenList)rootNode.getFeature(ElementChildrenList.class)).add(0, this.parent.getNode());
    }

    private boolean isIgnoreParentInert(Element element) {
        return element.getNode().getFeatureIfInitialized(InertData.class).map(InertData::isIgnoreParentInert).orElse(false);
    }

    private boolean isInert(Element element) {
        return element.getNode().isInert();
    }

    private void simulateWritingChangesToClient() {
        this.stateTree.collectChanges(nodeChanges -> {});
    }
}

