/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.dom.AbstractNodeTest;
import com.vaadin.flow.dom.BasicElementStateProviderTest;
import com.vaadin.flow.dom.ClassList;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementAttachListener;
import com.vaadin.flow.dom.ElementDetachListener;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.dom.Node;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.dom.ShadowRoot;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.dom.impl.BasicElementStateProvider;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.NullOwner;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ComponentMapping;
import com.vaadin.flow.internal.nodefeature.ElementAttributeMap;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.flow.internal.nodefeature.ElementListenersTest;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.ElementStylePropertyMap;
import com.vaadin.flow.internal.nodefeature.VirtualChildrenList;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import com.vaadin.tests.util.MockUI;
import com.vaadin.tests.util.TestUtil;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Date;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import net.jcip.annotations.NotThreadSafe;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.ObjectNode;

@NotThreadSafe
class ElementJacksonTest
extends AbstractNodeTest {
    ElementJacksonTest() {
    }

    @Test
    public void createElementWithTag() {
        Element e = ElementFactory.createDiv();
        Assertions.assertEquals((Object)"div", (Object)e.getTag());
        Assertions.assertFalse((boolean)e.hasAttribute("is"));
        Assertions.assertFalse((boolean)e.isTextNode());
    }

    @Test
    public void createElementWithInvalidTag() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Element("<div>"));
    }

    @Test
    public void createElementWithEmptyTag() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Element(""));
    }

    @Test
    public void createElementWithNullTag() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Element(null));
    }

    @Test
    public void elementsUpdateSameData() {
        Element te = new Element("testelem");
        Element e = Element.get((StateNode)te.getNode());
        Assertions.assertEquals((Object)te, (Object)e);
        te.setAttribute("foo", "bar");
        Assertions.assertEquals((Object)"bar", (Object)e.getAttribute("foo"));
        e.setAttribute("baz", "123");
        Assertions.assertEquals((Object)"123", (Object)te.getAttribute("baz"));
    }

    @Test
    public void getElementFromInvalidNode() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            StateNode node = new StateNode(new Class[]{ElementPropertyMap.class});
            Element.get((StateNode)node);
        });
    }

    @Test
    public void publicElementMethodsShouldReturnElement() {
        HashSet<String> ignore = new HashSet<String>();
        ignore.add("toString");
        ignore.add("hashCode");
        ignore.add("equals");
        ignore.add("addEventListener");
        ignore.add("addAttachListener");
        ignore.add("addDetachListener");
        ignore.add("addPropertyChangeListener");
        ignore.add("indexOfChild");
        ignore.add("as");
        ignore.add("callFunction");
        ignore.add("executeJavaScript");
        ignore.add("callJsFunction");
        ignore.add("executeJs");
        ignore.add("attachShadow");
        ignore.add("getShadowRoot");
        ignore.add("bindEnabled");
        ignore.add("bindProperty");
        ignore.add("bindAttribute");
        ignore.add("bindText");
        ignore.add("bindVisible");
        this.assertMethodsReturnType(Element.class, ignore);
    }

    @Test
    public void publicElementStyleMethodsShouldReturnElement() {
        HashSet<String> ignore = new HashSet<String>();
        ignore.add("toString");
        ignore.add("hashCode");
        ignore.add("equals");
        for (Method m : Style.class.getDeclaredMethods()) {
            if (!Modifier.isPublic(m.getModifiers()) || Modifier.isStatic(m.getModifiers()) || m.getName().startsWith("get") || m.getName().startsWith("has") || m.getName().startsWith("is") || ignore.contains(m.getName())) continue;
            Class<?> returnType = m.getReturnType();
            Assertions.assertEquals(Style.class, returnType, (String)("Method " + m.getName() + " has invalid return type"));
        }
    }

    @Test
    public void stringAttribute() {
        Element e = ElementFactory.createDiv();
        e.setAttribute("foo", "bar");
        Assertions.assertEquals((Object)"bar", (Object)e.getAttribute("foo"));
    }

    @Test
    public void setEmptyAttribute() {
        Element e = ElementFactory.createDiv();
        e.setAttribute("foo", "");
        Assertions.assertEquals((Object)"", (Object)e.getAttribute("foo"));
    }

    @Test
    public void setBooleanAttribute() {
        Element e = ElementFactory.createDiv();
        e.setAttribute("foo", true);
        Assertions.assertEquals((Object)"", (Object)e.getAttribute("foo"));
        Assertions.assertTrue((boolean)e.hasAttribute("foo"));
        e.setAttribute("foo", false);
        Assertions.assertEquals(null, (Object)e.getAttribute("foo"));
        Assertions.assertFalse((boolean)e.hasAttribute("foo"));
    }

    @Test
    public void setNullAttribute() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Element e = ElementFactory.createDiv();
            e.setAttribute("foo", (String)null);
        });
    }

    @Test
    public void getNullAttribute() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Element e = ElementFactory.createDiv();
            e.getAttribute(null);
        });
    }

    @Test
    public void hasNullAttribute() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Element e = ElementFactory.createDiv();
            e.hasAttribute(null);
        });
    }

    @Test
    public void removeNullAttribute() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Element e = ElementFactory.createDiv();
            e.removeAttribute(null);
        });
    }

    @Test
    public void setInvalidAttribute() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Element e = ElementFactory.createDiv();
            e.setAttribute("\"foo\"", "bar");
        });
    }

    @Test
    public void hasDefinedAttribute() {
        Element e = ElementFactory.createDiv();
        e.setAttribute("foo", "bar");
        Assertions.assertTrue((boolean)e.hasAttribute("foo"));
    }

    @Test
    public void doesNotHaveUndefinedAttribute() {
        Element e = ElementFactory.createDiv();
        Assertions.assertFalse((boolean)e.hasAttribute("foo"));
    }

    @Test
    public void doesNotHaveRemovedAttribute() {
        Element e = ElementFactory.createDiv();
        e.setAttribute("foo", "bar");
        e.removeAttribute("foo");
        Assertions.assertFalse((boolean)e.hasAttribute("foo"));
    }

    @Test
    public void removeNonExistingAttributeIsNoOp() {
        Element e = ElementFactory.createDiv();
        Assertions.assertFalse((boolean)e.hasAttribute("foo"));
        e.removeAttribute("foo");
        Assertions.assertFalse((boolean)e.hasAttribute("foo"));
    }

    @Test
    public void attributesWhenNoneDefined() {
        Element e = ElementFactory.createDiv();
        Assertions.assertEquals((long)0L, (long)e.getAttributeNames().count());
    }

    @Test
    public void attributesNames() {
        Element e = ElementFactory.createDiv();
        e.setAttribute("foo", "bar");
        Assertions.assertArrayEquals((Object[])new String[]{"foo"}, (Object[])e.getAttributeNames().toArray());
    }

    @Test
    public void attributesNamesAfterRemoved() {
        Element e = ElementFactory.createDiv();
        e.setAttribute("foo", "bar");
        e.setAttribute("bar", "baz");
        e.removeAttribute("foo");
        Assertions.assertArrayEquals((Object[])new String[]{"bar"}, (Object[])e.getAttributeNames().toArray());
    }

    @Test
    public void setGetAttributeValueCaseSensitive() {
        Element e = new Element("span");
        e.setAttribute("foo", "bAr");
        Assertions.assertEquals((Object)"bAr", (Object)e.getAttribute("foo"));
        e.setAttribute("foo", "BAR");
        Assertions.assertEquals((Object)"BAR", (Object)e.getAttribute("foo"));
    }

    @Test
    public void setGetAttributeNameCaseInsensitive() {
        Element e = new Element("span");
        e.setAttribute("foo", "bar");
        e.setAttribute("FOO", "baz");
        Assertions.assertEquals((Object)"baz", (Object)e.getAttribute("foo"));
        Assertions.assertEquals((Object)"baz", (Object)e.getAttribute("FOO"));
    }

    @Test
    public void hasAttributeNamesCaseInsensitive() {
        Element e = new Element("span");
        e.setAttribute("fooo", "bar");
        Assertions.assertTrue((boolean)e.hasAttribute("fOoO"));
    }

    @Test
    public void getAttributeNamesLowerCase() {
        Element e = new Element("span");
        e.setAttribute("FOO", "bar");
        e.setAttribute("Baz", "bar");
        Set attributeNames = e.getAttributeNames().collect(Collectors.toSet());
        Assertions.assertTrue((boolean)attributeNames.contains("foo"));
        Assertions.assertFalse((boolean)attributeNames.contains("FOO"));
        Assertions.assertTrue((boolean)attributeNames.contains("baz"));
        Assertions.assertFalse((boolean)attributeNames.contains("Baz"));
    }

    @Test
    public void removeDetachedFromParent() {
        Element otherElement = new Element("other");
        Assertions.assertNull((Object)otherElement.getParent());
        otherElement.removeFromParent();
        Assertions.assertNull((Object)otherElement.getParent());
    }

    @Test
    public void getDetachedParent() {
        Element otherElement = new Element("other");
        Assertions.assertNull((Object)otherElement.getParent());
        Assertions.assertNull((Object)otherElement.getParentNode());
    }

    @Test
    public void addNullEventListener() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Element e = ElementFactory.createDiv();
            e.addEventListener("foo", null);
        });
    }

    @Test
    public void addEventListenerForNullType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Element e = ElementFactory.createDiv();
            e.addEventListener(null, (DomEventListener & Serializable)ignore -> {});
        });
    }

    @Test
    public void equalsSelf() {
        Element e = ElementFactory.createDiv();
        Assertions.assertTrue((boolean)e.equals((Object)e));
    }

    @Test
    public void notEqualsNull() {
        Element e = ElementFactory.createDiv();
        Assertions.assertFalse((boolean)e.equals(null));
    }

    @Test
    public void notEqualsString() {
        Element e = ElementFactory.createDiv();
        Assertions.assertFalse((boolean)e.equals((Object)"div"));
    }

    @Test
    public void getPropertyDefaults() {
        Element element = ElementFactory.createDiv();
        element.setProperty("null", null);
        element.setProperty("empty", "");
        Assertions.assertEquals((Object)"d", (Object)element.getProperty("null", "d"));
        Assertions.assertEquals((Object)"d", (Object)element.getProperty("notThere", "d"));
        Assertions.assertNotEquals((Object)"d", (Object)element.getProperty("empty", "d"));
        Assertions.assertTrue((boolean)element.getProperty("null", true));
        Assertions.assertFalse((boolean)element.getProperty("null", false));
        Assertions.assertTrue((boolean)element.getProperty("notThere", true));
        Assertions.assertFalse((boolean)element.getProperty("notThere", false));
        Assertions.assertFalse((boolean)element.getProperty("empty", true));
        Assertions.assertFalse((boolean)element.getProperty("empty", false));
        Assertions.assertEquals((double)0.1, (double)element.getProperty("null", 0.1), (double)0.0);
        Assertions.assertEquals((double)0.1, (double)element.getProperty("notThere", 0.1), (double)0.0);
        Assertions.assertNotEquals((double)0.1, (double)element.getProperty("empty", 0.1), (double)0.0);
        Assertions.assertEquals((int)42, (int)element.getProperty("null", 42));
        Assertions.assertEquals((int)42, (int)element.getProperty("notThere", 42));
        Assertions.assertNotEquals((int)42, (int)element.getProperty("empty", 42));
    }

    @Test
    public void getPropertyStringConversions() {
        ElementJacksonTest.assertPropertyString(null, null);
        ElementJacksonTest.assertPropertyString("foo", "foo");
        ElementJacksonTest.assertPropertyString("", "");
        ElementJacksonTest.assertPropertyString("45.6e1", "45.6e1");
        ElementJacksonTest.assertPropertyString("true", Boolean.TRUE);
        ElementJacksonTest.assertPropertyString("false", Boolean.FALSE);
        ElementJacksonTest.assertPropertyString(String.valueOf(1.43534123423243E34), 1.43534123423243E34);
        ElementJacksonTest.assertPropertyString("42", 42.0);
        ElementJacksonTest.assertPropertyString(null, JacksonUtils.nullNode());
        ElementJacksonTest.assertPropertyString("{}", JacksonUtils.createObjectNode());
    }

    private static void assertPropertyString(String expected, Object value) {
        Element element = ElementJacksonTest.createPropertyAssertElement(value);
        Assertions.assertEquals((Object)expected, (Object)element.getProperty("property"));
    }

    @Test
    public void testPropertyBooleanConversions() {
        ElementJacksonTest.assertPropertyBoolean(true, Boolean.TRUE);
        ElementJacksonTest.assertPropertyBoolean(false, Boolean.FALSE);
        ElementJacksonTest.assertPropertyBoolean(true, "true");
        ElementJacksonTest.assertPropertyBoolean(true, "false");
        ElementJacksonTest.assertPropertyBoolean(false, "");
        ElementJacksonTest.assertPropertyBoolean(true, 1.0);
        ElementJacksonTest.assertPropertyBoolean(true, 3.14);
        ElementJacksonTest.assertPropertyBoolean(false, 0.0);
        ElementJacksonTest.assertPropertyBoolean(false, Double.NaN);
        ElementJacksonTest.assertPropertyBoolean(false, JacksonUtils.nullNode());
        ElementJacksonTest.assertPropertyBoolean(false, JacksonUtils.createNode((Object)false));
        ElementJacksonTest.assertPropertyBoolean(true, JacksonUtils.createNode((Object)true));
        ElementJacksonTest.assertPropertyBoolean(true, JacksonUtils.createObjectNode());
    }

    private static void assertPropertyBoolean(boolean expected, Object value) {
        Element element = ElementJacksonTest.createPropertyAssertElement(value);
        boolean actual = element.getProperty("property", !expected);
        if (expected) {
            Assertions.assertTrue((boolean)actual);
        } else {
            Assertions.assertFalse((boolean)actual);
        }
    }

    @Test
    public void testPropertyDoubleConversions() {
        ElementJacksonTest.assertPropertyDouble(1.0, 1.0);
        ElementJacksonTest.assertPropertyDouble(0.1, 0.1);
        ElementJacksonTest.assertPropertyDouble(Double.NaN, Double.NaN);
        ElementJacksonTest.assertPropertyDouble(1.0, "1");
        ElementJacksonTest.assertPropertyDouble(0.1, ".1");
        ElementJacksonTest.assertPropertyDouble(1.234E57, "12.34e56");
        ElementJacksonTest.assertPropertyDouble(Double.NaN, "foo");
        ElementJacksonTest.assertPropertyDouble(1.0, Boolean.TRUE);
        ElementJacksonTest.assertPropertyDouble(0.0, Boolean.FALSE);
        ElementJacksonTest.assertPropertyDouble(0.1, JacksonUtils.createNode((Object)0.1));
        ElementJacksonTest.assertPropertyDouble(1.0, JacksonUtils.createNode((Object)true));
        ElementJacksonTest.assertPropertyDouble(0.0, JacksonUtils.createNode((Object)false));
        ElementJacksonTest.assertPropertyDouble(0.1, JacksonUtils.createNode((Object)".1"));
        ElementJacksonTest.assertPropertyDouble(Double.NaN, JacksonUtils.createNode((Object)"foo"));
        ElementJacksonTest.assertPropertyDouble(Double.NaN, JacksonUtils.createObjectNode());
    }

    private static void assertPropertyDouble(double expected, Object value) {
        Element element = ElementJacksonTest.createPropertyAssertElement(value);
        boolean delta = false;
        double defaultValue = 1234.0;
        if (defaultValue == expected) {
            throw new IllegalArgumentException("Expecting the default value might cause unintended results");
        }
        Assertions.assertEquals((double)expected, (double)element.getProperty("property", defaultValue), (double)((double)delta));
    }

    @Test
    public void testPropertyIntConversions() {
        ElementJacksonTest.assertPropertyInt(1, 1.0);
        ElementJacksonTest.assertPropertyInt(1, 1.9);
        ElementJacksonTest.assertPropertyInt(0, Double.NaN);
        ElementJacksonTest.assertPropertyInt(Integer.MAX_VALUE, 1.234E57);
        ElementJacksonTest.assertPropertyInt(1, "1");
        ElementJacksonTest.assertPropertyInt(1, "1.9");
        ElementJacksonTest.assertPropertyInt(Integer.MAX_VALUE, "12.34e56");
        ElementJacksonTest.assertPropertyInt(0, "foo");
        ElementJacksonTest.assertPropertyInt(1, Boolean.TRUE);
        ElementJacksonTest.assertPropertyInt(0, Boolean.FALSE);
        ElementJacksonTest.assertPropertyInt(1, JacksonUtils.createNode((Object)1));
        ElementJacksonTest.assertPropertyInt(1, JacksonUtils.createNode((Object)1.9));
        ElementJacksonTest.assertPropertyInt(1, JacksonUtils.createNode((Object)true));
        ElementJacksonTest.assertPropertyInt(0, JacksonUtils.createNode((Object)false));
        ElementJacksonTest.assertPropertyInt(1, JacksonUtils.createNode((Object)"1"));
        ElementJacksonTest.assertPropertyInt(0, JacksonUtils.createNode((Object)"foo"));
        ElementJacksonTest.assertPropertyInt(0, JacksonUtils.createObjectNode());
    }

    private static void assertPropertyInt(int expected, Object value) {
        Element element = ElementJacksonTest.createPropertyAssertElement(value);
        int defaultValue = 1234;
        if (defaultValue == expected) {
            throw new IllegalArgumentException("Expecting the default value might cause unintended results");
        }
        Assertions.assertEquals((int)expected, (int)element.getProperty("property", defaultValue));
    }

    @Test
    public void propertyRawValues() {
        Element element = ElementFactory.createDiv();
        element.setProperty("p", "v");
        Assertions.assertEquals((Object)"v", (Object)element.getPropertyRaw("p"));
        element.setProperty("p", true);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)element.getPropertyRaw("p"));
        element.setProperty("p", 3.14);
        Assertions.assertEquals((Object)3.14, (Object)element.getPropertyRaw("p"));
        element.setPropertyJson("p", (BaseJsonNode)JacksonUtils.createObjectNode());
        Assertions.assertEquals(ObjectNode.class, element.getPropertyRaw("p").getClass());
        element.setPropertyJson("p", (BaseJsonNode)JacksonUtils.beanToJson((Object)new SimpleBean()));
        JsonNode json = (JsonNode)element.getPropertyRaw("p");
        Assertions.assertEquals((Object)"value", (Object)json.get("string").textValue());
        Assertions.assertEquals((double)1.0, (double)json.get("number").doubleValue(), (double)0.0);
        Assertions.assertEquals((double)2.3f, (double)json.get("flt").floatValue(), (double)0.0);
        Assertions.assertEquals((double)4.56, (double)json.get("dbl").doubleValue(), (double)0.0);
        ArrayList<SimpleBean> list = new ArrayList<SimpleBean>();
        SimpleBean bean1 = new SimpleBean();
        bean1.string = "bean1";
        SimpleBean bean2 = new SimpleBean();
        bean2.string = "bean2";
        list.add(bean1);
        list.add(bean2);
        element.setPropertyJson("p", (BaseJsonNode)JacksonUtils.listToJson(list));
        ArrayNode jsonArray = (ArrayNode)element.getPropertyRaw("p");
        Assertions.assertEquals((Object)"bean1", (Object)jsonArray.get(0).get("string").textValue());
        Assertions.assertEquals((Object)"bean2", (Object)jsonArray.get(1).get("string").textValue());
        HashMap<String, SimpleBean> map = new HashMap<String, SimpleBean>();
        map.put("one", bean1);
        map.put("two", bean2);
        element.setPropertyJson("p", (BaseJsonNode)JacksonUtils.mapToJson(map));
        JsonNode jsonObject = (JsonNode)element.getPropertyRaw("p");
        Assertions.assertEquals((Object)"bean1", (Object)jsonObject.get("one").get("string").textValue());
        Assertions.assertEquals((Object)"bean2", (Object)jsonObject.get("two").get("string").textValue());
    }

    @Test
    public void addAndRemoveProperty() {
        Element element = ElementFactory.createDiv();
        Assertions.assertFalse((boolean)element.hasProperty("foo"));
        element.removeProperty("foo");
        Assertions.assertFalse((boolean)element.hasProperty("foo"));
        element.setProperty("foo", "bar");
        Assertions.assertTrue((boolean)element.hasProperty("foo"));
        element.setProperty("foo", null);
        Assertions.assertTrue((boolean)element.hasProperty("foo"));
        element.removeProperty("foo");
        Assertions.assertFalse((boolean)element.hasProperty("foo"));
    }

    @Test
    public void propertyNames() {
        Element element = ElementFactory.createDiv();
        Assertions.assertEquals((long)0L, (long)element.getPropertyNames().count());
        element.setProperty("foo", "bar");
        Assertions.assertEquals(Collections.singleton("foo"), element.getPropertyNames().collect(Collectors.toSet()));
        element.removeProperty("foo");
        Assertions.assertEquals((long)0L, (long)element.getPropertyNames().count());
    }

    @Test
    public void setProperty_javaTimeObject() {
        BeanWithTemporalFields bean = new BeanWithTemporalFields();
        Element element = ElementFactory.createDiv();
        element.setPropertyBean("bean", (Object)bean);
        ObjectNode json = (ObjectNode)element.getPropertyRaw("bean");
        Assertions.assertTrue((boolean)JacksonUtils.jsonEquals((JsonNode)JacksonUtils.createNode((Object)"10:23:55"), (JsonNode)json.get("localTime")), (String)"LocalTime not serialized as expected");
        Assertions.assertTrue((boolean)JacksonUtils.jsonEquals((JsonNode)JacksonUtils.createNode((Object)"2024-06-26"), (JsonNode)json.get("localDate")), (String)"LocalDate not serialized as expected");
        Assertions.assertTrue((boolean)JacksonUtils.jsonEquals((JsonNode)JacksonUtils.createNode((Object)"2024-06-26T10:23:55"), (JsonNode)json.get("localDateTime")), (String)"LocalDateTime not serialized as expected");
        Assertions.assertEquals((float)bean.zonedDateTime.toEpochSecond(), (float)ZonedDateTime.parse(json.get("zonedDateTime").asString()).toEpochSecond(), (float)0.0f, (String)"ZonedDateTime not serialized as expected");
        Assertions.assertEquals((float)bean.sqlDate.getTime(), (float)ZonedDateTime.parse(json.get("sqlDate").asString()).toInstant().toEpochMilli(), (float)0.0f, (String)"ZonedDateTime not serialized as expected");
        Assertions.assertEquals((float)bean.date.getTime(), (float)ZonedDateTime.parse(json.get("date").asString()).toInstant().toEpochMilli(), (float)0.0f, (String)"ZonedDateTime not serialized as expected");
        Assertions.assertEquals((double)10.0, (double)Duration.parse(json.get("duration").asString()).toSeconds(), (double)0.0);
    }

    private static Element createPropertyAssertElement(Object value) {
        Element element = ElementFactory.createDiv();
        if (value instanceof Number && !(value instanceof Double)) {
            throw new IllegalArgumentException("Double is the only accepted numeric type");
        }
        if (value instanceof BaseJsonNode) {
            element.setPropertyJson("property", (BaseJsonNode)value);
        } else if (value instanceof Serializable) {
            BasicElementStateProvider.get().setProperty(element.getNode(), "property", (Serializable)value, true);
        } else if (value == null) {
            element.setProperty("property", null);
        } else {
            throw new IllegalArgumentException("Invalid value type: " + String.valueOf(value.getClass()));
        }
        return element;
    }

    @Test
    public void testGetTextContent() {
        Element child = new Element("child");
        child.appendChild(new Element[]{Element.createText((String)"bar")});
        Element element = ElementFactory.createDiv();
        element.appendChild(new Element[]{Element.createText((String)"foo")});
        element.appendChild(new Element[]{child});
        Assertions.assertEquals((Object)"foobar", (Object)element.getTextRecursively());
    }

    @Test
    public void testSetTextContent() {
        Element element = ElementFactory.createDiv();
        element.setText("foo");
        Assertions.assertEquals((Object)"foo", (Object)element.getTextRecursively());
        Assertions.assertEquals((int)1, (int)element.getChildCount());
        Assertions.assertTrue((boolean)element.getChild(0).isTextNode());
    }

    @Test
    public void testSetTextContentRemovesOldContent() {
        Element child = new Element("child");
        Element element = ElementFactory.createDiv();
        element.appendChild(new Element[]{child});
        element.setText("foo");
        Assertions.assertNull((Object)child.getParent());
        Assertions.assertEquals((Object)"foo", (Object)element.getTextRecursively());
    }

    @Test
    public void testSetTextReplacesOldTextNode() {
        Element element = ElementFactory.createDiv();
        Element text = Element.createText((String)"foo");
        element.appendChild(new Element[]{text});
        element.setText("bar");
        Assertions.assertEquals((Object)element, (Object)text.getParent());
        Assertions.assertEquals((Object)"bar", (Object)text.getTextRecursively());
    }

    @Test
    public void testSetTextContentPropertyThrows() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Element element = new Element("element");
            element.setProperty("textContent", "foo");
        });
    }

    @Test
    public void setOuterHtmlProperty_throws() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Element element = new Element("element");
            element.setProperty("outerHTML", "<br>");
        });
    }

    @Test
    public void setInnerHtmlProeprty_setValueAndRemoveAllChildren() {
        Element element = new Element("element");
        element.appendChild(new Element[]{ElementFactory.createAnchor(), ElementFactory.createDiv()});
        element.setProperty("innerHTML", "<br>");
        Assertions.assertEquals((int)0, (int)element.getChildCount());
        Assertions.assertEquals((Object)"<br>", (Object)element.getProperty("innerHTML"));
    }

    @Test
    public void testGetTextContentProperty() {
        Element element = ElementFactory.createDiv();
        element.setText("foo");
        Assertions.assertFalse((boolean)element.hasProperty("textContent"));
        Assertions.assertNull((Object)element.getProperty("textContent"));
    }

    @Test
    public void clearTextContentRemovesChild() {
        Element element = ElementFactory.createDiv();
        element.setText("foo");
        Assertions.assertEquals((int)1, (int)element.getChildCount());
        element.setText("");
        Assertions.assertEquals((int)0, (int)element.getChildCount());
    }

    @Test
    public void newElementClasses() {
        Element element = ElementFactory.createDiv();
        Assertions.assertFalse((boolean)element.hasAttribute("class"));
        Assertions.assertEquals(Collections.emptySet(), (Object)element.getClassList());
    }

    @Test
    public void addElementClasses() {
        Element element = ElementFactory.createDiv();
        element.getClassList().add((Object)"foo");
        Assertions.assertEquals(Collections.singleton("foo"), (Object)element.getClassList());
        Assertions.assertTrue((boolean)element.hasAttribute("class"));
        Assertions.assertEquals(Collections.singleton("class"), element.getAttributeNames().collect(Collectors.toSet()));
        Assertions.assertTrue((boolean)element.hasAttribute("class"));
        Assertions.assertEquals((Object)"foo", (Object)element.getAttribute("class"));
        element.getClassList().add((Object)"bar");
        Assertions.assertEquals((Object)"foo bar", (Object)element.getAttribute("class"));
    }

    @Test
    public void testSetClassAttribute() {
        Element element = ElementFactory.createDiv();
        ClassList classList = element.getClassList();
        element.setAttribute("class", "       foo bar ");
        Assertions.assertEquals((int)2, (int)classList.size());
        Assertions.assertTrue((boolean)classList.contains("foo"));
        Assertions.assertTrue((boolean)classList.contains("bar"));
        Assertions.assertNull((Object)((ElementAttributeMap)element.getNode().getFeature(ElementAttributeMap.class)).get("class"), (String)"class should not be stored as a regular attribute");
    }

    @Test
    public void testSetEmptyClassAttribute() {
        Element element = new Element("div");
        ClassList classList = element.getClassList();
        element.setAttribute("class", "");
        Assertions.assertEquals((int)0, (int)classList.size());
    }

    @Test
    public void testAddEmptyClassname() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Element element = new Element("div");
            ClassList classList = element.getClassList();
            classList.add("");
        });
    }

    @Test
    public void testRemoveClassName() {
        Element element = ElementFactory.createDiv();
        element.setAttribute("class", "foo bar");
        element.getClassList().remove((Object)"foo");
        Assertions.assertEquals((Object)"bar", (Object)element.getAttribute("class"));
        element.getClassList().remove((Object)"bar");
        Assertions.assertNull((Object)element.getAttribute("class"));
        Assertions.assertFalse((boolean)element.hasAttribute("class"));
        Assertions.assertEquals((long)0L, (long)element.getAttributeNames().count());
    }

    @Test
    public void testRemoveClassAttribute() {
        Element element = ElementFactory.createDiv();
        ClassList classList = element.getClassList();
        classList.add("foo");
        element.removeAttribute("class");
        Assertions.assertEquals(Collections.emptySet(), (Object)classList);
    }

    @Test
    public void addExistingClass_noop() {
        Element element = ElementFactory.createDiv();
        element.setAttribute("class", "foo");
        element.getClassList().add((Object)"foo");
        Assertions.assertEquals(Collections.singleton("foo"), (Object)element.getClassList());
    }

    @Test
    public void testAddClassWithSpaces_throws() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ElementFactory.createDiv().getClassList().add((Object)"foo bar"));
    }

    @Test
    public void testRemoveClassWithSpaces() {
        ClassList cl = ElementFactory.createDiv().getClassList();
        cl.add((Object)"foo");
        cl.add((Object)"bar");
        cl.remove((Object)"foo bar");
        Assertions.assertEquals((int)2, (int)cl.size());
    }

    @Test
    public void testContainsClassWithSpaces() {
        ClassList cl = ElementFactory.createDiv().getClassList();
        cl.add((Object)"foo");
        cl.add((Object)"bar");
        Assertions.assertFalse((boolean)cl.contains((Object)"foo bar"));
    }

    @Test
    public void classListSetAdd() {
        Element e = new Element("div");
        Assertions.assertTrue((boolean)e.getClassList().set("foo", true));
        Assertions.assertEquals((Object)"foo", (Object)e.getAttribute("class"));
        Assertions.assertFalse((boolean)e.getClassList().set("foo", true));
        Assertions.assertEquals((Object)"foo", (Object)e.getAttribute("class"));
    }

    @Test
    public void classListSetRemove() {
        Element e = new Element("div");
        e.setAttribute("class", "foo bar");
        Assertions.assertTrue((boolean)e.getClassList().set("foo", false));
        Assertions.assertEquals((Object)"bar", (Object)e.getAttribute("class"));
        Assertions.assertFalse((boolean)e.getClassList().set("foo", false));
        Assertions.assertEquals((Object)"bar", (Object)e.getAttribute("class"));
    }

    @Test
    public void testClassListProperty_throws() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ElementFactory.createDiv().setProperty("classList", "foo"));
    }

    @Test
    public void testClassNameProperty_throws() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ElementFactory.createDiv().setProperty("className", "foo"));
    }

    @Test
    public void setStyle() {
        Element e = ElementFactory.createDiv();
        Style s = e.getStyle();
        s.set("foo", "bar");
        Assertions.assertEquals((Object)"bar", (Object)s.get("foo"));
        s.set("--lumo-primary-text-color", "hsl(12, 12%, 12%)");
        Assertions.assertEquals((Object)"hsl(12, 12%, 12%)", (Object)s.get("--lumo-primary-text-color"));
    }

    @Test
    public void getUnsetStyle() {
        Element e = ElementFactory.createDiv();
        Style s = e.getStyle();
        Assertions.assertNull((Object)s.get("foo"));
    }

    @Test
    public void getNullStyle() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Element e = ElementFactory.createDiv();
            Style s = e.getStyle();
            s.get(null);
        });
    }

    @Test
    public void replaceStyle() {
        Element e = ElementFactory.createDiv();
        Style s = e.getStyle();
        s.set("foo", "bar");
        s.set("foo", "baz");
        Assertions.assertEquals((Object)"baz", (Object)s.get("foo"));
    }

    @Test
    public void removeSingleStyle() {
        Element e = ElementFactory.createDiv();
        Style s = e.getStyle();
        s.set("foo", "bar");
        s.remove("foo");
        Assertions.assertEquals(null, (Object)s.get("foo"));
    }

    @Test
    public void emptyStyleAsAttribute() {
        Element e = ElementFactory.createDiv();
        Assertions.assertFalse((boolean)e.hasAttribute("style"));
        Assertions.assertNull((Object)e.getAttribute("style"));
    }

    @Test
    public void semicolonInStyle() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Element e = ElementFactory.createDiv();
            Style s = e.getStyle();
            s.set("border", "1 px solid black;");
        });
    }

    @Test
    public void getSingleStyleAsAttribute() {
        Element e = ElementFactory.createDiv();
        Style s = e.getStyle();
        s.setBorder("1px solid black");
        Assertions.assertTrue((boolean)e.hasAttribute("style"));
        Assertions.assertEquals((Object)"border:1px solid black", (Object)e.getAttribute("style"));
    }

    @Test
    public void getMultipleStylesAsAttribute() {
        Element e = ElementFactory.createDiv();
        Style s = e.getStyle();
        s.set("border", "1px solid black");
        s.setMargin("1em");
        Assertions.assertTrue((boolean)e.hasAttribute("style"));
        this.assertEqualsOne(new String[]{"border:1px solid black;margin:1em", "margin:1em;border:1px solid black"}, e.getAttribute("style"));
    }

    @Test
    public void setSingleStyleAsAttribute() {
        Element e = ElementFactory.createDiv();
        String style = "width:12em";
        e.setAttribute("style", style);
        Assertions.assertEquals((Object)style, (Object)e.getAttribute("style"));
    }

    @Test
    public void setStyleAttributeMultipleTimes() {
        Element e = ElementFactory.createDiv();
        e.setAttribute("style", "width:12em");
        e.setAttribute("style", "height:12em");
        Assertions.assertEquals((Object)"height:12em", (Object)e.getAttribute("style"));
    }

    @Test
    public void setMultipleStylesAsAttribute() {
        Element e = ElementFactory.createDiv();
        String style = "width:12em;height:2em";
        e.setAttribute("style", style);
        Assertions.assertEquals((Object)style, (Object)e.getAttribute("style"));
        Assertions.assertEquals((Object)"2em", (Object)e.getStyle().get("height"));
    }

    @Test
    public void setComplexStylesAsAttribute() {
        this.testStyleAttribute("background:rgb(0,255,0) url(http://foo.bar/smiley.gif) no-repeat fixed center");
        this.testStyleAttribute("content:\"content: bar\"");
        this.testStyleAttribute("width:12px;content:\"content: bar\";height:12px");
        this.testStyleAttribute("width:calc(100% - 80px)");
        this.testStyleAttribute("width:var(--widthB)");
        this.testStyleAttribute("color:var(--mainColor)");
        this.testStyleAttribute("font-size:calc(var(--fontSize) * 2)");
        this.testStyleAttribute("--lumo-primary-text-color:hsl(12, 12%, 12%)");
        this.testStyleAttribute("background:url(\"https://example.com/images/myImg.jpg?q;param\")");
        Style style = this.testStyleAttribute("background-image:cross-fade(20% url(first.png?foo;bar&d=3), url(second.png))");
        Assertions.assertEquals((Object)"cross-fade(20% url(first.png?foo;bar&d=3), url(second.png))", (Object)style.get("background-image"));
        this.testStyleAttribute("mask-image:image(url(mask.png), skyblue, linear-gradient(rgb(0 0 0 / 100%), transparent))");
        style = this.testStyleAttribute("width:var(--widthB);color:var(--mainColor);background-image:cross-fade(20% url(first.png?foo;bar&d=3), url(second.png))");
        Assertions.assertEquals((Object)"var(--widthB)", (Object)style.get("width"));
        Assertions.assertEquals((Object)"var(--mainColor)", (Object)style.get("color"));
        Assertions.assertEquals((Object)"cross-fade(20% url(first.png?foo;bar&d=3), url(second.png))", (Object)style.get("background-image"));
    }

    private Style testStyleAttribute(String style) {
        Element e = ElementFactory.createDiv();
        e.setAttribute("style", style);
        Assertions.assertEquals((Object)style, (Object)e.getAttribute("style"));
        return e.getStyle();
    }

    @Test
    public void setInvalidStyleAsAttribute() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Element e = ElementFactory.createDiv();
            e.setAttribute("style", "width:");
        });
    }

    @Test
    public void setInvalidStyleAsAttribute2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Element e = ElementFactory.createDiv();
            e.setAttribute("style", "width");
        });
    }

    @Test
    public void setVendorSpecificStylesProperty() {
        Element e = ElementFactory.createDiv();
        String style = "-moz-user-input:inherit";
        e.setAttribute("style", style);
        Assertions.assertEquals((Object)"inherit", (Object)e.getStyle().get("mozUserInput"));
        Assertions.assertEquals((Object)style, (Object)e.getAttribute("style"));
    }

    @Test
    public void setVendorSpecificStylesValue() {
        Element e = ElementFactory.createDiv();
        String style = "display:-moz-box";
        e.setAttribute("style", style);
        Assertions.assertEquals((Object)"-moz-box", (Object)e.getStyle().get("display"));
        Assertions.assertEquals((Object)style, (Object)e.getAttribute("style"));
    }

    @Test
    public void setStyleAttributeTrailingSemicolon() {
        Element e = ElementFactory.createDiv();
        String style = "width:12em";
        e.setAttribute("style", style + ";");
        Assertions.assertEquals((Object)style, (Object)e.getAttribute("style"));
    }

    private void assertEqualsOne(String[] expected, String actual) {
        for (String string : expected) {
            if (!string.equals(actual)) continue;
            return;
        }
        String expectedString = Arrays.stream(expected).collect(Collectors.joining("> or <"));
        Assertions.fail((String)("expected: <" + expectedString + "> but was <" + actual + ">"));
    }

    @Test
    public void setEmptyStyleName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Element e = ElementFactory.createDiv();
            e.getStyle().set("", "foo");
        });
    }

    @Test
    public void setStyleNameExtraWhitespace() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Element e = ElementFactory.createDiv();
            e.getStyle().set("   color", "red");
        });
    }

    @Test
    public void setStyleNameColon() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Element e = ElementFactory.createDiv();
            e.getStyle().set("color:", "red");
        });
    }

    @Test
    public void setStyleValueExtraWhitespace() {
        Element e = ElementFactory.createDiv();
        e.getStyle().setColor("red   ");
        Assertions.assertEquals((Object)"color:red", (Object)e.getAttribute("style"));
        Assertions.assertEquals((Object)"red", (Object)e.getStyle().get("color"));
    }

    @Test
    public void removeStyles() {
        Element element = ElementFactory.createDiv();
        element.getStyle().setZIndex(Integer.valueOf(12));
        element.getStyle().set("background", "blue");
        element.getStyle().remove("background");
        Assertions.assertEquals((Object)"z-index:12", (Object)element.getAttribute("style"));
        element.getStyle().setZIndex(null);
        Assertions.assertNull((Object)element.getAttribute("style"));
        Assertions.assertFalse((boolean)element.hasAttribute("style"));
        Assertions.assertEquals((long)0L, (long)element.getStyle().getNames().count());
    }

    @Test
    public void removeStyleAttribute() {
        Element element = ElementFactory.createDiv();
        Style style = element.getStyle();
        style.setBorder("1px solid green");
        element.removeAttribute("style");
        Assertions.assertEquals((long)0L, (long)style.getNames().count());
    }

    @Test
    public void validStyleWithSemicolon() {
        Element element = ElementFactory.createDiv();
        String validStyle = "background: url('foo;bar')";
        Style style = element.getStyle();
        style.setBackground(validStyle);
        Assertions.assertEquals((Object)validStyle, (Object)style.get("background"));
    }

    @Test
    public void dashSeparatedSetStyle() {
        Element element = ElementFactory.createDiv();
        Style style = element.getStyle();
        style.set("border-color", "blue");
        Assertions.assertEquals((Object)"blue", (Object)style.get("border-color"));
    }

    @Test
    public void dashSeparatedGetStyle() {
        Element element = ElementFactory.createDiv();
        Style style = element.getStyle();
        style.set("borderColor", "blue");
        style.set("border-foo", "bar");
        Assertions.assertEquals((Object)"blue", (Object)style.get("border-color"));
        Assertions.assertEquals((Object)"bar", (Object)style.get("border-foo"));
    }

    @Test
    public void dashSeparatedHasStyle() {
        Element element = ElementFactory.createDiv();
        Style style = element.getStyle();
        style.set("borderColor", "blue");
        style.set("border-foo", "bar");
        Assertions.assertTrue((boolean)style.has("border-color"));
        Assertions.assertTrue((boolean)style.has("border-foo"));
    }

    @Test
    public void dashSeparatedRemoveStyle() {
        Element element = ElementFactory.createDiv();
        Style style = element.getStyle();
        style.set("borderColor", "blue");
        style.set("border-foo", "bar");
        style.remove("border-color");
        style.remove("border-foo");
        Assertions.assertFalse((boolean)style.has("border-color"));
        Assertions.assertFalse((boolean)style.has("border-foo"));
    }

    @Test
    public void styleGetNamesDashAndCamelCase() {
        Element element = ElementFactory.createDiv();
        Style style = element.getStyle();
        style.set("borderColor", "blue");
        style.set("border-foo", "bar");
        List styles = style.getNames().collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)styles.size());
        Assertions.assertTrue((boolean)styles.contains("border-color"));
        Assertions.assertTrue((boolean)styles.contains("border-foo"));
    }

    @Test
    public void nullStyleValue() {
        Element element = ElementFactory.createDiv();
        Style style = element.getStyle();
        style.set("borderColor", "blue");
        style.set("borderColor", null);
        List styles = style.getNames().collect(Collectors.toList());
        Assertions.assertFalse((boolean)styles.contains("borderColor"));
    }

    @Test
    public void sendPropertyInCorrectFormatToClient() {
        this.assertClientStyleKey("--some-variable", "--some-variable");
        this.assertClientStyleKey("-webkit-border", "-webkit-border");
        this.assertClientStyleKey("background-color", "background-color");
        this.assertClientStyleKey("color", "color");
        this.assertClientStyleKey("-webkit-border", "webkitBorder");
        this.assertClientStyleKey("background-color", "backgroundColor");
    }

    private void assertClientStyleKey(String sentToClient, String setUsingStyleApi) {
        Element element = ElementFactory.createDiv();
        StateNode stateNode = element.getNode();
        ElementStylePropertyMap map = (ElementStylePropertyMap)stateNode.getFeature(ElementStylePropertyMap.class);
        Style style = element.getStyle();
        style.set(setUsingStyleApi, "foo");
        Assertions.assertEquals((Object)"foo", (Object)style.get(setUsingStyleApi));
        Assertions.assertEquals((Object)sentToClient, (Object)map.getPropertyNames().toArray()[0]);
        Assertions.assertEquals((Object)"foo", (Object)map.getProperty(sentToClient));
    }

    @Test
    public void customPropertyStyle() {
        Element element = ElementFactory.createDiv();
        Style style = element.getStyle();
        style.set("--some-variable", "foo");
        Assertions.assertEquals((Object)"foo", (Object)style.get("--some-variable"));
    }

    @Test
    public void useCustomPropertyStyle() {
        Element element = ElementFactory.createDiv();
        Style style = element.getStyle();
        style.setColor("var(--some-var)");
        Assertions.assertEquals((Object)"var(--some-var)", (Object)style.get("color"));
    }

    @Test
    public void addAsOwnChild() {
        Assertions.assertThrows(IllegalStateException.class, () -> {
            Element element = ElementFactory.createDiv();
            element.appendChild(new Element[]{element});
        });
    }

    @Test
    public void addAsChildOfChild() {
        Assertions.assertThrows(IllegalStateException.class, () -> {
            Element parent = ElementFactory.createDiv();
            Element child = ElementFactory.createDiv();
            parent.appendChild(new Element[]{child});
            child.appendChild(new Element[]{parent});
        });
    }

    @Override
    protected void checkIsNotChild(Node<?> parent, Element child) {
        Assertions.assertNotEquals((Object)child.getParent(), parent);
        super.checkIsNotChild(parent, child);
    }

    @Test
    public void testGetOwnTextContent() {
        Element element = ElementFactory.createDiv();
        element.setText("foo");
        element.appendChild(new Element[]{(Element)ElementFactory.createDiv().appendChild(new Element[]{ElementFactory.createSpan((String)"span contents")})});
        element.appendChild(new Element[]{ElementFactory.createStrong((String)"strong contents")});
        element.appendChild(new Element[]{Element.createText((String)"Another text node")});
        Assertions.assertEquals((Object)"fooAnother text node", (Object)element.getText());
        Assertions.assertEquals((Object)"foospan contentsstrong contentsAnother text node", (Object)element.getTextRecursively());
    }

    @Test
    public void setResourceAttribute_elementIsNotAttached_elementHasAttribute() {
        UI.setCurrent((UI)this.createUI());
        Element element = ElementFactory.createDiv();
        String resName = "resource";
        StreamResource resource = this.createEmptyResource(resName);
        element.setAttribute("foo", (AbstractStreamResource)resource);
        Assertions.assertTrue((boolean)element.hasAttribute("foo"));
        Assertions.assertTrue((boolean)element.getAttribute("foo").endsWith(resName));
    }

    @Test
    public void setResourceAttribute_elementIsNotAttachedAndHasAttribute_elementHasAttribute() {
        UI.setCurrent((UI)this.createUI());
        Element element = ElementFactory.createDiv();
        element.setAttribute("foo", "bar");
        String resName = "resource";
        StreamResource resource = this.createEmptyResource(resName);
        element.setAttribute("foo", (AbstractStreamResource)resource);
        Assertions.assertTrue((boolean)element.hasAttribute("foo"));
        Assertions.assertTrue((boolean)element.getAttribute("foo").endsWith(resName));
    }

    @Test
    public void setResourceAttributeSeveralTimes_elementIsNotAttached_elementHasAttribute() {
        UI.setCurrent((UI)this.createUI());
        Element element = ElementFactory.createDiv();
        String resName = "resource";
        StreamResource resource = this.createEmptyResource(resName);
        element.setAttribute("foo", (AbstractStreamResource)resource);
        Assertions.assertTrue((boolean)element.hasAttribute("foo"));
        resName = "resource1";
        resource = this.createEmptyResource(resName);
        element.setAttribute("foo", (AbstractStreamResource)resource);
        Assertions.assertTrue((boolean)element.hasAttribute("foo"));
        Assertions.assertTrue((boolean)element.getAttribute("foo").endsWith(resName));
    }

    @Test
    public void setResourceAttribute_nullValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Element element = ElementFactory.createDiv();
            element.setAttribute("foo", (AbstractStreamResource)((StreamResource)null));
        });
    }

    @Test
    public void setResourceAttribute_classAttribute() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Element element = ElementFactory.createDiv();
            element.setAttribute("class", (AbstractStreamResource)Mockito.mock(StreamResource.class));
        });
    }

    @Test
    public void setResourceAttribute_nullAttribute() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Element element = ElementFactory.createDiv();
            element.setAttribute(null, (AbstractStreamResource)Mockito.mock(StreamResource.class));
        });
    }

    @Test
    public void setResourceAttribute_elementIsAttached_elementHasAttribute() {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        String resName = "resource";
        StreamResource resource = this.createEmptyResource(resName);
        ui.getElement().setAttribute("foo", (AbstractStreamResource)resource);
        Assertions.assertTrue((boolean)ui.getElement().hasAttribute("foo"));
        Assertions.assertTrue((boolean)ui.getElement().getAttribute("foo").endsWith(resName));
    }

    @Test
    public void setResourceAttribute_elementIsAttached_setAnotherResource() throws URISyntaxException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        StreamResource resource = this.createEmptyResource("resource1");
        ui.getElement().setAttribute("foo", (AbstractStreamResource)resource);
        String uri = ui.getElement().getAttribute("foo");
        Optional res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, new URI(uri));
        Assertions.assertTrue((boolean)res.isPresent());
        String resName = "resource2";
        ui.getElement().setAttribute("foo", (AbstractStreamResource)this.createEmptyResource(resName));
        res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, new URI(uri));
        Assertions.assertFalse((boolean)res.isPresent());
        Assertions.assertTrue((boolean)ui.getElement().hasAttribute("foo"));
        Assertions.assertTrue((boolean)ui.getElement().getAttribute("foo").endsWith(resName));
    }

    @Test
    public void setResourceAttribute_elementIsAttached_setRawAttribute() throws URISyntaxException, InterruptedException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        StreamResource resource = this.createEmptyResource("resource");
        ui.getElement().setAttribute("foo", (AbstractStreamResource)resource);
        String uri = ui.getElement().getAttribute("foo");
        Optional res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, new URI(uri));
        Assertions.assertTrue((boolean)res.isPresent());
        res = null;
        WeakReference<StreamResource> ref = new WeakReference<StreamResource>(resource);
        resource = null;
        ui.getElement().setAttribute("foo", "bar");
        TestUtil.isGarbageCollected(ref);
        res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, new URI(uri));
        Assertions.assertFalse((boolean)res.isPresent());
        Assertions.assertTrue((boolean)ui.getElement().hasAttribute("foo"));
        Assertions.assertTrue((boolean)ui.getElement().getAttribute("foo").equals("bar"));
    }

    @Test
    public void setResourceAttribute_elementIsAttached_removeAttribute() throws URISyntaxException, InterruptedException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        StreamResource resource = this.createEmptyResource("resource");
        ui.getElement().setAttribute("foo", (AbstractStreamResource)resource);
        String uri = ui.getElement().getAttribute("foo");
        Optional res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, new URI(uri));
        Assertions.assertTrue((boolean)res.isPresent());
        res = null;
        WeakReference<StreamResource> ref = new WeakReference<StreamResource>(resource);
        resource = null;
        ui.getElement().removeAttribute("foo");
        TestUtil.isGarbageCollected(ref);
        res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, new URI(uri));
        Assertions.assertFalse((boolean)res.isPresent());
        Assertions.assertFalse((boolean)ui.getElement().hasAttribute("foo"));
        Assertions.assertNull((Object)ui.getElement().getAttribute("foo"));
    }

    @Test
    public void setResourceAttribute_attachElement_resourceIsRegistered() throws URISyntaxException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        StreamResource resource = this.createEmptyResource("resource");
        Element element = ElementFactory.createDiv();
        element.setAttribute("foo", (AbstractStreamResource)resource);
        ui.getElement().appendChild(new Element[]{element});
        Assertions.assertTrue((boolean)element.hasAttribute("foo"));
        String uri = element.getAttribute("foo");
        Optional res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, new URI(uri));
        Assertions.assertTrue((boolean)res.isPresent());
    }

    @Test
    public void setResourceAttribute_attachElement_setAnotherResource() throws URISyntaxException, InterruptedException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        StreamResource resource = this.createEmptyResource("resource1");
        Element element = ElementFactory.createDiv();
        element.setAttribute("foo", (AbstractStreamResource)resource);
        WeakReference<StreamResource> ref = new WeakReference<StreamResource>(resource);
        resource = null;
        String resName = "resource2";
        element.setAttribute("foo", (AbstractStreamResource)this.createEmptyResource(resName));
        ui.getElement().appendChild(new Element[]{element});
        Assertions.assertTrue((boolean)element.hasAttribute("foo"));
        String uri = element.getAttribute("foo");
        Optional res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, new URI(uri));
        Assertions.assertTrue((boolean)res.isPresent());
        Assertions.assertTrue((boolean)uri.endsWith(resName));
        element = null;
        TestUtil.isGarbageCollected(ref);
    }

    @Test
    public void setResourceAttribute_attachElement_setRawAttribute() throws URISyntaxException, InterruptedException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        StreamResource resource = this.createEmptyResource("resource");
        Element element = ElementFactory.createDiv();
        element.setAttribute("foo", (AbstractStreamResource)resource);
        WeakReference<StreamResource> ref = new WeakReference<StreamResource>(resource);
        resource = null;
        element.setAttribute("foo", "bar");
        TestUtil.isGarbageCollected(ref);
        ui.getElement().appendChild(new Element[]{element});
        Assertions.assertTrue((boolean)element.hasAttribute("foo"));
        Assertions.assertEquals((Object)"bar", (Object)element.getAttribute("foo"));
    }

    @Test
    public void setResourceAttribute_attachElement_removeAttribute() throws URISyntaxException, InterruptedException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        StreamResource resource = this.createEmptyResource("resource");
        Element element = ElementFactory.createDiv();
        element.setAttribute("foo", (AbstractStreamResource)resource);
        WeakReference<StreamResource> ref = new WeakReference<StreamResource>(resource);
        resource = null;
        element.removeAttribute("foo");
        ui.getElement().appendChild(new Element[]{element});
        TestUtil.isGarbageCollected(ref);
        Assertions.assertFalse((boolean)element.hasAttribute("foo"));
        Assertions.assertNull((Object)element.getAttribute("foo"));
    }

    @Test
    public void setResourceAttribute_attachElement_setAnotherResourceAfterAttaching() throws URISyntaxException, InterruptedException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        StreamResource resource = this.createEmptyResource("resource1");
        Element element = ElementFactory.createDiv();
        element.setAttribute("foo", (AbstractStreamResource)resource);
        WeakReference<StreamResource> ref = new WeakReference<StreamResource>(resource);
        resource = null;
        ui.getElement().appendChild(new Element[]{element});
        String resName = "resource2";
        element.setAttribute("foo", (AbstractStreamResource)this.createEmptyResource(resName));
        Assertions.assertTrue((boolean)element.hasAttribute("foo"));
        TestUtil.isGarbageCollected(ref);
        Assertions.assertNull(ref.get());
        String uri = element.getAttribute("foo");
        Optional res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, new URI(uri));
        Assertions.assertTrue((boolean)res.isPresent());
        Assertions.assertTrue((boolean)uri.endsWith(resName));
    }

    @Test
    public void setResourceAttribute_attachElement_setRawAttributeAfterAttaching() throws URISyntaxException, InterruptedException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        StreamResource resource = this.createEmptyResource("resource");
        Element element = ElementFactory.createDiv();
        element.setAttribute("foo", (AbstractStreamResource)resource);
        WeakReference<StreamResource> ref = new WeakReference<StreamResource>(resource);
        resource = null;
        ui.getElement().appendChild(new Element[]{element});
        element.setAttribute("foo", "bar");
        TestUtil.isGarbageCollected(ref);
        Assertions.assertNull(ref.get());
        Assertions.assertTrue((boolean)element.hasAttribute("foo"));
        Assertions.assertEquals((Object)"bar", (Object)element.getAttribute("foo"));
    }

    @Test
    public void setResourceAttribute_attachElement_removeAttributeAfterAttaching() throws URISyntaxException, InterruptedException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        StreamResource resource = this.createEmptyResource("resource");
        Element element = ElementFactory.createDiv();
        element.setAttribute("foo", (AbstractStreamResource)resource);
        WeakReference<StreamResource> ref = new WeakReference<StreamResource>(resource);
        resource = null;
        ui.getElement().appendChild(new Element[]{element});
        element.removeAttribute("foo");
        TestUtil.isGarbageCollected(ref);
        Assertions.assertNull(ref.get());
        Assertions.assertFalse((boolean)element.hasAttribute("foo"));
        Assertions.assertNull((Object)element.getAttribute("foo"));
    }

    @Test
    public void setResourceAttribute_detachElement_resourceIsUnregistered() throws URISyntaxException, InterruptedException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        Element element = ElementFactory.createDiv();
        ui.getElement().appendChild(new Element[]{element});
        String resName = "resource";
        StreamResource resource = this.createEmptyResource(resName);
        element.setAttribute("foo", (AbstractStreamResource)resource);
        String attribute = element.getAttribute("foo");
        WeakReference<StreamResource> ref = new WeakReference<StreamResource>(resource);
        resource = null;
        URI uri = new URI(attribute);
        Optional res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, uri);
        Assertions.assertTrue((boolean)res.isPresent());
        ui.getElement().removeAllChildren();
        res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, uri);
        Assertions.assertFalse((boolean)res.isPresent());
        Assertions.assertTrue((boolean)element.hasAttribute("foo"));
        Assertions.assertNotNull((Object)element.getAttribute("foo"));
        Assertions.assertTrue((boolean)element.getAttribute("foo").endsWith(resName));
        element.setAttribute("foo", "bar");
        Assertions.assertTrue((boolean)element.hasAttribute("foo"));
        Assertions.assertEquals((Object)"bar", (Object)element.getAttribute("foo"));
        TestUtil.isGarbageCollected(ref);
    }

    @Test
    public void setResourceAttribute_detachAndReattachElement_resourceReregistered() throws URISyntaxException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        Element element = ElementFactory.createDiv();
        ui.getElement().appendChild(new Element[]{element});
        String resName = "resource";
        StreamResource resource = this.createEmptyResource(resName);
        element.setAttribute("foo", (AbstractStreamResource)resource);
        String attribute = element.getAttribute("foo");
        URI uri = new URI(attribute);
        Optional res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, uri);
        Assertions.assertTrue((boolean)res.isPresent());
        ui.getElement().removeAllChildren();
        res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, uri);
        Assertions.assertFalse((boolean)res.isPresent());
        ui.getElement().appendChild(new Element[]{element});
        res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, uri);
        Assertions.assertTrue((boolean)res.isPresent());
    }

    @Test
    public void setResourceAttribute_attachAndDetachAndReattachElement_resourceReregistered() throws URISyntaxException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        Element element = ElementFactory.createDiv();
        String resName = "resource";
        StreamResource resource = this.createEmptyResource(resName);
        element.setAttribute("foo", (AbstractStreamResource)resource);
        String attribute = element.getAttribute("foo");
        ui.getElement().appendChild(new Element[]{element});
        URI uri = new URI(attribute);
        Optional res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, uri);
        Assertions.assertTrue((boolean)res.isPresent());
        ui.getElement().removeAllChildren();
        res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, uri);
        Assertions.assertFalse((boolean)res.isPresent());
        ui.getElement().appendChild(new Element[]{element});
        res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, uri);
        Assertions.assertTrue((boolean)res.isPresent());
    }

    @Test
    public void setResourceAttribute_elementIsText_operationIsNotSupported() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> Element.createText((String)"").setAttribute("foo", (AbstractStreamResource)Mockito.mock(StreamResource.class)));
    }

    @Test
    public void testAttachListener_parentAttach_childListenersTriggered() {
        Element body = new UI().getElement();
        Element parent = ElementFactory.createDiv();
        Element child = ElementFactory.createDiv();
        Element grandChild = ElementFactory.createDiv();
        AtomicInteger childTriggered = new AtomicInteger();
        AtomicInteger grandChildTriggered = new AtomicInteger();
        Registration registrationHandle = child.addAttachListener((ElementAttachListener & Serializable)event -> childTriggered.addAndGet(1));
        child.addAttachListener((ElementAttachListener & Serializable)event -> Assertions.assertEquals((Object)child, (Object)event.getSource()));
        grandChild.addAttachListener((ElementAttachListener & Serializable)event -> grandChildTriggered.addAndGet(1));
        grandChild.addAttachListener((ElementAttachListener & Serializable)event -> Assertions.assertEquals((Object)grandChild, (Object)event.getSource()));
        parent.appendChild(new Element[]{child});
        child.appendChild(new Element[]{grandChild});
        Assertions.assertEquals((int)childTriggered.get(), (int)0);
        Assertions.assertEquals((int)grandChildTriggered.get(), (int)0);
        body.appendChild(new Element[]{parent});
        Assertions.assertEquals((int)childTriggered.get(), (int)1);
        Assertions.assertEquals((int)grandChildTriggered.get(), (int)1);
        body.removeAllChildren();
        parent.removeAllChildren();
        body.appendChild(new Element[]{parent});
        parent.appendChild(new Element[]{child});
        Assertions.assertEquals((int)childTriggered.get(), (int)2);
        Assertions.assertEquals((int)grandChildTriggered.get(), (int)2);
        registrationHandle.remove();
        body.removeAllChildren();
        body.appendChild(new Element[]{child});
        Assertions.assertEquals((int)childTriggered.get(), (int)2);
        Assertions.assertEquals((int)grandChildTriggered.get(), (int)3);
    }

    @Test
    public void testDetachListener_parentDetach_childListenersTriggered() {
        Element body = new UI().getElement();
        Element parent = ElementFactory.createDiv();
        Element child = ElementFactory.createDiv();
        Element grandChild = ElementFactory.createDiv();
        AtomicInteger triggered = new AtomicInteger();
        Registration registrationHandle = child.addDetachListener((ElementDetachListener & Serializable)event -> {
            triggered.addAndGet(1);
            Assertions.assertEquals((Object)child, (Object)event.getSource());
        });
        grandChild.addDetachListener((ElementDetachListener & Serializable)event -> {
            triggered.addAndGet(1);
            Assertions.assertEquals((Object)grandChild, (Object)event.getSource());
        });
        child.appendChild(new Element[]{grandChild});
        parent.appendChild(new Element[]{child});
        body.appendChild(new Element[]{parent});
        Assertions.assertEquals((int)triggered.get(), (int)0);
        body.removeAllChildren();
        Assertions.assertEquals((int)triggered.get(), (int)2);
        body.appendChild(new Element[]{parent});
        body.removeAllChildren();
        Assertions.assertEquals((int)triggered.get(), (int)4);
        body.appendChild(new Element[]{parent});
        registrationHandle.remove();
        body.removeAllChildren();
        Assertions.assertEquals((int)triggered.get(), (int)5);
    }

    @Test
    public void testAttachListener_eventOrder_childFirst() {
        Element body = new UI().getElement();
        Element parent = ElementFactory.createDiv();
        Element child = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child});
        AtomicBoolean parentAttached = new AtomicBoolean();
        AtomicBoolean childAttached = new AtomicBoolean();
        child.addAttachListener((ElementAttachListener & Serializable)event -> {
            childAttached.set(true);
            Assertions.assertFalse((boolean)parentAttached.get());
        });
        parent.addAttachListener((ElementAttachListener & Serializable)event -> {
            parentAttached.set(true);
            Assertions.assertTrue((boolean)childAttached.get());
        });
        body.appendChild(new Element[]{parent});
        Assertions.assertTrue((boolean)parentAttached.get());
        Assertions.assertTrue((boolean)childAttached.get());
    }

    @Test
    public void testDetachListener_eventOrder_childFirst() {
        Element body = new UI().getElement();
        Element parent = ElementFactory.createDiv();
        Element child = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child});
        body.appendChild(new Element[]{parent});
        AtomicBoolean parentDetached = new AtomicBoolean();
        AtomicBoolean childDetached = new AtomicBoolean();
        child.addDetachListener((ElementDetachListener & Serializable)event -> {
            childDetached.set(true);
            Assertions.assertFalse((boolean)parentDetached.get());
        });
        parent.addDetachListener((ElementDetachListener & Serializable)event -> {
            parentDetached.set(true);
            Assertions.assertTrue((boolean)childDetached.get());
        });
        body.removeAllChildren();
        Assertions.assertTrue((boolean)parentDetached.get());
        Assertions.assertTrue((boolean)childDetached.get());
    }

    @Test
    public void testAttachDetach_elementMoved_bothEventsTriggered() {
        Element body = new UI().getElement();
        Element parent = ElementFactory.createDiv();
        Element child = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child});
        body.appendChild(new Element[]{parent});
        AtomicBoolean attached = new AtomicBoolean();
        AtomicBoolean detached = new AtomicBoolean();
        child.addAttachListener((ElementAttachListener & Serializable)event -> {
            attached.set(true);
            Assertions.assertTrue((boolean)detached.get());
        });
        child.addDetachListener((ElementDetachListener & Serializable)event -> {
            detached.set(true);
            Assertions.assertFalse((boolean)attached.get());
        });
        body.appendChild(new Element[]{child});
        Assertions.assertTrue((boolean)attached.get());
        Assertions.assertTrue((boolean)detached.get());
    }

    @Test
    public void testAttachEvent_stateTreeCanFound() {
        Element body = new UI().getElement();
        Element child = ElementFactory.createDiv();
        AtomicInteger attached = new AtomicInteger();
        child.addAttachListener((ElementAttachListener & Serializable)event -> {
            Assertions.assertNotNull((Object)event.getSource().getNode().getOwner());
            Assertions.assertNotEquals((Object)NullOwner.get(), (Object)event.getSource().getNode().getOwner());
        });
        child.addAttachListener((ElementAttachListener & Serializable)event -> attached.incrementAndGet());
        body.appendChild(new Element[]{child});
        Assertions.assertEquals((int)1, (int)attached.get());
    }

    @Test
    public void testDetachEvent_stateTreeCanFound() {
        Element body = new UI().getElement();
        Element child = ElementFactory.createDiv();
        body.appendChild(new Element[]{child});
        AtomicInteger detached = new AtomicInteger();
        child.addDetachListener((ElementDetachListener & Serializable)event -> {
            Assertions.assertNotNull((Object)event.getSource().getNode().getOwner());
            Assertions.assertNotEquals((Object)NullOwner.get(), (Object)event.getSource().getNode().getOwner());
        });
        child.addDetachListener((ElementDetachListener & Serializable)event -> detached.incrementAndGet());
        body.removeAllChildren();
        Assertions.assertEquals((int)1, (int)detached.get());
    }

    @Test
    public void testMoveFromUiToUi_doesNotThrow() {
        Element body = new UI().getElement();
        Element child = ElementFactory.createDiv();
        body.appendChild(new Element[]{child});
        child.removeFromTree();
        body = new UI().getElement();
        body.appendChild(new Element[]{child});
        Assertions.assertEquals((Object)body, (Object)child.getParent());
    }

    @Test
    public void testRemoveFromTree_inDetachListener_removedFromParent() {
        Element body = new UI().getElement();
        Element child = ElementFactory.createDiv();
        body.appendChild(new Element[]{child});
        child.addDetachListener((ElementDetachListener & Serializable)event -> child.removeFromTree());
        body.removeAllChildren();
        Assertions.assertEquals(null, (Object)child.getParent());
    }

    @Test
    public void testRemoveFromTree_isVirtualChild_removedFromParent() {
        Element body = new UI().getElement();
        Element child = ElementFactory.createDiv();
        ((VirtualChildrenList)body.getNode().getFeature(VirtualChildrenList.class)).append(child.getNode(), "");
        Assertions.assertTrue((boolean)child.isVirtualChild());
        child.removeFromTree();
        Assertions.assertFalse((boolean)child.isVirtualChild());
        Assertions.assertEquals((int)0, (int)((VirtualChildrenList)body.getNode().getFeature(VirtualChildrenList.class)).size());
    }

    private StreamResource createEmptyResource(String resName) {
        return new StreamResource(resName, (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(new byte[0]));
    }

    private UI createUI() {
        final AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)new MockVaadinServletService());
        UI ui = new UI(){

            public VaadinSession getSession() {
                return session;
            }
        };
        return ui;
    }

    @Test
    public void insertAtCurrentPositionNoOp() {
        UI ui = new UI();
        Element parent = ui.getElement();
        Element child = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child});
        child.addDetachListener((ElementDetachListener & Serializable)e -> Assertions.fail((String)"Child should not be detached"));
        parent.insertChild(0, new Element[]{child});
    }

    @Test
    public void textNodeTransformsNullToEmptyAndDoesNotThrowException() {
        Element e = Element.createText(null);
        Assertions.assertEquals((Object)"", (Object)e.getText());
    }

    @Test
    public void textNodeOuterHtml() {
        Element e = Element.createText((String)"foobar");
        Assertions.assertEquals((Object)"foobar", (Object)e.getOuterHTML());
    }

    @Test
    public void singleElementOuterHtml() {
        Element e = ElementFactory.createAnchor();
        Assertions.assertEquals((Object)"<a></a>", (Object)e.getOuterHTML());
    }

    @Test
    public void elementTreeOuterHtml() {
        Element div = ElementFactory.createDiv();
        Element span = ElementFactory.createSpan();
        Element button = ElementFactory.createButton((String)"hello");
        div.appendChild(new Element[]{span});
        span.appendChild(new Element[]{button});
        Assertions.assertEquals((Object)"<div>\n <span>\n  <button>hello</button>\n </span>\n</div>", (Object)div.getOuterHTML());
    }

    @Test
    public void elementAttributesOuterHtml() {
        Element div = ElementFactory.createDiv();
        div.setAttribute("foo", "bar");
        div.getStyle().setWidth("20px");
        div.getClassList().add((Object)"cls");
        div.setAttribute("pin", "");
        Assertions.assertEquals((Object)"<div pin foo=\"bar\" style=\"width:20px\" class=\"cls\"></div>", (Object)div.getOuterHTML());
    }

    @Test
    public void elementAttributeSpecialCharactersOuterHtml() {
        Element div = ElementFactory.createDiv();
        div.setAttribute("foo", "bar\"'&quot;");
        Assertions.assertEquals((Object)"<div foo=\"bar&quot;'&amp;quot;\"></div>", (Object)div.getOuterHTML());
    }

    @Test
    public void htmlComponentOuterHtml() {
        Html html = new Html("<div style='background:green'><span><button>hello</button></span></div>");
        Assertions.assertEquals((Object)"<div style=\"background:green\">\n <span>\n  <button>hello</button>\n </span>\n</div>", (Object)html.getElement().getOuterHTML());
    }

    @Test
    public void callFunctionBeforeAttach() {
        MockUI ui = new MockUI();
        Element element = ElementFactory.createDiv();
        element.callJsFunction("noArgsMethod", new Object[0]);
        ui.getElement().appendChild(new Element[]{element});
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        this.assertPendingJs(ui, "return $0.noArgsMethod()", element);
    }

    @Test
    public void callFunctionAfterAttach() {
        MockUI ui = new MockUI();
        Element element = ElementFactory.createDiv();
        ui.getElement().appendChild(new Element[]{element});
        element.callJsFunction("noArgsMethod", new Object[0]);
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        this.assertPendingJs(ui, "return $0.noArgsMethod()", element);
    }

    @Test
    public void callFunctionBeforeDetach() {
        MockUI ui = new MockUI();
        Element element = ElementFactory.createDiv();
        ui.getElement().appendChild(new Element[]{element});
        element.callJsFunction("noArgsMethod", new Object[0]);
        ui.getElement().removeAllChildren();
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        List invocations = ui.getInternals().dumpPendingJavaScriptInvocations();
        Assertions.assertTrue((boolean)invocations.isEmpty());
    }

    @Test
    public void callFunctionBeforeReAttach() {
        MockUI ui = new MockUI();
        Element element = ElementFactory.createDiv();
        ui.getElement().appendChild(new Element[]{element});
        element.callJsFunction("noArgsMethod", new Object[0]);
        Element div = ElementFactory.createDiv();
        ui.getElement().appendChild(new Element[]{div});
        div.appendChild(new Element[]{element});
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        this.assertPendingJs(ui, "return $0.noArgsMethod()", element);
    }

    @Test
    public void callFunctionOneParam() {
        MockUI ui = new MockUI();
        Element element = ElementFactory.createDiv();
        element.callJsFunction("method", new Object[]{"foo"});
        ui.getElement().appendChild(new Element[]{element});
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        this.assertPendingJs(ui, "return $0.method($1)", element, "foo");
    }

    @Test
    public void callFunctionTwoParams() {
        MockUI ui = new MockUI();
        Element element = ElementFactory.createDiv();
        element.callJsFunction("method", new Object[]{"foo", 123});
        ui.getElement().appendChild(new Element[]{element});
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        this.assertPendingJs(ui, "return $0.method($1,$2)", element, "foo", 123);
    }

    @Test
    public void callFunctionWithBean() {
        MockUI ui = new MockUI();
        Element element = ElementFactory.createDiv();
        SimpleBean bean = new SimpleBean();
        element.callJsFunction("method", new Object[]{bean});
        ui.getElement().appendChild(new Element[]{element});
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        this.assertPendingJs(ui, "return $0.method($1)", element, bean);
    }

    @Test
    public void callFunctionOnProperty() {
        MockUI ui = new MockUI();
        Element element = ElementFactory.createDiv();
        element.callJsFunction("property.method", new Object[0]);
        ui.getElement().appendChild(new Element[]{element});
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        this.assertPendingJs(ui, "return $0.property.method()", element);
    }

    @Test
    public void callFunctionOnSubProperty() {
        MockUI ui = new MockUI();
        Element element = ElementFactory.createDiv();
        element.callJsFunction("property.other.method", new Object[0]);
        ui.getElement().appendChild(new Element[]{element});
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        this.assertPendingJs(ui, "return $0.property.other.method()", element);
    }

    @Test
    public void attachShadowRoot_shadowRootCreatedAndChildrenArePreserved() {
        Element element = ElementFactory.createDiv();
        Element button = ElementFactory.createButton();
        Element emphasis = ElementFactory.createEmphasis();
        element.appendChild(new Element[]{button, emphasis});
        ShadowRoot shadow = element.attachShadow();
        Assertions.assertNotNull((Object)shadow);
        Assertions.assertEquals((Object)element, (Object)shadow.getHost());
        Assertions.assertEquals((Object)shadow, element.getShadowRoot().get());
        Assertions.assertEquals((int)2, (int)element.getChildCount());
        Assertions.assertEquals((long)2L, (long)element.getChildren().count());
        Assertions.assertEquals((Object)button, (Object)element.getChild(0));
        Assertions.assertEquals((Object)emphasis, (Object)element.getChild(1));
    }

    @Test
    public void getShadowRoot_shadowRootIsEmpty() {
        Element element = ElementFactory.createDiv();
        Assertions.assertFalse((boolean)element.getShadowRoot().isPresent());
    }

    @Test
    public void getParentNode_parentNodeIsTheSameAsParent() {
        Element element = ElementFactory.createDiv();
        Element child = ElementFactory.createDiv();
        element.appendChild(new Element[]{child});
        Assertions.assertEquals((Object)child.getParent(), (Object)child.getParentNode());
    }

    @Test
    public void getParentNode_elementInShadowRoot_parentIsNull() {
        ShadowRoot element = ElementFactory.createDiv().attachShadow();
        Element child = ElementFactory.createDiv();
        element.appendChild(new Element[]{child});
        Assertions.assertNull((Object)child.getParent());
        Assertions.assertEquals((Object)element, (Object)child.getParentNode());
    }

    @Test
    public void parentIsDisabled_childIsDisabled() {
        Element parent = ElementFactory.createDiv();
        Element child = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child});
        Assertions.assertTrue((boolean)parent.isEnabled(), (String)"Parent should be enabled");
        Assertions.assertTrue((boolean)child.isEnabled(), (String)"Child should be enabled");
        parent.setEnabled(false);
        Assertions.assertFalse((boolean)parent.isEnabled(), (String)"Parent should be disabled");
        Assertions.assertFalse((boolean)child.isEnabled(), (String)"Child should be disabled");
        child.removeFromParent();
        Assertions.assertTrue((boolean)child.isEnabled(), (String)"Child should be enabled");
    }

    @Test
    public void emptyElement_setDisabled_noChildFeatures() {
        Element element = ElementFactory.createDiv();
        element.setEnabled(false);
        BasicElementStateProviderTest.assertNoChildFeatures(element);
    }

    @Test
    public void emptyElement_isVirtualChild_noChildFeatures() {
        Element element = ElementFactory.createDiv();
        element.isVirtualChild();
        BasicElementStateProviderTest.assertNoChildFeatures(element);
    }

    @Test
    public void elementWithoutComponent_getComponentFeature() {
        Element element = ElementFactory.createDiv();
        element.appendChild(new Element[]{ElementFactory.createDiv()});
        element.getComponent();
        Assertions.assertFalse((boolean)element.getNode().getFeatureIfInitialized(ComponentMapping.class).isPresent(), (String)"getComponent() shouldn't initialize a component mapping feature");
    }

    @Test
    public void readMissingProperty_noFeatureInitialized() {
        Element element = ElementFactory.createDiv();
        element.getProperty("foo");
        element.hasProperty("foo");
        element.removeProperty("foo");
        element.getPropertyNames().collect(Collectors.toList());
        Assertions.assertFalse((boolean)element.getNode().getFeatureIfInitialized(ElementPropertyMap.class).isPresent(), (String)"reading a property value shouldn't initialize a property map feature");
    }

    @Test
    public void readMissingAttribute_noFeatureInitialized() {
        Element element = ElementFactory.createDiv();
        element.getAttribute("foo");
        element.hasAttribute("foo");
        element.removeAttribute("foo");
        element.getAttributeNames().collect(Collectors.toList());
        Assertions.assertFalse((boolean)element.getNode().getFeatureIfInitialized(ElementAttributeMap.class).isPresent(), (String)"reading an attribute value shouldn't initialize an attribute map feature");
    }

    @Test
    public void virtualChildren_areIdentifiedAsSuch() {
        Element parent = ElementFactory.createDiv();
        Element child = ElementFactory.createDiv();
        Element virtualChild = ElementFactory.createDiv();
        Element grandVirtualChild = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child});
        parent.appendVirtualChild(new Element[]{virtualChild});
        virtualChild.appendChild(new Element[]{grandVirtualChild});
        Assertions.assertFalse((boolean)parent.isVirtualChild());
        Assertions.assertFalse((boolean)child.isVirtualChild());
        Assertions.assertTrue((boolean)virtualChild.isVirtualChild());
        Assertions.assertFalse((boolean)grandVirtualChild.isVirtualChild());
    }

    @Test
    public void domPropertyListener_registersListenerAndDomTrigger() {
        Element element = ElementFactory.createDiv();
        AtomicReference listenerValue = new AtomicReference();
        element.addPropertyChangeListener("property", "event", (PropertyChangeListener & Serializable)event -> {
            if (listenerValue.getAndSet(event.getValue()) != null) {
                Assertions.fail((String)"Unexpected event");
            }
        });
        Assertions.assertEquals((Object)DisabledUpdateMode.ONLY_WHEN_ENABLED, (Object)((ElementListenerMap)element.getNode().getFeature(ElementListenerMap.class)).getPropertySynchronizationMode("property"), (String)"The property should be synchronized");
        ElementListenerMap listenerMap = (ElementListenerMap)element.getNode().getFeature(ElementListenerMap.class);
        Assertions.assertEquals(Collections.singleton("}property"), ElementListenersTest.getExpressions(listenerMap, "event"), (String)"A DOM event synchronization should be defined");
        element.setProperty("property", "value");
        Assertions.assertEquals(listenerValue.get(), (Object)"value", (String)"Listener shold be registered");
    }

    @Test
    public void domPropertyListener_unregisterCleansEverything() {
        Element element = ElementFactory.createDiv();
        DomListenerRegistration registration = element.addPropertyChangeListener("property", "event", (PropertyChangeListener & Serializable)event -> Assertions.fail((String)"Unexpected event"));
        registration.remove();
        Assertions.assertNull((Object)((ElementListenerMap)element.getNode().getFeature(ElementListenerMap.class)).getPropertySynchronizationMode("property"), (String)"The property should not be synchronized");
        ElementListenerMap listenerMap = (ElementListenerMap)element.getNode().getFeature(ElementListenerMap.class);
        Assertions.assertEquals(Collections.emptySet(), ElementListenersTest.getExpressions(listenerMap, "event"), (String)"There should be no DOM listener");
        element.setProperty("property", "value");
    }

    @Test
    public void removingVirtualChildrenIsPossible() {
        Element parent = new Element("root");
        Element child1 = new Element("main");
        Element child2 = new Element("menu");
        parent.appendVirtualChild(new Element[]{child1, child2});
        parent.removeVirtualChild(new Element[]{child2, child1});
        Assertions.assertNull((Object)child1.getParent());
        Assertions.assertFalse((boolean)child1.isVirtualChild());
        Assertions.assertNull((Object)child2.getParent());
        Assertions.assertFalse((boolean)child2.isVirtualChild());
    }

    @Test
    public void removeVirtualChildren_notVirtualChild_fails() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Element parent = new Element("root");
            Element child1 = new Element("main");
            parent.appendChild(new Element[]{child1});
            parent.removeVirtualChild(new Element[]{child1});
        });
    }

    @Test
    public void removeFromParent_virtualChild_fails() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Element parent = new Element("root");
            Element child1 = new Element("main");
            parent.appendVirtualChild(new Element[]{child1});
            child1.removeFromParent();
        });
    }

    @Test
    public void executeJavaScript_delegatesToExecJs() {
        final AtomicReference invokedExpression = new AtomicReference();
        final AtomicReference invokedParams = new AtomicReference();
        Element element = new Element("div"){

            public PendingJavaScriptResult executeJs(String expression, Object ... parameters) {
                String oldExpression = invokedExpression.getAndSet(expression);
                Assertions.assertNull((Object)oldExpression, (String)"There should be no old expression");
                Object[] oldParams = invokedParams.getAndSet(parameters);
                Assertions.assertNull((Object)oldParams, (String)"There should be no old params");
                return null;
            }
        };
        element.executeJs("foo", new Object[]{1, true});
        Assertions.assertEquals((Object)"foo", invokedExpression.get());
        Assertions.assertEquals((Object)1, (Object)((Object[])invokedParams.get())[0]);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)((Object[])invokedParams.get())[1]);
    }

    @Test
    public void callFunction_delegatesToCallJsFunction() {
        final AtomicReference invokedFuction = new AtomicReference();
        final AtomicReference invokedParams = new AtomicReference();
        Element element = new Element("div"){

            public PendingJavaScriptResult callJsFunction(String functionName, Object ... arguments) {
                String oldExpression = invokedFuction.getAndSet(functionName);
                Assertions.assertNull((Object)oldExpression, (String)"There should be no old function name");
                Object[] oldParams = invokedParams.getAndSet(arguments);
                Assertions.assertNull((Object)oldParams, (String)"There should be no old params");
                return null;
            }
        };
        element.callJsFunction("foo", new Object[]{1, true});
        Assertions.assertEquals((Object)"foo", invokedFuction.get());
        Assertions.assertEquals((Object)1, (Object)((Object[])invokedParams.get())[0]);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)((Object[])invokedParams.get())[1]);
    }

    protected Element createParentNode() {
        return ElementFactory.createDiv();
    }

    @Override
    protected void assertChild(Node<?> parent, int index, Element child) {
        Assertions.assertEquals(parent, (Object)child.getParent());
        Assertions.assertEquals((Object)child, (Object)parent.getChild(index));
    }

    private void assertPendingJs(UI ui, String js, Object ... arguments) {
        List pendingJs = ui.getInternals().dumpPendingJavaScriptInvocations();
        UIInternals.JavaScriptInvocation expected = new UIInternals.JavaScriptInvocation(js, arguments);
        Assertions.assertEquals((int)1, (int)pendingJs.size());
        this.assertInvocationEquals(expected, ((PendingJavaScriptInvocation)pendingJs.get(0)).getInvocation());
    }

    private void assertInvocationEquals(UIInternals.JavaScriptInvocation expected, UIInternals.JavaScriptInvocation actual) {
        Assertions.assertEquals((Object)expected.getExpression(), (Object)actual.getExpression());
        Assertions.assertArrayEquals((Object[])expected.getParameters().toArray(), (Object[])actual.getParameters().toArray());
    }

    private static ArrayNode createNumberArray(double ... items) {
        return (ArrayNode)DoubleStream.of(items).mapToObj(JacksonUtils::createNode).collect(JacksonUtils.asArray());
    }

    public static class SimpleBean {
        private String string = "value";
        private int number = 1;
        private float flt = 2.3f;
        private double dbl = 4.56;

        public String getString() {
            return this.string;
        }

        public int getNumber() {
            return this.number;
        }

        public float getFlt() {
            return this.flt;
        }

        public double getDbl() {
            return this.dbl;
        }
    }

    public static class BeanWithTemporalFields {
        public LocalTime localTime = LocalTime.of(10, 23, 55);
        public LocalDate localDate = LocalDate.of(2024, 6, 26);
        public LocalDateTime localDateTime = this.localDate.atTime(this.localTime);
        public Date sqlDate = Date.valueOf(this.localDate);
        public java.util.Date date = new java.util.Date(this.sqlDate.getTime());
        public ZonedDateTime zonedDateTime = ZonedDateTime.of(this.localDateTime, ZoneId.of("Europe/Rome"));
        public Duration duration = Duration.ofSeconds(10L);
    }
}

