/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.flow.internal.nodefeature.SignalBindingFeature;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.local.ValueSignal;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ClassListBindTest
extends SignalsUnitTest {
    ClassListBindTest() {
    }

    @Test
    public void bindingMirrorsSignalWhileAttached_toggleAddsRemovesClass() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)false);
        element.getClassList().bind("highlight", (Signal)signal);
        Assertions.assertFalse((boolean)element.getClassList().contains((Object)"highlight"));
        signal.set((Object)true);
        Assertions.assertTrue((boolean)element.getClassList().contains((Object)"highlight"));
        signal.set((Object)false);
        Assertions.assertFalse((boolean)element.getClassList().contains((Object)"highlight"));
    }

    @Test
    public void bindingInactiveWhenDetached_reactivatedOnAttach_appliesCurrentValue() {
        Element element = new Element("span");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)false);
        element.getClassList().bind("active", (Signal)signal);
        UI.getCurrent().getElement().removeChild(new Element[]{element});
        signal.set((Object)true);
        Assertions.assertFalse((boolean)element.getClassList().contains((Object)"active"));
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        Assertions.assertTrue((boolean)element.getClassList().contains((Object)"active"));
    }

    @Test
    public void manualAddRemoveForBoundName_throwsBindingActiveException() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)true);
        element.getClassList().bind("locked", (Signal)signal);
        Assertions.assertThrows(BindingActiveException.class, () -> element.getClassList().add((Object)"locked"));
        Assertions.assertThrows(BindingActiveException.class, () -> element.getClassList().remove((Object)"locked"));
        Assertions.assertThrows(BindingActiveException.class, () -> element.getClassList().set("locked", true));
        Assertions.assertThrows(BindingActiveException.class, () -> element.getClassList().set("locked", false));
    }

    @Test
    public void clear_clearsBindingsSilently_andClearsClasses() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal a = new ValueSignal((Object)true);
        ValueSignal b = new ValueSignal((Object)true);
        element.getClassList().bind("a", (Signal)a);
        element.getClassList().bind("b", (Signal)b);
        Assertions.assertTrue((boolean)element.getClassList().contains((Object)"a"));
        Assertions.assertTrue((boolean)element.getClassList().contains((Object)"b"));
        element.getClassList().clear();
        Assertions.assertFalse((boolean)element.getClassList().contains((Object)"a"));
        Assertions.assertFalse((boolean)element.getClassList().contains((Object)"b"));
        a.set((Object)false);
        b.set((Object)false);
        a.set((Object)true);
        b.set((Object)true);
        Assertions.assertFalse((boolean)element.getClassList().contains((Object)"a"));
        Assertions.assertFalse((boolean)element.getClassList().contains((Object)"b"));
        Assertions.assertFalse((boolean)element.getClassList().iterator().hasNext());
    }

    @Test
    public void setAttributeClass_bulkReplacement_clearsBindingsSilently() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal bound = new ValueSignal((Object)true);
        element.getClassList().bind("flag", (Signal)bound);
        Assertions.assertTrue((boolean)element.getClassList().contains((Object)"flag"));
        element.setAttribute("class", "foo bar");
        Assertions.assertTrue((boolean)element.getClassList().contains((Object)"foo"));
        Assertions.assertTrue((boolean)element.getClassList().contains((Object)"bar"));
        Assertions.assertFalse((boolean)element.getClassList().contains((Object)"flag"));
        bound.set((Object)false);
        bound.set((Object)true);
        Assertions.assertFalse((boolean)element.getClassList().contains((Object)"flag"));
    }

    @Test
    public void bind_removeBindingViaFeature_stopsUpdatesAndAllowsManualSet() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)true);
        element.getClassList().bind("badge", (Signal)signal);
        Assertions.assertTrue((boolean)element.getClassList().contains((Object)"badge"));
        SignalBindingFeature feature = (SignalBindingFeature)element.getNode().getFeature(SignalBindingFeature.class);
        feature.removeBinding("classes/badge");
        signal.set((Object)false);
        Assertions.assertTrue((boolean)element.getClassList().contains((Object)"badge"));
        element.getClassList().remove((Object)"badge");
        Assertions.assertFalse((boolean)element.getClassList().contains((Object)"badge"));
    }

    @Test
    public void bind_nullSignal_throwsNPE() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        Assertions.assertThrows(NullPointerException.class, () -> element.getClassList().bind("badge", null));
    }

    @Test
    public void rebinding_alreadyBound_throws() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal s1 = new ValueSignal((Object)true);
        ValueSignal s2 = new ValueSignal((Object)false);
        element.getClassList().bind("tag", (Signal)s1);
        Assertions.assertTrue((boolean)element.getClassList().contains((Object)"tag"));
        Assertions.assertThrows(BindingActiveException.class, () -> element.getClassList().bind("tag", (Signal)s2));
    }

    @Test
    public void internalUpdatesDoNotThrowOrRecurse() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)false);
        element.getClassList().bind("spin", (Signal)signal);
        signal.set((Object)true);
        signal.set((Object)true);
        Assertions.assertTrue((boolean)element.getClassList().contains((Object)"spin"));
        Assertions.assertEquals((long)1L, (long)element.getClassList().stream().filter("spin"::equals).count());
        signal.set((Object)false);
        signal.set((Object)false);
        Assertions.assertFalse((boolean)element.getClassList().contains((Object)"spin"));
    }

    @Test
    public void lazyInitSignalBindingFeature() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        element.getClassList().add((Object)"spin");
        Assertions.assertTrue((boolean)element.getClassList().contains((Object)"spin"));
        element.getNode().getFeatureIfInitialized(SignalBindingFeature.class).ifPresent(feature -> Assertions.fail((String)"SignalBindingFeature should not be initialized before binding a signal"));
        ValueSignal signal = new ValueSignal((Object)false);
        element.getClassList().bind("spin", (Signal)signal);
        element.getNode().getFeatureIfInitialized(SignalBindingFeature.class).orElseThrow(() -> new AssertionError((Object)"SignalBindingFeature should be initialized after binding a signal"));
    }
}

