/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.dom.Node;
import com.vaadin.flow.dom.NodeVisitor;
import com.vaadin.flow.dom.ShadowRoot;
import com.vaadin.flow.dom.TestNodeVisitor;
import com.vaadin.flow.dom.impl.BasicElementStateProvider;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.ShadowRootData;
import com.vaadin.flow.internal.nodefeature.VirtualChildrenList;
import com.vaadin.flow.server.VaadinRequest;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BasicElementStateProviderTest {
    BasicElementStateProviderTest() {
    }

    @Test
    public void supportsSelfCreatedNode() {
        BasicElementStateProvider provider = BasicElementStateProvider.get();
        StateNode node = BasicElementStateProvider.createStateNode((String)"foo");
        Assertions.assertTrue((boolean)provider.supports(node));
    }

    @Test
    public void doesNotSupportEmptyNode() {
        BasicElementStateProvider provider = BasicElementStateProvider.get();
        Assertions.assertFalse((boolean)provider.supports(new StateNode(new Class[0])));
    }

    @Test
    public void supportsUIRootNode() {
        BasicElementStateProvider provider = BasicElementStateProvider.get();
        UI ui = new UI(){

            protected void init(VaadinRequest request) {
            }
        };
        StateNode rootNode = ui.getInternals().getStateTree().getRootNode();
        Assertions.assertTrue((boolean)provider.supports(rootNode));
    }

    @Test
    public void getParent_parentNodeIsNull_parentIsNull() {
        Element div = ElementFactory.createDiv();
        Assertions.assertNull((Object)BasicElementStateProvider.get().getParent(div.getNode()));
    }

    @Test
    public void getParent_parentNodeIsNotNull_parentIsNotNull() {
        Element parent = ElementFactory.createDiv();
        Element child = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child});
        Assertions.assertEquals((Object)parent, (Object)BasicElementStateProvider.get().getParent(child.getNode()));
    }

    @Test
    public void getParent_parentNodeIsShadowRootNode_parentIsShadowRoot() {
        ShadowRoot parent = ElementFactory.createDiv().attachShadow();
        Element child = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child});
        Assertions.assertEquals((Object)parent, (Object)BasicElementStateProvider.get().getParent(child.getNode()));
    }

    @Test
    public void createStateNode_stateNodeHasRequiredElementDataFeature() {
        StateNode stateNode = BasicElementStateProvider.createStateNode((String)"div");
        Assertions.assertTrue((boolean)stateNode.isReportedFeature(ElementData.class));
    }

    @Test
    public void visitOnlyNode_hasDescendants_nodeVisitedAndNoDescendantsVisited() {
        TestNodeVisitor visitor = new TestNodeVisitor(false);
        HashMap map = new HashMap();
        Element subject = this.createHierarchy(map);
        BasicElementStateProvider.get().visit(subject.getNode(), (NodeVisitor)visitor);
        Assertions.assertEquals((int)1, (int)visitor.getVisited().size());
        Assertions.assertEquals((Object)subject, visitor.getVisited().keySet().iterator().next());
        Assertions.assertEquals((Object)NodeVisitor.ElementType.REGULAR, (Object)visitor.getVisited().values().iterator().next());
    }

    @Test
    public void visitOnlyNode_hasDescendants_nodeAndDescendatnsAreVisited() {
        TestNodeVisitor visitor = new TestNodeVisitor(true);
        HashMap map = new HashMap();
        Element subject = this.createHierarchy(map);
        BasicElementStateProvider.get().visit(subject.getNode(), (NodeVisitor)visitor);
        Assertions.assertTrue((map.size() > 1 ? 1 : 0) != 0);
        Assertions.assertEquals(map, visitor.getVisited(), (String)"The collected descendants doesn't match expected descendatns");
    }

    @Test
    public void visitNode_noChildren_featuresNotInitialized() {
        Element element = ElementFactory.createDiv();
        BasicElementStateProviderTest.assertNoChildFeatures(element);
        element.accept((NodeVisitor)new TestNodeVisitor(true));
        BasicElementStateProviderTest.assertNoChildFeatures(element);
    }

    public static void assertNoChildFeatures(Element element) {
        Assertions.assertFalse((boolean)BasicElementStateProviderTest.isFeatureInitialized(element, ElementChildrenList.class), (String)"Node should not have a children list feature");
        Assertions.assertFalse((boolean)BasicElementStateProviderTest.isFeatureInitialized(element, VirtualChildrenList.class), (String)"Node should not have a virtual children list feature");
        Assertions.assertFalse((boolean)BasicElementStateProviderTest.isFeatureInitialized(element, ShadowRootData.class), (String)"Node should not have a shadow root feature");
    }

    @Test
    public void setVisible() {
        Element element = ElementFactory.createDiv();
        Assertions.assertTrue((boolean)((ElementData)element.getNode().getFeature(ElementData.class)).isVisible());
        BasicElementStateProvider.get().setVisible(element.getNode(), true);
        Assertions.assertTrue((boolean)((ElementData)element.getNode().getFeature(ElementData.class)).isVisible());
        BasicElementStateProvider.get().setVisible(element.getNode(), false);
        Assertions.assertFalse((boolean)((ElementData)element.getNode().getFeature(ElementData.class)).isVisible());
    }

    private static boolean isFeatureInitialized(Element element, Class<? extends NodeFeature> featureType) {
        return element.getNode().getFeatureIfInitialized(featureType).isPresent();
    }

    private Element createHierarchy(Map<Node<?>, NodeVisitor.ElementType> map) {
        Element root = ElementFactory.createDiv();
        map.put((Node<?>)root, NodeVisitor.ElementType.REGULAR);
        ShadowRoot shadowRoot = root.attachShadow();
        map.put((Node<?>)shadowRoot, (NodeVisitor.ElementType)null);
        Element shadowChild = ElementFactory.createAnchor();
        Element shadowVirtualChild = ElementFactory.createBr();
        shadowRoot.appendChild(new Element[]{shadowChild});
        shadowRoot.appendVirtualChild(new Element[]{shadowVirtualChild});
        map.put((Node<?>)shadowChild, NodeVisitor.ElementType.REGULAR);
        map.put((Node<?>)shadowVirtualChild, NodeVisitor.ElementType.VIRTUAL);
        Element child = ElementFactory.createDiv();
        root.appendChild(new Element[]{child});
        map.put((Node<?>)child, NodeVisitor.ElementType.REGULAR);
        Element virtualChild = ElementFactory.createDiv();
        root.appendVirtualChild(new Element[]{virtualChild});
        map.put((Node<?>)virtualChild, NodeVisitor.ElementType.VIRTUAL);
        Element virtualGrandChild = ElementFactory.createDiv();
        child.getStateProvider().appendVirtualChild(child.getNode(), virtualGrandChild, "@id", "id");
        map.put((Node<?>)virtualGrandChild, NodeVisitor.ElementType.VIRTUAL_ATTACHED);
        return root;
    }
}

