/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.tests.util.MockUI;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

class PageWakeLockTest {
    PageWakeLockTest() {
    }

    @Test
    void requestWakeLock_executesCorrectJs() {
        MockUI ui = new MockUI();
        Page page = new Page((UI)ui);
        page.requestWakeLock();
        List<PendingJavaScriptInvocation> invocations = ui.dumpPendingJsInvocations();
        Assertions.assertTrue((boolean)invocations.stream().anyMatch(i -> i.getInvocation().getExpression().contains("window.Vaadin.Flow.wakeLock.request")));
    }

    @Test
    void releaseWakeLock_executesCorrectJs() {
        MockUI ui = new MockUI();
        Page page = new Page((UI)ui);
        page.releaseWakeLock();
        List<PendingJavaScriptInvocation> invocations = ui.dumpPendingJsInvocations();
        Assertions.assertTrue((boolean)invocations.stream().anyMatch(i -> i.getInvocation().getExpression().contains("window.Vaadin.Flow.wakeLock.release()")));
    }

    @Test
    void isWakeLockActive_executesCorrectJs() {
        MockUI ui = new MockUI();
        Page page = new Page((UI)ui);
        page.isWakeLockActive();
        List<PendingJavaScriptInvocation> invocations = ui.dumpPendingJsInvocations();
        Assertions.assertTrue((boolean)invocations.stream().anyMatch(i -> i.getInvocation().getExpression().contains("window.Vaadin.Flow.wakeLock.isActive()")));
    }

    @Test
    void addWakeLockReleaseListener_notifiedOnRelease() {
        MockUI ui = new MockUI();
        Page page = new Page((UI)ui);
        AtomicInteger count = new AtomicInteger();
        page.addWakeLockReleaseListener(count::incrementAndGet);
        this.fireWakeLockReleaseEvent(ui);
        Assertions.assertTrue((count.get() == 1 ? 1 : 0) != 0);
    }

    private void fireWakeLockReleaseEvent(MockUI ui) {
        ObjectNode eventData = JacksonUtils.createObjectNode();
        ((ElementListenerMap)ui.getElement().getNode().getFeature(ElementListenerMap.class)).fireEvent(new DomEvent(ui.getElement(), "vaadin-wakelock-release", (JsonNode)eventData));
    }
}

