/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.component.page.PageVisibility;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.local.ValueSignal;
import com.vaadin.tests.util.MockUI;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

class PageVisibilitySignalTest {
    PageVisibilitySignalTest() {
    }

    @Test
    void pageVisibilitySignal_isReadOnly() {
        Page page = new Page((UI)new MockUI());
        Signal signal = page.pageVisibilitySignal();
        Assertions.assertFalse((boolean)(signal instanceof ValueSignal), (String)"pageVisibilitySignal() should return a read-only signal");
    }

    @Test
    void pageVisibilitySignal_defaultsToVisible() {
        Page page = new Page((UI)new MockUI());
        Signal signal = page.pageVisibilitySignal();
        Assertions.assertEquals((Object)PageVisibility.VISIBLE, (Object)signal.get());
    }

    @Test
    void pageVisibilitySignal_tracksVisibilityChanges() {
        MockUI ui = new MockUI();
        Page page = new Page((UI)ui);
        Signal signal = page.pageVisibilitySignal();
        Assertions.assertEquals((Object)PageVisibility.VISIBLE, (Object)signal.get());
        this.fireVisibilityEvent(ui, "HIDDEN");
        Assertions.assertEquals((Object)PageVisibility.HIDDEN, (Object)signal.get());
        this.fireVisibilityEvent(ui, "VISIBLE");
        Assertions.assertEquals((Object)PageVisibility.VISIBLE, (Object)signal.get());
        this.fireVisibilityEvent(ui, "VISIBLE_NOT_FOCUSED");
        Assertions.assertEquals((Object)PageVisibility.VISIBLE_NOT_FOCUSED, (Object)signal.get());
    }

    private void fireVisibilityEvent(MockUI ui, String visibility) {
        ObjectNode eventData = JacksonUtils.createObjectNode();
        eventData.put("event.detail", visibility);
        eventData.put("for", "trailing");
        ((ElementListenerMap)ui.getElement().getNode().getFeature(ElementListenerMap.class)).fireEvent(new DomEvent(ui.getElement(), "vaadin-page-visibility-change", (JsonNode)eventData));
    }
}

