/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.component.page.ScreenOrientation;
import com.vaadin.flow.component.page.ScreenOrientationData;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.local.ValueSignal;
import com.vaadin.tests.util.MockUI;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

class PageScreenOrientationTest {
    PageScreenOrientationTest() {
    }

    @Test
    void lockOrientation_executesCorrectJs() {
        MockUI ui = new MockUI();
        Page page = new Page((UI)ui);
        page.lockOrientation(ScreenOrientation.LANDSCAPE_PRIMARY);
        List<PendingJavaScriptInvocation> invocations = ui.dumpPendingJsInvocations();
        Assertions.assertTrue((boolean)invocations.stream().anyMatch(i -> i.getInvocation().getExpression().contains("window.Vaadin.Flow.screenOrientation.lock")));
    }

    @Test
    void unlockOrientation_executesCorrectJs() {
        MockUI ui = new MockUI();
        Page page = new Page((UI)ui);
        page.unlockOrientation();
        List<PendingJavaScriptInvocation> invocations = ui.dumpPendingJsInvocations();
        Assertions.assertTrue((boolean)invocations.stream().anyMatch(i -> i.getInvocation().getExpression().contains("window.Vaadin.Flow.screenOrientation.unlock()")));
    }

    @Test
    void screenOrientationSignal_returnsReadOnlySignal() {
        Page page = new Page((UI)new MockUI());
        Signal signal = page.screenOrientationSignal();
        Assertions.assertFalse((boolean)(signal instanceof ValueSignal), (String)"screenOrientationSignal() should return a read-only signal");
    }

    @Test
    void screenOrientationSignal_updatedOnOrientationChange() {
        MockUI ui = new MockUI();
        Page page = new Page((UI)ui);
        Signal signal = page.screenOrientationSignal();
        Assertions.assertEquals((Object)ScreenOrientation.PORTRAIT_PRIMARY, (Object)((ScreenOrientationData)signal.get()).type());
        Assertions.assertEquals((int)0, (int)((ScreenOrientationData)signal.get()).angle());
        this.fireOrientationChangeEvent(ui, "landscape-primary", 90);
        Assertions.assertEquals((Object)ScreenOrientation.LANDSCAPE_PRIMARY, (Object)((ScreenOrientationData)signal.get()).type());
        Assertions.assertEquals((int)90, (int)((ScreenOrientationData)signal.get()).angle());
    }

    @Test
    void screenOrientationData_recordAccessors() {
        ScreenOrientationData data = new ScreenOrientationData(ScreenOrientation.LANDSCAPE_SECONDARY, 270);
        Assertions.assertEquals((Object)ScreenOrientation.LANDSCAPE_SECONDARY, (Object)data.type());
        Assertions.assertEquals((int)270, (int)data.angle());
    }

    @Test
    void screenOrientation_fromClientValue() {
        Assertions.assertEquals((Object)ScreenOrientation.PORTRAIT_PRIMARY, (Object)ScreenOrientation.fromClientValue((String)"portrait-primary"));
        Assertions.assertEquals((Object)ScreenOrientation.PORTRAIT_SECONDARY, (Object)ScreenOrientation.fromClientValue((String)"portrait-secondary"));
        Assertions.assertEquals((Object)ScreenOrientation.LANDSCAPE_PRIMARY, (Object)ScreenOrientation.fromClientValue((String)"landscape-primary"));
        Assertions.assertEquals((Object)ScreenOrientation.LANDSCAPE_SECONDARY, (Object)ScreenOrientation.fromClientValue((String)"landscape-secondary"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ScreenOrientation.fromClientValue((String)"unknown"));
    }

    private void fireOrientationChangeEvent(MockUI ui, String type, int angle) {
        ObjectNode eventData = JacksonUtils.createObjectNode();
        eventData.put("event.orientationType", type);
        eventData.put("event.orientationAngle", angle);
        ((ElementListenerMap)ui.getElement().getNode().getFeature(ElementListenerMap.class)).fireEvent(new DomEvent(ui.getElement(), "vaadin-orientation-change", (JsonNode)eventData));
    }
}

