/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.page.ColorScheme;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ColorSchemeTest {
    ColorSchemeTest() {
    }

    @Test
    public void getValue_returnsCorrectValue() {
        Assertions.assertEquals((Object)"light", (Object)ColorScheme.Value.LIGHT.getValue());
        Assertions.assertEquals((Object)"dark", (Object)ColorScheme.Value.DARK.getValue());
        Assertions.assertEquals((Object)"light dark", (Object)ColorScheme.Value.LIGHT_DARK.getValue());
        Assertions.assertEquals((Object)"dark light", (Object)ColorScheme.Value.DARK_LIGHT.getValue());
        Assertions.assertEquals((Object)"normal", (Object)ColorScheme.Value.NORMAL.getValue());
        Assertions.assertEquals((Object)"light dark", (Object)ColorScheme.Value.SYSTEM.getValue());
    }

    @Test
    public void getThemeValue_singleValue_returnsUnchanged() {
        Assertions.assertEquals((Object)"light", (Object)ColorScheme.Value.LIGHT.getThemeValue());
        Assertions.assertEquals((Object)"dark", (Object)ColorScheme.Value.DARK.getThemeValue());
        Assertions.assertEquals((Object)"normal", (Object)ColorScheme.Value.NORMAL.getThemeValue());
    }

    @Test
    public void getThemeValue_multiValue_replacesSpaceWithHyphen() {
        Assertions.assertEquals((Object)"light-dark", (Object)ColorScheme.Value.LIGHT_DARK.getThemeValue());
        Assertions.assertEquals((Object)"dark-light", (Object)ColorScheme.Value.DARK_LIGHT.getThemeValue());
        Assertions.assertEquals((Object)"light-dark", (Object)ColorScheme.Value.SYSTEM.getThemeValue());
    }

    @Test
    public void fromString_validValues_returnsCorrectEnum() {
        Assertions.assertEquals((Object)ColorScheme.Value.LIGHT, (Object)ColorScheme.Value.fromString((String)"light"));
        Assertions.assertEquals((Object)ColorScheme.Value.DARK, (Object)ColorScheme.Value.fromString((String)"dark"));
        Assertions.assertEquals((Object)ColorScheme.Value.LIGHT_DARK, (Object)ColorScheme.Value.fromString((String)"light dark"));
        Assertions.assertEquals((Object)ColorScheme.Value.DARK_LIGHT, (Object)ColorScheme.Value.fromString((String)"dark light"));
        Assertions.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)ColorScheme.Value.fromString((String)"normal"));
    }

    @Test
    public void fromString_nullOrEmpty_returnsNormal() {
        Assertions.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)ColorScheme.Value.fromString(null));
        Assertions.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)ColorScheme.Value.fromString((String)""));
    }

    @Test
    public void fromString_unrecognizedValue_returnsNormal() {
        Assertions.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)ColorScheme.Value.fromString((String)"invalid"));
        Assertions.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)ColorScheme.Value.fromString((String)"light-dark"));
    }

    @Test
    public void fromString_lightDark_returnsLightDarkNotSystem() {
        Assertions.assertEquals((Object)ColorScheme.Value.LIGHT_DARK, (Object)ColorScheme.Value.fromString((String)"light dark"));
        Assertions.assertEquals((Object)ColorScheme.Value.LIGHT_DARK.getValue(), (Object)ColorScheme.Value.SYSTEM.getValue());
    }
}

