/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.component.page.Clipboard;
import com.vaadin.flow.component.page.ClipboardCopy;
import com.vaadin.flow.component.page.ClipboardEvent;
import com.vaadin.flow.component.page.ClipboardFile;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import com.vaadin.tests.util.MockUI;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClipboardTest {
    private MockUI ui;

    @Before
    public void setUp() {
        this.ui = new MockUI();
    }

    @After
    public void tearDown() {
        this.ui = null;
    }

    @Test
    public void copyOnClick_setsPropertyAndInstallsHandler() {
        TestButton button = new TestButton();
        this.ui.add(new Component[]{button});
        ClipboardCopy handle = Clipboard.copyOnClick((Component)button, (String)"test text");
        Assert.assertNotNull((Object)handle);
        Assert.assertEquals((Object)"test text", (Object)button.getElement().getProperty("__clipboardText"));
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assert.assertFalse((String)"Should have JS invocations", (boolean)invocations.isEmpty());
        String js = invocations.get(invocations.size() - 1).getInvocation().getExpression();
        Assert.assertTrue((String)"Should call setupCopyOnClick", (boolean)js.contains("clipboard.setupCopyOnClick"));
    }

    @Test
    public void copyOnClick_nullText_setsEmptyProperty() {
        TestButton button = new TestButton();
        this.ui.add(new Component[]{button});
        Clipboard.copyOnClick((Component)button, (String)null);
        Assert.assertEquals((Object)"", (Object)button.getElement().getProperty("__clipboardText"));
    }

    @Test(expected=NullPointerException.class)
    public void copyOnClick_nullTrigger_throws() {
        Clipboard.copyOnClick(null, (String)"text");
    }

    @Test
    public void copyOnClick_remove_executesCleanupJs() {
        TestButton button = new TestButton();
        this.ui.add(new Component[]{button});
        ClipboardCopy handle = Clipboard.copyOnClick((Component)button, (String)"text");
        this.ui.dumpPendingJsInvocations();
        handle.remove();
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assert.assertFalse((String)"Should have cleanup JS invocations", (boolean)invocations.isEmpty());
        String js = invocations.get(0).getInvocation().getExpression();
        Assert.assertTrue((String)"Should call cleanupCopyOnClick", (boolean)js.contains("clipboard.cleanupCopyOnClick"));
    }

    @Test
    public void copyOnClick_updateValue_changesProperty() {
        TestButton button = new TestButton();
        this.ui.add(new Component[]{button});
        ClipboardCopy handle = Clipboard.copyOnClick((Component)button, (String)"initial");
        Assert.assertEquals((Object)"initial", (Object)button.getElement().getProperty("__clipboardText"));
        handle.setValue("updated");
        Assert.assertEquals((Object)"updated", (Object)button.getElement().getProperty("__clipboardText"));
    }

    @Test
    public void copyOnClickWithCallbacks_installsHandlerWithChannels() {
        TestButton button = new TestButton();
        this.ui.add(new Component[]{button});
        AtomicBoolean successCalled = new AtomicBoolean(false);
        AtomicBoolean errorCalled = new AtomicBoolean(false);
        ClipboardCopy handle = Clipboard.copyOnClick((Component)button, (String)"text", (Command & Serializable)() -> successCalled.set(true), (Command & Serializable)() -> errorCalled.set(true));
        Assert.assertNotNull((Object)handle);
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assert.assertFalse((boolean)invocations.isEmpty());
        boolean foundClipboardSetup = invocations.stream().anyMatch(inv -> inv.getInvocation().getExpression().contains("clipboard.setupCopyOnClickWithCallbacks"));
        Assert.assertTrue((String)"Should call setupCopyOnClickWithCallbacks", (boolean)foundClipboardSetup);
    }

    @Test
    public void copyOnClickWithSource_installsHandler() {
        TestButton button = new TestButton();
        TestTextField source = new TestTextField();
        this.ui.add(new Component[]{button});
        this.ui.add(new Component[]{source});
        ClipboardCopy handle = Clipboard.copyOnClick((Component)button, (Component)source);
        Assert.assertNotNull((Object)handle);
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assert.assertFalse((boolean)invocations.isEmpty());
        boolean foundSourceSetup = invocations.stream().anyMatch(inv -> inv.getInvocation().getExpression().contains("clipboard.setupCopyOnClickFromSource"));
        Assert.assertTrue((String)"Should call setupCopyOnClickFromSource", (boolean)foundSourceSetup);
    }

    @Test(expected=NullPointerException.class)
    public void copyOnClickWithSource_nullSource_throws() {
        TestButton button = new TestButton();
        Clipboard.copyOnClick((Component)button, (Component)null);
    }

    @Test
    public void writeText_executesJs() {
        PendingJavaScriptResult result = Clipboard.writeText((UI)this.ui, (String)"hello");
        Assert.assertNotNull((Object)result);
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assert.assertFalse((boolean)invocations.isEmpty());
        PendingJavaScriptInvocation invocation = invocations.get(invocations.size() - 1);
        String js = invocation.getInvocation().getExpression();
        Assert.assertTrue((String)"Should call clipboard.writeText", (boolean)js.contains("clipboard.writeText($0)"));
    }

    @Test
    public void readText_executesJs() {
        AtomicReference result = new AtomicReference();
        Clipboard.readText((UI)this.ui, result::set);
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assert.assertFalse((boolean)invocations.isEmpty());
        boolean foundReadText = invocations.stream().anyMatch(inv -> inv.getInvocation().getExpression().contains("clipboard.readText()"));
        Assert.assertTrue((String)"Should call readText", (boolean)foundReadText);
    }

    @Test(expected=NullPointerException.class)
    public void readText_nullCallback_throws() {
        Clipboard.readText((UI)this.ui, null);
    }

    @Test
    public void writeImage_withUrl_executesJs() {
        PendingJavaScriptResult result = Clipboard.writeImage((UI)this.ui, (String)"/images/chart.png");
        Assert.assertNotNull((Object)result);
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assert.assertFalse((boolean)invocations.isEmpty());
        boolean foundWriteImage = invocations.stream().anyMatch(inv -> inv.getInvocation().getExpression().contains("clipboard.writeImage($0)"));
        Assert.assertTrue((String)"Should call clipboard.writeImage", (boolean)foundWriteImage);
    }

    @Test
    public void addCopyListener_registersEventListener() {
        TestDiv div = new TestDiv();
        this.ui.add(new Component[]{div});
        AtomicReference eventRef = new AtomicReference();
        Registration reg = Clipboard.addCopyListener((Component)div, eventRef::set);
        Assert.assertNotNull((Object)reg);
    }

    @Test
    public void addCutListener_registersEventListener() {
        TestDiv div = new TestDiv();
        this.ui.add(new Component[]{div});
        AtomicReference eventRef = new AtomicReference();
        Registration reg = Clipboard.addCutListener((Component)div, eventRef::set);
        Assert.assertNotNull((Object)reg);
    }

    @Test(expected=NullPointerException.class)
    public void addCopyListener_nullTarget_throws() {
        Clipboard.addCopyListener(null, (SerializableConsumer & Serializable)event -> {});
    }

    @Test(expected=NullPointerException.class)
    public void addCopyListener_nullListener_throws() {
        TestDiv div = new TestDiv();
        Clipboard.addCopyListener((Component)div, null);
    }

    @Test(expected=NullPointerException.class)
    public void addPasteListener_nullTarget_throws() {
        Clipboard.addPasteListener(null, (SerializableConsumer & Serializable)event -> {});
    }

    @Test(expected=NullPointerException.class)
    public void addPasteListener_nullListener_throws() {
        TestDiv div = new TestDiv();
        Clipboard.addPasteListener((Component)div, null);
    }

    @Test
    public void pasteState_noFiles_dispatchesImmediately() {
        AtomicReference eventRef = new AtomicReference();
        Clipboard.PasteState state = new Clipboard.PasteState(eventRef::set);
        state.setTextData("hello", "<b>hello</b>", 0);
        Assert.assertNotNull(eventRef.get());
        Assert.assertEquals((Object)"paste", (Object)((ClipboardEvent)eventRef.get()).getType());
        Assert.assertEquals((Object)"hello", (Object)((ClipboardEvent)eventRef.get()).getText());
        Assert.assertEquals((Object)"<b>hello</b>", (Object)((ClipboardEvent)eventRef.get()).getHtml());
        Assert.assertTrue((boolean)((ClipboardEvent)eventRef.get()).getFiles().isEmpty());
    }

    @Test
    public void pasteState_withFiles_waitsForAllFiles() {
        AtomicReference eventRef = new AtomicReference();
        Clipboard.PasteState state = new Clipboard.PasteState(eventRef::set);
        state.setTextData("text", null, 2);
        Assert.assertNull((String)"Should not dispatch yet", eventRef.get());
        state.addFile(new ClipboardFile("file1.png", "image/png", 100L, new byte[100]));
        Assert.assertNull((String)"Should not dispatch yet", eventRef.get());
        state.addFile(new ClipboardFile("file2.jpg", "image/jpeg", 200L, new byte[200]));
        Assert.assertNotNull((String)"Should dispatch after all files arrived", eventRef.get());
        Assert.assertEquals((long)2L, (long)((ClipboardEvent)eventRef.get()).getFiles().size());
        Assert.assertEquals((Object)"text", (Object)((ClipboardEvent)eventRef.get()).getText());
    }

    @Test
    public void pasteState_filesArriveBefore_textData() {
        AtomicReference eventRef = new AtomicReference();
        Clipboard.PasteState state = new Clipboard.PasteState(eventRef::set);
        state.addFile(new ClipboardFile("f.txt", "text/plain", 10L, new byte[10]));
        Assert.assertNull((String)"Should not dispatch without text data", eventRef.get());
        state.setTextData("text", null, 1);
        Assert.assertNull((String)"File added before setTextData was cleared", eventRef.get());
        state.addFile(new ClipboardFile("f.txt", "text/plain", 10L, new byte[10]));
        Assert.assertNotNull((String)"Should dispatch now", eventRef.get());
    }

    @Tag(value="button")
    private static class TestButton
    extends Component {
        private TestButton() {
        }
    }

    @Tag(value="input")
    private static class TestTextField
    extends Component {
        private TestTextField() {
        }
    }

    @Tag(value="div")
    private static class TestDiv
    extends Component {
        private TestDiv() {
        }
    }
}

