/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.page.ClipboardCopy;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;

public class ClipboardCopyTest {
    @Test
    public void setValue_updatesProperty() {
        Element element = new Element("button");
        ClipboardCopy copy = new ClipboardCopy(element, Registration.once((Command & Serializable)() -> {}));
        copy.setValue("hello");
        Assert.assertEquals((Object)"hello", (Object)element.getProperty("__clipboardText"));
        copy.setValue("world");
        Assert.assertEquals((Object)"world", (Object)element.getProperty("__clipboardText"));
    }

    @Test
    public void setValueNull_setsEmptyString() {
        Element element = new Element("button");
        ClipboardCopy copy = new ClipboardCopy(element, Registration.once((Command & Serializable)() -> {}));
        copy.setValue(null);
        Assert.assertEquals((Object)"", (Object)element.getProperty("__clipboardText"));
    }

    @Test
    public void remove_callsCleanupRegistration() {
        AtomicBoolean cleaned = new AtomicBoolean(false);
        Element element = new Element("button");
        ClipboardCopy copy = new ClipboardCopy(element, Registration.once((Command & Serializable)() -> cleaned.set(true)));
        copy.remove();
        Assert.assertTrue((boolean)cleaned.get());
    }

    @Test
    public void remove_calledTwice_cleanupRunsOnlyOnce() {
        int[] count = new int[]{0};
        Element element = new Element("button");
        ClipboardCopy copy = new ClipboardCopy(element, Registration.once((Command & Serializable)() -> {
            count[0] = count[0] + 1;
        }));
        copy.remove();
        copy.remove();
        Assert.assertEquals((long)1L, (long)count[0]);
    }
}

