/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.internal.DependencyTreeCache;
import com.vaadin.flow.function.SerializableFunction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DependencyTreeCacheTest {
    DependencyTreeCacheTest() {
    }

    @Test
    public void multipleLevels_allIncluded_noneParsedAgain() {
        MockParser parser = new MockParser().addResult("/a", "/b").addResult("/b", "/c").addResult("/c", new String[0]);
        DependencyTreeCache cache = new DependencyTreeCache((SerializableFunction)parser);
        Set dependencies = cache.getDependencies((Object)"/a");
        parser.assertConsumed();
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("/a", "/b", "/c")), (Object)dependencies);
        Set dependencies2 = cache.getDependencies((Object)"/a");
        Assertions.assertEquals((Object)dependencies, (Object)dependencies2);
    }

    @Test
    public void sharedDependency_onlyParsedOnce() {
        MockParser parser = new MockParser().addResult("/a", "/b", "/c").addResult("/b", "/d").addResult("/c", "/d").addResult("/d", new String[0]);
        DependencyTreeCache cache = new DependencyTreeCache((SerializableFunction)parser);
        Set dependencies = cache.getDependencies((Object)"/a");
        parser.assertConsumed();
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("/a", "/b", "/c", "/d")), (Object)dependencies);
    }

    @Test
    public void concurrentParse_onlyParsedOnce() throws InterruptedException {
        MockParser parser = new MockParser();
        parser.addResult("/a", "/b");
        parser.addResult("/b", 100, new String[0]);
        DependencyTreeCache cache = new DependencyTreeCache((SerializableFunction)parser);
        long start = System.currentTimeMillis();
        HashSet threadResult = new HashSet();
        Thread thread = new Thread(() -> threadResult.addAll(cache.getDependencies((Object)"/a")));
        thread.start();
        Set dependencies = cache.getDependencies((Object)"/a");
        thread.join();
        long end = System.currentTimeMillis();
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("/a", "/b")), (Object)dependencies);
        Assertions.assertEquals((Object)dependencies, threadResult);
        long duration = end - start;
        Assertions.assertTrue((duration < 200L ? 1 : 0) != 0);
        Assertions.assertTrue((duration >= 100L ? 1 : 0) != 0, (String)("Parsing should take at least 100 ms, was " + duration));
    }

    @Test
    public void parallelParsing_potentialSpeedup() throws InterruptedException {
        int maxDuration = Integer.MIN_VALUE;
        int minDuration = Integer.MAX_VALUE;
        int iterationCount = 0;
        while (minDuration > 75 || maxDuration < 75) {
            if (iterationCount++ > 30) {
                Assertions.fail((String)("Did not observe both slowdown and speedup. Max duration: " + maxDuration + ", min duration: " + minDuration));
            }
            MockParser parser = new MockParser().addResult("/a", 25, "/b", "/c").addResult("/b", 25, new String[0]).addResult("/c", 25, new String[0]);
            DependencyTreeCache cache = new DependencyTreeCache((SerializableFunction)parser);
            Thread thread = new Thread(() -> cache.getDependencies((Object)"/a"));
            long start = System.currentTimeMillis();
            thread.start();
            cache.getDependencies((Object)"/a");
            thread.join();
            long end = System.currentTimeMillis();
            int duration = (int)(end - start);
            Assertions.assertTrue((duration >= 50 ? 1 : 0) != 0, (String)("Duration should never be less than 50, was " + duration));
            maxDuration = Math.max(maxDuration, duration);
            minDuration = Math.min(minDuration, duration);
        }
    }

    private static class MockParser
    implements SerializableFunction<String, Collection<String>> {
        private static final Supplier<Collection<String>> USED_PLACEHOLDER = () -> Collections.emptySet();
        private Map<String, Supplier<Collection<String>>> items = new ConcurrentHashMap<String, Supplier<Collection<String>>>();

        private MockParser() {
        }

        public Collection<String> apply(String path) {
            Supplier<Collection<String>> supplier = this.items.put(path = path.replaceFirst("^frontend://", ""), USED_PLACEHOLDER);
            if (supplier == USED_PLACEHOLDER) {
                Assertions.fail((String)("Path " + path + " has already been parsed"));
            } else if (supplier == null) {
                Assertions.fail((String)("Parser cannot find " + path));
            }
            return supplier.get();
        }

        public MockParser addResult(String path, String ... dependencies) {
            return this.addResult(path, (Blocker)null, dependencies);
        }

        public MockParser addResult(String path, int duration, String ... dependencies) {
            return this.addResult(path, () -> Thread.sleep(duration), dependencies);
        }

        public MockParser addResult(String path, Blocker blocker, String ... dependencies) {
            this.items.put(path, () -> {
                if (blocker != null) {
                    try {
                        blocker.block();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                return Arrays.asList(dependencies);
            });
            return this;
        }

        public void assertConsumed() {
            this.items.forEach((path, value) -> Assertions.assertSame(USED_PLACEHOLDER, (Object)value, (String)(path + " should have been parsed")));
        }
    }

    @FunctionalInterface
    private static interface Blocker {
        public void block() throws InterruptedException;
    }
}

