/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.local.ValueSignal;
import com.vaadin.tests.util.MockUI;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

class ComponentSizeSignalTest {
    ComponentSizeSignalTest() {
    }

    @Test
    void sizeSignal_isReadOnly() {
        MockUI ui = new MockUI();
        TestDiv div = new TestDiv();
        ui.add(new Component[]{div});
        Signal signal = div.sizeSignal();
        Assertions.assertFalse((boolean)(signal instanceof ValueSignal), (String)"sizeSignal() should return a read-only signal");
    }

    @Test
    void sizeSignal_defaultValue_isZeroByZero() {
        MockUI ui = new MockUI();
        TestDiv div = new TestDiv();
        ui.add(new Component[]{div});
        Signal signal = div.sizeSignal();
        Assertions.assertEquals((Object)new Component.Size(0, 0), (Object)signal.get());
    }

    @Test
    void sizeSignal_returnsSameInstance() {
        MockUI ui = new MockUI();
        TestDiv div = new TestDiv();
        ui.add(new Component[]{div});
        Signal first = div.sizeSignal();
        Signal second = div.sizeSignal();
        this.fireComponentResizeEvent(ui, 0, 640, 480);
        Assertions.assertEquals((Object)new Component.Size(640, 480), (Object)first.get());
        Assertions.assertEquals((Object)new Component.Size(640, 480), (Object)second.get());
    }

    @Test
    void sizeSignal_updatesOnResizeEvent() {
        MockUI ui = new MockUI();
        TestDiv div = new TestDiv();
        ui.add(new Component[]{div});
        Signal signal = div.sizeSignal();
        Assertions.assertEquals((Object)new Component.Size(0, 0), (Object)signal.get());
        this.fireComponentResizeEvent(ui, 0, 800, 600);
        Assertions.assertEquals((Object)new Component.Size(800, 600), (Object)signal.get());
        this.fireComponentResizeEvent(ui, 0, 1024, 768);
        Assertions.assertEquals((Object)new Component.Size(1024, 768), (Object)signal.get());
    }

    private void fireComponentResizeEvent(MockUI ui, int componentId, int width, int height) {
        ObjectNode eventData = JacksonUtils.createObjectNode();
        ObjectNode sizes = JacksonUtils.createObjectNode();
        ObjectNode sizeEntry = JacksonUtils.createObjectNode();
        sizeEntry.put("w", width);
        sizeEntry.put("h", height);
        sizes.set(String.valueOf(componentId), (JsonNode)sizeEntry);
        eventData.set("event.sizes", (JsonNode)sizes);
        eventData.put("for", "trailing");
        ((ElementListenerMap)ui.getElement().getNode().getFeature(ElementListenerMap.class)).fireEvent(new DomEvent(ui.getElement(), "vaadin-component-resize", (JsonNode)eventData));
    }

    @Tag(value="div")
    private static class TestDiv
    extends Component {
        private TestDiv() {
        }
    }
}

