/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.dom.ElementUtil;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.dom.impl.BasicElementStyle;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.AbstractPropertyMap;
import com.vaadin.flow.internal.nodefeature.NodeMap;
import java.io.Serializable;
import java.util.Objects;

public class ElementStylePropertyMap
extends AbstractPropertyMap {
    public ElementStylePropertyMap(StateNode node) {
        super(node);
    }

    @Override
    public void setProperty(String name, Serializable value, boolean emitChange) {
        assert (value instanceof String);
        assert (ElementUtil.isValidStylePropertyValue((String)((Object)value)));
        super.setProperty(name, value, emitChange);
    }

    @Override
    public void setPropertyFromSignal(String name, Object value) {
        Object newEffective;
        Serializable currentEffective;
        Serializable currentRaw = super.get(name);
        if (currentRaw instanceof NodeMap.SignalBinding) {
            NodeMap.SignalBinding binding = (NodeMap.SignalBinding)currentRaw;
            currentEffective = binding.value();
        } else {
            currentEffective = currentRaw;
        }
        Object object = newEffective = value == null ? "" : value;
        if (Objects.equals(currentEffective, newEffective)) {
            return;
        }
        if (value == null) {
            super.setProperty(name, (Serializable)((Object)""), true);
        } else {
            this.setProperty(name, (Serializable)value, true);
        }
    }

    @Override
    protected Serializable get(String key) {
        Serializable value = super.get(key);
        if (value instanceof NodeMap.SignalBinding) {
            String stringValue;
            NodeMap.SignalBinding binding = (NodeMap.SignalBinding)value;
            Serializable signalValue = binding.value();
            if (signalValue instanceof String && (stringValue = (String)((Object)signalValue)).isEmpty()) {
                return null;
            }
            return signalValue;
        }
        return value;
    }

    @Override
    public void removeAllProperties() {
        for (String key : this.getPropertyNames().toList()) {
            NodeMap.SignalBinding binding;
            Serializable raw = super.get(key);
            if (!(raw instanceof NodeMap.SignalBinding) || (binding = (NodeMap.SignalBinding)raw).registration() == null) continue;
            binding.registration().remove();
        }
        super.removeAllProperties();
    }

    @Override
    public boolean hasProperty(String name) {
        Serializable raw = super.get(name);
        if (raw instanceof NodeMap.SignalBinding) {
            String stringValue;
            NodeMap.SignalBinding binding = (NodeMap.SignalBinding)raw;
            Serializable signalValue = binding.value();
            if (signalValue instanceof String && (stringValue = (String)((Object)signalValue)).isEmpty()) {
                return false;
            }
            return signalValue != null;
        }
        return super.hasProperty(name);
    }

    public Style getStyle() {
        return new BasicElementStyle(this);
    }
}

