/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.MessageDigestUtil;
import com.vaadin.flow.server.VaadinService;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StylesheetContentHashUtil {
    private static final int HASH_LENGTH = 8;
    private static final ConcurrentHashMap<String, String> cache = new ConcurrentHashMap();
    private static final Logger logger = LoggerFactory.getLogger(StylesheetContentHashUtil.class);
    private static final String[] CLASSPATH_PREFIXES = new String[]{"META-INF/resources/", "static/", "public/", "resources/"};

    private StylesheetContentHashUtil() {
    }

    public static String getContentHash(VaadinService service, String resourceUrl) {
        if (resourceUrl == null || resourceUrl.isBlank()) {
            return null;
        }
        String lower = resourceUrl.toLowerCase();
        if (lower.startsWith("http://") || lower.startsWith("https://")) {
            return null;
        }
        return cache.computeIfAbsent(resourceUrl, url -> StylesheetContentHashUtil.computeHash(service, url));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String computeHash(VaadinService service, String resourceUrl) {
        try (InputStream stream = StylesheetContentHashUtil.openResource(service, resourceUrl);){
            if (stream == null) {
                logger.debug("Could not compute cache-busting hash for '{}': resource not found. Tried via {} (service class: {}). The stylesheet URL will not have a ?v-c=<hash> parameter.", new Object[]{resourceUrl, StylesheetContentHashUtil.describeAttempts(resourceUrl), service.getClass().getName()});
                String string2 = null;
                return string2;
            }
            byte[] bytes = stream.readAllBytes();
            String fullHash = MessageDigestUtil.sha256Hex(bytes);
            logger.debug("Computed cache-busting hash for '{}': v={} ({} bytes)", new Object[]{resourceUrl, fullHash.substring(0, 8), bytes.length});
            String string = fullHash.substring(0, 8);
            return string;
        }
        catch (IOException e) {
            logger.debug("Failed to read resource for content hashing: '{}' (service class: {})", new Object[]{resourceUrl, service.getClass().getName(), e});
            return null;
        }
    }

    private static String describeAttempts(String resourceUrl) {
        if (resourceUrl.startsWith("/") || resourceUrl.contains("://")) {
            return "getResourceAsStream(\"" + resourceUrl + "\")";
        }
        return "getResourceAsStream(\"" + resourceUrl + "\") and getResourceAsStream(\"/" + resourceUrl + "\")";
    }

    private static InputStream openResource(VaadinService service, String resourceUrl) {
        String withSlash;
        String resolved = service.resolveResource(resourceUrl);
        InputStream stream = service.getResourceAsStream(resourceUrl);
        if (stream != null) {
            logger.debug("Resolved '{}' -> '{}' (found)", (Object)resourceUrl, (Object)resolved);
            return stream;
        }
        logger.debug("Resolved '{}' -> '{}' (not found)", (Object)resourceUrl, (Object)resolved);
        if (!resourceUrl.startsWith("/") && !resourceUrl.contains("://") && (stream = service.getResourceAsStream(withSlash = "/" + resourceUrl)) != null) {
            logger.debug("Resolved '{}' (found via '/' prefix fallback)", (Object)resourceUrl);
            return stream;
        }
        stream = StylesheetContentHashUtil.openResourceFromClasspath(resourceUrl);
        return stream;
    }

    private static InputStream openResourceFromClasspath(String resourceUrl) {
        ClassLoader classLoader;
        String path = resourceUrl;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.contains("://")) {
            path = path.substring(path.indexOf("://") + 3);
        }
        if ((classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = StylesheetContentHashUtil.class.getClassLoader();
        }
        for (String prefix : CLASSPATH_PREFIXES) {
            String classpathPath = prefix + path;
            InputStream stream = classLoader.getResourceAsStream(classpathPath);
            if (stream == null) continue;
            logger.debug("Resolved '{}' via classpath '{}'", (Object)resourceUrl, (Object)classpathPath);
            return stream;
        }
        logger.debug("'{}' not found on classpath (tried prefixes: {})", (Object)resourceUrl, (Object)String.join((CharSequence)", ", CLASSPATH_PREFIXES));
        return null;
    }

    public static String appendHashToUrl(String url, String hash) {
        if (hash == null) {
            return url;
        }
        char separator = url.contains("?") ? (char)'&' : '?';
        return url + separator + "v-c=" + hash;
    }
}

