/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HtmlComponent;
import com.vaadin.flow.component.HtmlContainer;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.PropertyChangeDeniedException;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.StreamReceiver;
import com.vaadin.flow.server.StreamVariable;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WrappedSession;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.signals.local.ValueSignal;
import com.vaadin.flow.signals.shared.SharedValueSignal;
import com.vaadin.flow.testutil.ClassesSerializableTest;
import com.vaadin.tests.server.component.SerializedLocalSignalComponent;
import com.vaadin.tests.server.component.SerializedSharedSignalComponent;
import com.vaadin.tests.util.MockUI;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class FlowClassesSerializableTest
extends ClassesSerializableTest {
    FlowClassesSerializableTest() {
    }

    @Test
    public void htmlComponentAndHtmlContainer() throws Throwable {
        Component[] components;
        for (Component component : components = new Component[]{new HtmlComponent("dummy-tag"), new HtmlContainer("dummy-tag")}) {
            Component componentCopy = (Component)this.serializeAndDeserialize(component);
            Assertions.assertEquals((Object)component.getElement().getTag(), (Object)componentCopy.getElement().getTag());
            Assertions.assertNotSame((Object)component.getElement(), (Object)componentCopy.getElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void streamResource() throws Throwable {
        UI ui = new UI();
        UI.setCurrent((UI)ui);
        try {
            Element element = new Element("dummy-element");
            StreamReceiver streamReceiver = new StreamReceiver(element.getNode(), "upload", (StreamVariable)new MyStreamVariable());
            Assertions.assertEquals((Object)ui, (Object)UI.getCurrent());
            element.setAttribute("target", (AbstractStreamResource)streamReceiver);
            this.serializeAndDeserialize(element);
            Assertions.assertTrue((element.getAttribute("target").length() > 10 ? 1 : 0) != 0, (String)"Basic smoke test with ");
        }
        finally {
            UI.setCurrent(null);
        }
    }

    private MockUI setupForSignalSerializationTest() {
        CurrentInstance.clearAll();
        MockVaadinServletService service = new MockVaadinServletService(){
            private final Lock lock = new ReentrantLock();
            {
                this.lock.lock();
            }

            protected Lock getSessionLock(WrappedSession wrappedSession) {
                return this.lock;
            }

            @Override
            public void init() {
                super.init();
                ApplicationConfiguration configuration = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
                Mockito.when((Object)configuration.isProductionMode()).thenReturn((Object)this.getDeploymentConfiguration().isProductionMode());
                Mockito.when((Object)configuration.isDevModeSessionSerializationEnabled()).thenReturn((Object)true);
                this.getContext().setAttribute(ApplicationConfiguration.class, (Object)configuration);
            }
        };
        VaadinService.setCurrent((VaadinService)service);
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        session.refreshTransients(null, (VaadinService)service);
        MockUI ui = new MockUI(session);
        ui.doInit(null, 42, "foo");
        session.addUI(ui);
        return ui;
    }

    @Test
    public void localSignalSerializable() {
        MockUI ui = this.setupForSignalSerializationTest();
        VaadinSession session = ui.getSession();
        VaadinService service = session.getService();
        ValueSignal signal = new ValueSignal((Object)"initial");
        SerializedLocalSignalComponent component = new SerializedLocalSignalComponent((ValueSignal<String>)signal);
        ui.add(new Component[]{component});
        Assertions.assertEquals((int)1, (int)component.effectExecutionCounter);
        signal.set((Object)"changed");
        Assertions.assertEquals((int)2, (int)component.effectExecutionCounter);
        VaadinSession deserializedSession = null;
        session.unlock();
        try {
            deserializedSession = (VaadinSession)this.serializeAndDeserialize(session);
            Assertions.assertNotNull((Object)deserializedSession);
            Assertions.assertNotSame((Object)deserializedSession, (Object)session);
        }
        catch (Throwable e) {
            Assertions.fail((String)("SerializedLocalSignalComponent should be serializable: " + String.valueOf(e.getClass()) + ": " + e.getMessage()));
        }
        deserializedSession.refreshTransients(null, service);
        deserializedSession.lock();
        UI deserializedUi = (UI)deserializedSession.getUIs().iterator().next();
        SerializedLocalSignalComponent deserializedComponent = deserializedUi.getChildren().filter(SerializedLocalSignalComponent.class::isInstance).map(SerializedLocalSignalComponent.class::cast).findFirst().orElseThrow(() -> new AssertionError((Object)"SerializedLocalSignalComponent has not been deserialized"));
        Assertions.assertNotSame((Object)((Object)deserializedComponent), (Object)((Object)component));
        UI.setCurrent((UI)deserializedUi);
        deserializedComponent.signal.set((Object)"changed after deserialization");
        Assertions.assertEquals((int)3, (int)deserializedComponent.effectExecutionCounter);
        deserializedComponent.signal.set((Object)"changed");
        Assertions.assertEquals((int)4, (int)deserializedComponent.effectExecutionCounter);
        signal.set((Object)"changed in original signal");
        Assertions.assertEquals((int)4, (int)deserializedComponent.effectExecutionCounter);
        deserializedComponent.registration.remove();
        deserializedComponent.signal.set((Object)"foo");
        Assertions.assertEquals((int)4, (int)deserializedComponent.effectExecutionCounter);
        Assertions.assertEquals((Object)"foo", (Object)deserializedComponent.getElement().getText());
        Assertions.assertEquals((Object)"foo", (Object)deserializedComponent.getElement().getAttribute("attr"));
        Assertions.assertEquals((Object)"foo", (Object)deserializedComponent.getElement().getProperty("prop"));
        Assertions.assertEquals((Object)"foo!!!", (Object)deserializedComponent.getElement().getProperty("two-way-prop"));
        this.emulateClientUpdate(deserializedComponent.getElement(), "two-way-prop", "bar!!!");
        Assertions.assertEquals((Object)"bar!!!", (Object)deserializedComponent.getElement().getProperty("two-way-prop"));
        Assertions.assertEquals((Object)"bar", (Object)deserializedComponent.signal.peek());
        Assertions.assertTrue((boolean)deserializedComponent.getElement().isEnabled());
        Assertions.assertTrue((boolean)deserializedComponent.getElement().isVisible());
        deserializedComponent.signal.set(null);
        Assertions.assertFalse((boolean)deserializedComponent.getElement().isEnabled());
        Assertions.assertFalse((boolean)deserializedComponent.getElement().isVisible());
        deserializedSession.unlock();
        VaadinService.setCurrent(null);
    }

    @Test
    public void sharedSignalSerializable() {
        MockUI ui = this.setupForSignalSerializationTest();
        VaadinSession session = ui.getSession();
        VaadinService service = session.getService();
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        SerializedSharedSignalComponent component = new SerializedSharedSignalComponent((SharedValueSignal<String>)signal);
        ui.add(new Component[]{component});
        Assertions.assertEquals((int)1, (int)component.effectExecutionCounter);
        signal.set((Object)"changed");
        Assertions.assertEquals((int)2, (int)component.effectExecutionCounter);
        VaadinSession deserializedSession = null;
        session.unlock();
        try {
            deserializedSession = (VaadinSession)this.serializeAndDeserialize(session);
            Assertions.assertNotNull((Object)deserializedSession);
            Assertions.assertNotSame((Object)deserializedSession, (Object)session);
        }
        catch (Throwable e) {
            Assertions.fail((String)("SerializedSharedSignalComponent should be serializable: " + String.valueOf(e.getClass()) + ": " + e.getMessage()));
        }
        deserializedSession.refreshTransients(null, service);
        deserializedSession.lock();
        UI deserializedUi = (UI)deserializedSession.getUIs().iterator().next();
        SerializedSharedSignalComponent deserializedComponent = deserializedUi.getChildren().filter(SerializedSharedSignalComponent.class::isInstance).map(SerializedSharedSignalComponent.class::cast).findFirst().orElseThrow(() -> new AssertionError((Object)"SerializedSharedSignalComponent has not been deserialized"));
        Assertions.assertNotSame((Object)((Object)deserializedComponent), (Object)((Object)component));
        UI.setCurrent((UI)deserializedUi);
        deserializedComponent.signal.set((Object)"changed after deserialization");
        Assertions.assertEquals((int)3, (int)deserializedComponent.effectExecutionCounter);
        deserializedComponent.signal.set((Object)"changed");
        Assertions.assertEquals((int)4, (int)deserializedComponent.effectExecutionCounter);
        signal.set((Object)"changed in original signal");
        Assertions.assertEquals((int)4, (int)deserializedComponent.effectExecutionCounter);
        deserializedComponent.registration.remove();
        deserializedComponent.signal.set((Object)"foo");
        Assertions.assertEquals((int)4, (int)deserializedComponent.effectExecutionCounter);
        deserializedSession.unlock();
        VaadinService.setCurrent(null);
    }

    private void emulateClientUpdate(Element element, String property, String value) {
        ElementPropertyMap childModel = ElementPropertyMap.getModel((StateNode)element.getNode());
        try {
            childModel.deferredUpdateFromClient(property, (Serializable)((Object)value));
        }
        catch (PropertyChangeDeniedException e) {
            Assertions.fail((String)("Failed to update property from client: " + e.getMessage()));
        }
    }

    private static class MyStreamVariable
    implements StreamVariable {
        private MyStreamVariable() {
        }

        public OutputStream getOutputStream() {
            return null;
        }

        public boolean listenProgress() {
            return false;
        }

        public void onProgress(StreamVariable.StreamingProgressEvent event) {
        }

        public void streamingStarted(StreamVariable.StreamingStartEvent event) {
        }

        public void streamingFinished(StreamVariable.StreamingEndEvent event) {
        }

        public void streamingFailed(StreamVariable.StreamingErrorEvent event) {
        }

        public boolean isInterrupted() {
            return false;
        }
    }
}

